<?php
/**
 * Template name: Event page
 *
 * @package Hillter
 */

get_header();

$layout = awe_sidebar_layout_option();
?>

<!-- BLOG -->
<div class="main-wrapper section-blog bg-white">  
     <?php do_action( 'hillter_blog_header' ); ?>
 <div class="container">
		<div class="row">
			<div class="<?php echo esc_attr( $layout['push'] ); ?>">
				<?php
				$paged = get_query_var( 'paged' ) ? absint( get_query_var( 'paged' ) ) : 1;
				$the_query = new WP_Query( 'post_type=event&posts_per_page=' . absint( get_option( 'posts_per_page' ) ) . '&paged=' . absint( $paged ) );
				while ( $the_query->have_posts() ) : $the_query->the_post();
					get_template_part( 'content', 'event-category' );
				endwhile;
				wp_reset_postdata();
				?>

				<?php awe_paging_nav( $the_query ); ?>
			</div>

			<?php if ( '' != $layout['pull'] ) : ?>
				<div class="<?php echo esc_attr( $layout['pull'] ); ?>">
					<?php get_sidebar(); ?>
				</div>
			<?php endif; ?>
		</div>
	</div>
</div>
<!-- END / BLOG -->
<?php get_footer(); ?>
