<?php
/**
 * Coming Soon Template
 *
 * @package Hillter
 * @author Awethemes
 * @return string
 */
global $hillter_option;
$data = isset( $hillter_option['extra']['comingsoon'] ) ? $hillter_option['extra']['comingsoon'] : '';
if ( $data != '' ) :
	$logo      = isset( $hillter_option['extra']['comingsoon']['logo'] ) ? $hillter_option['extra']['comingsoon']['logo'] : '';
	$title     = isset( $hillter_option['extra']['comingsoon']['title'] ) ? $hillter_option['extra']['comingsoon']['title'] : '';
	$sub_title = isset( $hillter_option['extra']['comingsoon']['subtitle'] ) ? $hillter_option['extra']['comingsoon']['subtitle'] : '';
	$desc      = isset( $hillter_option['extra']['comingsoon']['desc'] ) ? $hillter_option['extra']['comingsoon']['desc'] : '';
	$countdown = isset( $hillter_option['extra']['comingsoon']['countdown'] ) ? $hillter_option['extra']['comingsoon']['countdown'] : '';
endif;
?>
<!DOCTYPE html>
<html <?php language_attributes( 'html' ); ?>>
    <head>
		<meta charset="<?php bloginfo( 'charset' ); ?>">

        <meta http-equiv="X-UA-Compatible" content="IE=edge">

        <!-- TITLE -->
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
        <meta name="format-detection" content="telephone=no">
        <meta name="apple-mobile-web-app-capable" content="yes">
		<?php do_action( 'header_favicon' ); ?>
        <link rel="profile" href="http://gmpg.org/xfn/11"/>
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>"/>

        <!--[if lt IE 9]>
        <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
        <script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
        <![endif]-->
		<?php wp_head(); ?>
    </head>
<!--[if IE 7]>
<body class="ie7 lt-ie8 lt-ie9 lt-ie10"> <![endif]-->
<!--[if IE 8]>
<body class="ie8 lt-ie9 lt-ie10"> <![endif]-->
<!--[if IE 9]>
<body class="ie9 lt-ie10"> <![endif]-->
    <!--[if (gt IE 9)|!(IE)]><!-->
<body <?php body_class(); ?>> <!--<![endif]-->

<?php awe_preload(); ?>

<!-- PAGE WRAP -->
<div id="page-wrap">
    <section class="section-comingsoon">
        <div class="awe-overlay"></div>
        <div class="comingsoon text-center">
            <?php if ( isset( $logo ) ) : ?>
    			<a href="<?php echo esc_url( home_url( '/' ) ) ?>">
                    <img src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( $title ); ?>">
    			</a>
			<?php endif; ?>

			<?php if ( isset( $title ) ) : ?>
                <h1><?php echo esc_html( $title ); ?></h1>
			<?php endif; ?>

			<?php if ( isset( $sub_title ) ) : ?>
                <h6><?php echo esc_html( $sub_title ); ?></h6>
   			<?php endif; ?>

   			<?php if ( isset( $desc ) ) : ?>
                <p><?php echo esc_html( $desc ); ?></p>
			<?php endif; ?>

            <div class="countdown">
				<div id="countdown" data-time="<?php echo esc_html( $countdown ); ?>"></div>
            </div>

            <?php
            $social = ! empty( $hillter_option['social'] ) ? ( array ) $hillter_option['social'] : array();
                if ( ! empty( $social ) ) {
                    $social_output = '';
                    $socials = array(
                        'facebook' => 'fa fa-facebook',
                        'google' => 'fa fa-google-plus',
                        'twitter' => 'fa fa-twitter-square',
                        'github' => 'fa fa-github-square',
                        'instagram' => 'fa fa-instagram',
                        'pinterest' => 'fa fa-pinterest',
                        'linkedin' => 'fa fa-linkedin-square',
                        'skype' => 'fa fa-skype',
                        'tumblr' => 'fa fa-tumblr',
                        'youtube' => 'fa fa-youtube',
                        'vimeo' => 'fa fa-vimeo-square',
                        'flickr' => 'fa fa-flickr',
                        'dribbble' => 'fa fa-dribbble',
                    );
                    foreach ($social as $key => $value) {
                        if ( ! empty( $value['enable'] ) ) {
                            $social_output .= '<a href="' . esc_url( $value['url'] ) . '"><i class="' . esc_attr($socials[$key]) . '"></i></a>';
                        }
                    }
                    if ( $social_output ) :
            ?>
                    <div class="widget widget_social">
                        <h4 class="widget-title">Follow Us</h4>
                        <div class="widget-social">
                        <?php print $social_output; ?>
                        </div>
                    </div>
            <?php
                endif;
            }
            ?>

        </div>

    </section>
<?php get_footer();
exit();
?>
