<?php
	if(class_exists('RevSlider'))
	{
		class awe_import_revsilder extends RevSlider{

			/**
			 * @param bool|true $updateAnim
			 * @param bool|true $updateStatic
			 * @param bool|false $exactfilepath
			 * @param bool|false $is_template
			 * @param bool|false $single_slide
             * @return array
             */
			public function importSliderFromPost( $updateAnim = true, $updateStatic = true, $exactfilepath = false, $is_template = false, $single_slide = false, $updateNavigation = true ) {

				try{

					$sliderID = RevSliderFunctions::getPostVariable("sliderid");
					$sliderExists = !empty($sliderID);

					if($sliderExists)
						$this->initByID($sliderID);

					if($exactfilepath !== false){
						$filepath = $exactfilepath;
					}else{
						switch ($_FILES['import_file']['error']) {
							case UPLOAD_ERR_OK:
								break;
							case UPLOAD_ERR_NO_FILE:
								RevSliderFunctions::throwError(__('No file sent.', 'hillter'));
							case UPLOAD_ERR_INI_SIZE:
							case UPLOAD_ERR_FORM_SIZE:
								RevSliderFunctions::throwError(__('Exceeded filesize limit.', 'hillter'));

							default:
								break;
						}
						$filepath = $_FILES["import_file"]["tmp_name"];
					}

					if(file_exists($filepath) == false)
						RevSliderFunctions::throwError("Import file not found!!!");

					//check if zip file or fallback to old, if zip, check if all files exist
					if(!class_exists("ZipArchive")){
						$importZip = false;
					}else{
						$zip = new ZipArchive;
						$importZip = $zip->open($filepath, ZIPARCHIVE::CREATE);

					}

					// Added by ThemeFuzz ( Stefan )
					if ( $importZip === 0 || !$zip->getStream('slider_export.txt') ) {
						if(!$zip->getStream('slider_export.txt')){
							$upload_dir = wp_upload_dir();
							$new_path =  $upload_dir['basedir'].'/'.$_FILES['import_file']['name'];
							move_uploaded_file( $_FILES["import_file"]["tmp_name"], $new_path);
							$importZip = $zip->open( $new_path, ZIPARCHIVE::CREATE);
						}
					}

					if($is_template !== false && $importZip !== true){
						return(array("success"=>false,"error"=>__('Please select the correct zip file', 'hillter')));
					}

					if($importZip === true){ //true or integer. If integer, its not a correct zip file

						//check if files all exist in zip
						$slider_export = $zip->getStream('slider_export.txt');
						$custom_animations = $zip->getStream('custom_animations.txt');
						$dynamic_captions = $zip->getStream('dynamic-captions.css');
						$static_captions = $zip->getStream('static-captions.css');

						$uid_file = $zip->getStream('info.cfg');
						$uid_check = '';
						if($uid_file){ while (!feof($uid_file)) $uid_check .= fread($uid_file, 1024); }

						if($is_template !== false){
							if($uid_check != $is_template){
								return(array("success"=>false,"error"=>__('Please select the correct zip file, checksum failed!', 'hillter')));
							}
						}else{ //someone imported a template base Slider, check if it is existing in Base Sliders, if yes, check if it was imported
							if($uid_check !== ''){
								$tmpl = new RevSliderTemplate();
								$tmpl_slider = $tmpl->getThemePunchTemplateSliders();

								foreach($tmpl_slider as $tp_slider){
									if(!isset($tp_slider['installed'])) continue;

									if($tp_slider['uid'] == $uid_check){
										$is_template = $uid_check;
										break;
									}
								}
							}
						}


						if(!$slider_export)  RevSliderFunctions::throwError("slider_export.txt does not exist!");

						$content = '';
						$animations = '';
						$dynamic = '';
						$static = '';

						while (!feof($slider_export)) $content .= fread($slider_export, 1024);
						if($custom_animations){ while (!feof($custom_animations)) $animations .= fread($custom_animations, 1024); }
						if($dynamic_captions){ while (!feof($dynamic_captions)) $dynamic .= fread($dynamic_captions, 1024); }
						if($static_captions){ while (!feof($static_captions)) $static .= fread($static_captions, 1024); }

						fclose($slider_export);
						if($custom_animations){ fclose($custom_animations); }
						if($dynamic_captions){ fclose($dynamic_captions); }
						if($static_captions){ fclose($static_captions); }

						//check for images!

					}else{ //check if fallback
						//get content array
						$content = @file_get_contents($filepath);
					}

					if($importZip === true){ //we have a zip
						$db = new RevSliderDB();

						//update/insert custom animations
						$animations = @unserialize($animations);
						if(!empty($animations)){
							foreach($animations as $key => $animation){ //$animation['id'], $animation['handle'], $animation['params']
								$exist = $db->fetch(RevSliderGlobals::$table_layer_anims, "handle = '".$animation['handle']."'");
								if(!empty($exist)){ //update the animation, get the ID
									if($updateAnim == "true"){ //overwrite animation if exists
										$arrUpdate = array();
										$arrUpdate['params'] = stripslashes(json_encode(str_replace("'", '"', $animation['params'])));
										$db->update(RevSliderGlobals::$table_layer_anims, $arrUpdate, array('handle' => $animation['handle']));

										$anim_id = $exist['0']['id'];
									}else{ //insert with new handle
										$arrInsert = array();
										$arrInsert["handle"] = 'copy_'.$animation['handle'];
										$arrInsert["params"] = stripslashes(json_encode(str_replace("'", '"', $animation['params'])));

										$anim_id = $db->insert(RevSliderGlobals::$table_layer_anims, $arrInsert);
									}
								}else{ //insert the animation, get the ID
									$arrInsert = array();
									$arrInsert["handle"] = $animation['handle'];
									$arrInsert["params"] = stripslashes(json_encode(str_replace("'", '"', $animation['params'])));

									$anim_id = $db->insert(RevSliderGlobals::$table_layer_anims, $arrInsert);
								}

								//and set the current customin-oldID and customout-oldID in slider params to new ID from $id
								$content = str_replace(array('customin-'.$animation['id'].'"', 'customout-'.$animation['id'].'"'), array('customin-'.$anim_id.'"', 'customout-'.$anim_id.'"'), $content);
							}
//							dmp(__("animations imported!",'hillter'));
						}else{
//							dmp(__("no custom animations found, if slider uses custom animations, the provided export may be broken...",'hillter'));
						}

						//overwrite/append static-captions.css
						if(!empty($static)){
							if($updateStatic == "true"){ //overwrite file
								RevSliderOperations::updateStaticCss($static);
							}elseif($updateStatic == 'none'){
								//do nothing
							}else{//append
								$static_cur = RevSliderOperations::getStaticCss();
								$static = $static_cur."\n".$static;
								RevSliderOperations::updateStaticCss($static);
							}
						}
						//overwrite/create dynamic-captions.css
						//parse css to classes
						$dynamicCss = RevSliderCssParser::parseCssToArray($dynamic);

						if(is_array($dynamicCss) && $dynamicCss !== false && count($dynamicCss) > 0){
							foreach($dynamicCss as $class => $styles){
								//check if static style or dynamic style
								$class = trim($class);

								if(strpos($class, ',') !== false && strpos($class, '.tp-caption') !== false){ //we have something like .tp-caption.redclass, .redclass
									$class_t = explode(',', $class);
									foreach($class_t as $k => $cl){
										if(strpos($cl, '.tp-caption') !== false) $class = $cl;
									}
								}

								if((strpos($class, ':hover') === false && strpos($class, ':') !== false) || //before, after
									strpos($class," ") !== false || // .tp-caption.imageclass img or .tp-caption .imageclass or .tp-caption.imageclass .img
									strpos($class,".tp-caption") === false || // everything that is not tp-caption
									(strpos($class,".") === false || strpos($class,"#") !== false) || // no class -> #ID or img
									strpos($class,">") !== false){ //.tp-caption>.imageclass or .tp-caption.imageclass>img or .tp-caption.imageclass .img
									continue;
								}

								//is a dynamic style
								if(strpos($class, ':hover') !== false){
									$class = trim(str_replace(':hover', '', $class));
									$arrInsert = array();
									$arrInsert["hover"] = json_encode($styles);
									$arrInsert["settings"] = json_encode(array('hover' => 'true'));
								}else{
									$arrInsert = array();
									$arrInsert["params"] = json_encode($styles);
									$arrInsert["settings"] = '';
								}
								//check if class exists
								$result = $db->fetch(RevSliderGlobals::$table_css, "handle = '".$class."'");

								if(!empty($result)){ //update
									$db->update(RevSliderGlobals::$table_css, $arrInsert, array('handle' => $class));
								}else{ //insert
									$arrInsert["handle"] = $class;
									$db->insert(RevSliderGlobals::$table_css, $arrInsert);
								}
							}
//							dmp(__("dynamic styles imported!",'hillter'));
						}else{
//							dmp(__("no dynamic styles found, if slider uses dynamic styles, the provided export may be broken...",'hillter'));
						}
					}

					//$content = preg_replace('!s:(\d+):"(.*?)";!e', "'s:'.strlen('$2').':\"$2\";'", $content); //clear errors in string //deprecated in newest php version
					$content = preg_replace_callback('!s:(\d+):"(.*?)";!', array('RevSlider', 'clear_error_in_string') , $content); //clear errors in string

					$arrSlider = @unserialize($content);
					if(empty($arrSlider))
						RevSliderFunctions::throwError("Wrong export slider file format! This could be caused because the ZipArchive extension is not enabled.");

					//update slider params
					$sliderParams = $arrSlider["params"];

					if($sliderExists){
						$sliderParams["title"] = $this->arrParams["title"];
						$sliderParams["alias"] = $this->arrParams["alias"];
						$sliderParams["shortcode"] = $this->arrParams["shortcode"];
					}

					if(isset($sliderParams["background_image"]))
						$sliderParams["background_image"] = RevSliderFunctionsWP::getImageUrlFromPath($sliderParams["background_image"]);


					$import_statics = true;
					if(isset($sliderParams['enable_static_layers'])){
						if($sliderParams['enable_static_layers'] == 'off') $import_statics = false;
						unset($sliderParams['enable_static_layers']);
					}

					$json_params = json_encode($sliderParams);

					//update slider or create new
					if($sliderExists){
						$arrUpdate = array("params"=>$json_params);
						$this->db->update(RevSliderGlobals::$table_sliders,$arrUpdate,array("id"=>$sliderID));
					}else{	//new slider
						$arrInsert = array();
						$arrInsert['params'] = $json_params;
						//check if Slider with title and/or alias exists, if yes change both to stay unique


						$arrInsert['title'] = RevSliderFunctions::getVal($sliderParams, 'title', 'Slider1');
						$arrInsert['alias'] = RevSliderFunctions::getVal($sliderParams, 'alias', 'slider1');
						if($is_template === false){ //we want to stay at the given alias if we are a template
							$talias = $arrInsert['alias'];
							$ti = 1;
							while($this->isAliasExistsInDB($talias)){ //set a new alias and title if its existing in database
								$talias = $arrInsert['alias'] . $ti;
								$ti++;
							}
							if($talias !== $arrInsert['alias']){
								$arrInsert['title'] = $talias;
								$arrInsert['alias'] = $talias;
							}
						}

						if($is_template !== false){ //add that we are an template
							$arrInsert['type'] = 'template';
						}

						$sliderID = $this->db->insert(RevSliderGlobals::$table_sliders,$arrInsert);
					}

					//-------- Slides Handle -----------

					//delete current slides
					if($sliderExists)
						$this->deleteAllSlides();

					//create all slides
					$arrSlides = $arrSlider["slides"];

					$alreadyImported = array();

					//wpml compatibility
					$slider_map = array();

					foreach($arrSlides as $sl_key => $slide){
						$params = $slide["params"];
						$layers = $slide["layers"];
						$settings = @$slide["settings"];

						//convert params images:
						if($importZip === true){ //we have a zip, check if exists
							if(isset($params["image"])){
								$params["image"] = RevSliderBase::check_file_in_zip($zip, $params["image"], $filepath, $sliderParams["alias"], $alreadyImported);
								$params["image"] = RevSliderFunctionsWP::getImageUrlFromPath($params["image"]);
							}

							if(isset($params["background_image"])){
								$params["background_image"] = RevSliderBase::check_file_in_zip($zip, $params["background_image"], $filepath, $sliderParams["alias"], $alreadyImported);
								$params["background_image"] = RevSliderFunctionsWP::getImageUrlFromPath($params["background_image"]);
							}

							if(isset($params["slide_thumb"])){
								$params["slide_thumb"] = RevSliderBase::check_file_in_zip($zip, $params["slide_thumb"], $filepath, $sliderParams["alias"], $alreadyImported);
								$params["slide_thumb"] = RevSliderFunctionsWP::getImageUrlFromPath($params["slide_thumb"]);
							}

							if(isset($params["show_alternate_image"])){
								$params["show_alternate_image"] = RevSliderBase::check_file_in_zip($zip, $params["show_alternate_image"], $filepath, $sliderParams["alias"], $alreadyImported);
								$params["show_alternate_image"] = RevSliderFunctionsWP::getImageUrlFromPath($params["show_alternate_image"]);
							}
							if(isset($params['background_type']) && $params['background_type'] == 'html5'){
								if(isset($params['slide_bg_html_mpeg']) && $params['slide_bg_html_mpeg'] != ''){
									$params['slide_bg_html_mpeg'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $params["slide_bg_html_mpeg"], $filepath, $sliderParams["alias"], $alreadyImported, true));
								}
								if(isset($params['slide_bg_html_webm']) && $params['slide_bg_html_webm'] != ''){
									$params['slide_bg_html_webm'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $params["slide_bg_html_webm"], $filepath, $sliderParams["alias"], $alreadyImported, true));
								}
								if(isset($params['slide_bg_html_ogv'])  && $params['slide_bg_html_ogv'] != ''){
									$params['slide_bg_html_ogv'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $params["slide_bg_html_ogv"], $filepath, $sliderParams["alias"], $alreadyImported, true));
								}
							}
						}

						//convert layers images:
						foreach($layers as $key=>$layer){
							//import if exists in zip folder
							if($importZip === true){ //we have a zip, check if exists
								if(isset($layer["image_url"])){
									$layer["image_url"] = RevSliderBase::check_file_in_zip($zip, $layer["image_url"], $filepath, $sliderParams["alias"], $alreadyImported);
									$layer["image_url"] = RevSliderFunctionsWP::getImageUrlFromPath($layer["image_url"]);
								}
								if(isset($layer['type']) && $layer['type'] == 'video'){

									$video_data = (isset($layer['video_data'])) ? (array) $layer['video_data'] : array();

									if(!empty($video_data) && isset($video_data['video_type']) && $video_data['video_type'] == 'html5'){

										if(isset($video_data['urlPoster']) && $video_data['urlPoster'] != ''){
											$video_data['urlPoster'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $video_data["urlPoster"], $filepath, $sliderParams["alias"], $alreadyImported));
										}

										if(isset($video_data['urlMp4']) && $video_data['urlMp4'] != ''){
											$video_data['urlMp4'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $video_data["urlMp4"], $filepath, $sliderParams["alias"], $alreadyImported, true));
										}
										if(isset($video_data['urlWebm']) && $video_data['urlWebm'] != ''){
											$video_data['urlWebm'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $video_data["urlWebm"], $filepath, $sliderParams["alias"], $alreadyImported, true));
										}
										if(isset($video_data['urlOgv']) && $video_data['urlOgv'] != ''){
											$video_data['urlOgv'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $video_data["urlOgv"], $filepath, $sliderParams["alias"], $alreadyImported, true));
										}

									}elseif(!empty($video_data) && isset($video_data['video_type']) && $video_data['video_type'] != 'html5'){ //video cover image
										if(isset($video_data['previewimage']) && $video_data['previewimage'] != ''){
											$video_data['previewimage'] = RevSliderFunctionsWP::getImageUrlFromPath(RevSliderBase::check_file_in_zip($zip, $video_data["previewimage"], $filepath, $sliderParams["alias"], $alreadyImported));
										}
									}

									$layer['video_data'] = $video_data;

								}

							}

							$layer['text'] = stripslashes($layer['text']);
							$layers[$key] = $layer;
						}
						$arrSlides[$sl_key]['layers'] = $layers;

						//create new slide
						$arrCreate = array();
						$arrCreate["slider_id"] = $sliderID;
						$arrCreate["slide_order"] = $slide["slide_order"];

						$my_layers = json_encode($layers);
						if(empty($my_layers))
							$my_layers = stripslashes(json_encode($layers));
						$my_params = json_encode($params);
						if(empty($my_params))
							$my_params = stripslashes(json_encode($params));
						$my_settings = json_encode($settings);
						if(empty($my_settings))
							$my_settings = stripslashes(json_encode($settings));



						$arrCreate["layers"] = $my_layers;
						$arrCreate["params"] = $my_params;
						$arrCreate["settings"] = $my_settings;

						$last_id = $this->db->insert(RevSliderGlobals::$table_slides,$arrCreate);

						if(isset($slide['id'])){
							$slider_map[$slide['id']] = $last_id;
						}
					}

					//change for WPML the parent IDs if necessary
					if(!empty($slider_map)){
						foreach($arrSlides as $sl_key => $slide){
							if(isset($slide['params']['parentid']) && isset($slider_map[$slide['params']['parentid']])){
								$update_id = $slider_map[$slide['id']];
								$parent_id = $slider_map[$slide['params']['parentid']];

								$arrCreate = array();

								$arrCreate["params"] = $slide['params'];
								$arrCreate["params"]['parentid'] = $parent_id;
								$my_params = json_encode($arrCreate["params"]);
								if(empty($my_params))
									$my_params = stripslashes(json_encode($arrCreate["params"]));

								$arrCreate["params"] = $my_params;

								$this->db->update(RevSliderGlobals::$table_slides,$arrCreate,array("id"=>$update_id));
							}

							$did_change = false;
							foreach($slide['layers'] as $key => $value){
								if(isset($value['layer_action'])){
									if(isset($value['layer_action']->jump_to_slide) && !empty($value['layer_action']->jump_to_slide)){
										$value['layer_action']->jump_to_slide = (array)$value['layer_action']->jump_to_slide;
										foreach($value['layer_action']->jump_to_slide as $jtsk => $jtsval){
											if(isset($slider_map[$jtsval])){
												$slide['layers'][$key]['layer_action']->jump_to_slide[$jtsk] = $slider_map[$jtsval];
												$did_change = true;
											}
										}
									}
								}

								$link_slide = RevSliderFunctions::getVal($value, 'link_slide', false);
								if($link_slide != false && $link_slide !== 'nothing'){ //link to slide/scrollunder is set, move it to actions
									if(!isset($slide['layers'][$key]['layer_action'])) $slide['layers'][$key]['layer_action'] = new stdClass();
									switch($link_slide){
										case 'link':
											$link = RevSliderFunctions::getVal($value, 'link');
											$link_open_in = RevSliderFunctions::getVal($value, 'link_open_in');
											$slide['layers'][$key]['layer_action']->action = array('a' => 'link');
											$slide['layers'][$key]['layer_action']->link_type = array('a' => 'a');
											$slide['layers'][$key]['layer_action']->image_link = array('a' => $link);
											$slide['layers'][$key]['layer_action']->link_open_in = array('a' => $link_open_in);

											unset($slide['layers'][$key]['link']);
											unset($slide['layers'][$key]['link_open_in']);
										case 'next':
											$slide['layers'][$key]['layer_action']->action = array('a' => 'next');
											break;
										case 'prev':
											$slide['layers'][$key]['layer_action']->action = array('a' => 'prev');
											break;
										case 'scroll_under':
											$scrollunder_offset = RevSliderFunctions::getVal($value, 'scrollunder_offset');
											$slide['layers'][$key]['layer_action']->action = array('a' => 'scroll_under');
											$slide['layers'][$key]['layer_action']->scrollunder_offset = array('a' => $scrollunder_offset);

											unset($slide['layers'][$key]['scrollunder_offset']);
											break;
										default: //its an ID, so its a slide ID
											$slide['layers'][$key]['layer_action']->action = array('a' => 'jumpto');
											$slide['layers'][$key]['layer_action']->jump_to_slide = array('a' => $slider_map[$link_slide]);
											break;

									}
									$slide['layers'][$key]['layer_action']->tooltip_event = array('a' => 'click');

									unset($slide['layers'][$key]['link_slide']);

									$did_change = true;
								}


								if($did_change === true){

									$arrCreate = array();
									$my_layers = json_encode($slide['layers']);
									if(empty($my_layers))
										$my_layers = stripslashes(json_encode($layers));

									$arrCreate['layers'] = $my_layers;

									$this->db->update(RevSliderGlobals::$table_slides,$arrCreate,array("id"=>$slider_map[$slide['id']]));
								}
							}
						}
					}

					//check if static slide exists and import
					if(isset($arrSlider['static_slides']) && !empty($arrSlider['static_slides']) && $import_statics){
						$static_slide = $arrSlider['static_slides'];
						foreach($static_slide as $slide){

							$params = $slide["params"];
							$layers = $slide["layers"];
							$settings = @$slide["settings"];


							//convert params images:
							if(isset($params["image"])){
								//import if exists in zip folder
								if(strpos($params["image"], 'http') !== false){
								}else{
									if(trim($params["image"]) !== ''){
										if($importZip === true){ //we have a zip, check if exists
											$image = $zip->getStream('images/'.$params["image"]);
											if(!$image){
												print $params["image"].__(' not found!<br>', 'hillter');

											}else{
												if(!isset($alreadyImported['zip://'.$filepath."#".'images/'.$params["image"]])){
													$importImage = RevSliderFunctionsWP::import_media('zip://'.$filepath."#".'images/'.$params["image"], $sliderParams["alias"].'/');

													if($importImage !== false){
														$alreadyImported['zip://'.$filepath."#".'images/'.$params["image"]] = $importImage['path'];

														$params["image"] = $importImage['path'];
													}
												}else{
													$params["image"] = $alreadyImported['zip://'.$filepath."#".'images/'.$params["image"]];
												}


											}
										}
									}
									$params["image"] = RevSliderFunctionsWP::getImageUrlFromPath($params["image"]);
								}
							}

							//convert layers images:
							foreach($layers as $key=>$layer){
								if(isset($layer["image_url"])){
									//import if exists in zip folder
									if(trim($layer["image_url"]) !== ''){
										if(strpos($layer["image_url"], 'http') !== false){
										}else{
											if($importZip === true){ //we have a zip, check if exists
												$image_url = $zip->getStream('images/'.$layer["image_url"]);
												if(!$image_url){
													print $layer["image_url"].__( ' not found!<br>', 'hillter');
												}else{
													if(!isset($alreadyImported['zip://'.$filepath."#".'images/'.$layer["image_url"]])){
														$importImage = RevSliderFunctionsWP::import_media('zip://'.$filepath."#".'images/'.$layer["image_url"], $sliderParams["alias"].'/');

														if($importImage !== false){
															$alreadyImported['zip://'.$filepath."#".'images/'.$layer["image_url"]] = $importImage['path'];

															$layer["image_url"] = $importImage['path'];
														}
													}else{
														$layer["image_url"] = $alreadyImported['zip://'.$filepath."#".'images/'.$layer["image_url"]];
													}
												}
											}
										}
									}
									$layer["image_url"] = RevSliderFunctionsWP::getImageUrlFromPath($layer["image_url"]);
									$layer['text'] = stripslashes($layer['text']);

								}

								if(isset($layer['layer_action'])){
									if(isset($layer['layer_action']->jump_to_slide) && !empty($layer['layer_action']->jump_to_slide)){
										foreach($layer['layer_action']->jump_to_slide as $jtsk => $jtsval){
											if(isset($slider_map[$jtsval])){
												$layer['layer_action']->jump_to_slide[$jtsk] = $slider_map[$jtsval];
											}
										}
									}
								}

								$link_slide = RevSliderFunctions::getVal($value, 'link_slide', false);
								if($link_slide != false && $link_slide !== 'nothing'){ //link to slide/scrollunder is set, move it to actions
									if(!isset($layer['layer_action'])) $layer['layer_action'] = new stdClass();

									switch($link_slide){
										case 'link':
											$link = RevSliderFunctions::getVal($value, 'link');
											$link_open_in = RevSliderFunctions::getVal($value, 'link_open_in');
											$layer['layer_action']->action = array('a' => 'link');
											$layer['layer_action']->link_type = array('a' => 'a');
											$layer['layer_action']->image_link = array('a' => $link);
											$layer['layer_action']->link_open_in = array('a' => $link_open_in);

											unset($layer['link']);
											unset($layer['link_open_in']);
										case 'next':
											$layer['layer_action']->action = array('a' => 'next');
											break;
										case 'prev':
											$layer['layer_action']->action = array('a' => 'prev');
											break;
										case 'scroll_under':
											$scrollunder_offset = RevSliderFunctions::getVal($value, 'scrollunder_offset');
											$layer['layer_action']->action = array('a' => 'scroll_under');
											$layer['layer_action']->scrollunder_offset = array('a' => $scrollunder_offset);

											unset($layer['scrollunder_offset']);
											break;
										default: //its an ID, so its a slide ID
											$layer['layer_action']->action = array('a' => 'jumpto');
											$layer['layer_action']->jump_to_slide = array('a' => $slider_map[$link_slide]);
											break;

									}
									$layer['layer_action']->tooltip_event = array('a' => 'click');

									unset($layer['link_slide']);

									$did_change = true;
								}

								$layers[$key] = $layer;
							}

							//create new slide
							$arrCreate = array();
							$arrCreate["slider_id"] = $sliderID;

							$my_layers = json_encode($layers);
							if(empty($my_layers))
								$my_layers = stripslashes(json_encode($layers));
							$my_params = json_encode($params);
							if(empty($my_params))
								$my_params = stripslashes(json_encode($params));
							$my_settings = json_encode($settings);
							if(empty($my_settings))
								$my_settings = stripslashes(json_encode($settings));


							$arrCreate["layers"] = $my_layers;
							$arrCreate["params"] = $my_params;
							$arrCreate["settings"] = $my_settings;

							if($sliderExists){
								unset($arrCreate["slider_id"]);
								$this->db->update(RevSliderGlobals::$table_static_slides,$arrCreate,array("slider_id"=>$sliderID));
							}else{
								$this->db->insert(RevSliderGlobals::$table_static_slides,$arrCreate);
							}
						}
					}

					$c_slider = new RevSliderSlider();
					$c_slider->initByID($sliderID);

					//check to convert styles to latest versions
					RevSliderPluginUpdate::update_css_styles(); //set to version 5
					RevSliderPluginUpdate::add_animation_settings_to_layer($c_slider); //set to version 5
					RevSliderPluginUpdate::add_style_settings_to_layer($c_slider); //set to version 5
					RevSliderPluginUpdate::change_settings_on_layers($c_slider); //set to version 5
					RevSliderPluginUpdate::add_general_settings($c_slider); //set to version 5

					$cus_js = $c_slider->getParam('custom_javascript', '');

					if(strpos($cus_js, 'revapi') !== false){
						if(preg_match_all('/revapi[0-9]*./', $cus_js, $results)){

							if(isset($results[0]) && !empty($results[0])){
								foreach($results[0] as $replace){
									$cus_js = str_replace($replace, 'revapi'.$sliderID.'.', $cus_js);
								}
							}

							$c_slider->updateParam(array('custom_javascript' => $cus_js));

						}

					}

					if($is_template !== false){ //duplicate the slider now, as we just imported the "template"
						if($single_slide !== false){ //add now one Slide to the current Slider
							$mslider = new RevSlider();

							//change slide_id to correct, as it currently is just a number beginning from 0 as we did not have a correct slide ID yet.
							$i = 0;
							$changed = false;
							foreach($slider_map as $value){
								if($i == $single_slide['slide_id']){
									$single_slide['slide_id'] = $value;
									$changed = true;
									break;
								}
								$i++;
							}

							if($changed){
								$return = $mslider->copySlideToSlider($single_slide);
							}else{
								return(array("success"=>false,"error"=>__('could not find correct Slide to copy, please try again.', 'hillter'),"sliderID"=>$sliderID));
							}

						}else{
							$mslider = new RevSlider();
							$title = RevSliderFunctions::getVal($sliderParams, 'title', 'slider1');
							$talias = $title;
							$ti = 1;
							while($this->isAliasExistsInDB($talias)){ //set a new alias and title if its existing in database
								$talias = $title . $ti;
								$ti++;
							}
							$mslider->duplicateSliderFromData(array('sliderid' => $sliderID, 'title' => $talias));
						}
					}


				}catch(Exception $e){
					$errorMessage = $e->getMessage();
					return(array("success"=>false,"error"=>$errorMessage,"sliderID"=>$sliderID));
				}

				return(array("success"=>true,"sliderID"=>$sliderID));
			}


			public function recusive($input)
			{
				$regex = '#!s:(\d+):"(.*?)";!e#';
				// if(is_array($input))
				// {
				// 	$input = "'s:'.strlen('$2').':\"$2\";'".$input[1];
				// }
				return preg_replace_callback($regex, "self::replace", $input);
			}

			private function replace($match)
			{
				if (method_exists($this, $matches[1])){
			      	return @$this->$matches[1]($matches[2]);
			    }
			}
		}
	}
?>
