<?php

/**
 * Initialization Import Class
 * @author Kai
 * @date 7/8/2015
 */
/**
 * Enqueue Script
 */
define('AWE_IMPORT_PATH', get_template_directory() . '/inc/awe-import/');
define('AWE_IMPORT_URI', get_template_directory_uri() . '/inc/awe-import/');

include_once( AWE_IMPORT_PATH . 'lib/awe-import-revslider.php' );

add_action('admin_enqueue_scripts', 'awe_import_script');

function awe_import_script() {
	$url = get_template_directory_uri();
	wp_enqueue_script('awe-import', $url . '/inc/awe-import/lib/import.js', array(), null, true);
}

add_action('wp_ajax_awe_ajax_install_demo', 'awe_ajax_install_demo');
add_action('wp_ajax_nopriv_awe_ajax_install_demo', 'awe_ajax_install_demo');
add_action('wp_ajax_awe_ajax_restore_data', 'awe_ajax_restore_data');
add_action('wp_ajax_nopriv_awe_ajax_restore_data', 'awe_ajax_restore_data');

function awe_ajax_install_demo() {
	$import = true;
	$mess = array();
	$mess['error'] = '';
	// if (!class_exists('WooCommerce')) {
	// 	$mess['error'] .= 'Please Install Woocommerce<br>';
	// }

	if ( ! class_exists( 'APB_Booking' ) ) {
		$mess['error'] .= 'Please Install AweBooking<br>';
	}

	if ( ! get_option( 'check_avb' ) ) {
		$mess['error'] .= 'You need to add some pages to display rooms and check availability result for AweBooking. Run Add Pages automatically<br>';
	}

	if (!class_exists('WPCF7_ContactForm')) {
		$mess['error'] .= 'Please Install Contact Form 7<br>';
	}

	if (!class_exists('RevSliderFunctions')) {
		$mess['error'] .= 'Please Install Revolution Slider 5 or above<br>';
	}

	if (!class_exists('Vc_Base')) {
		$mess['error'] .= 'Please Install Visual Composer<br>';
	}

	if ( ! class_exists( 'Hillter_Require' ) ) {
		$mess['error'] .= 'Please Install Hillter Plugin Require<br>';
	}

	if ($mess['error'] == '') {
		$mess['status'] = true;
		$mess['content'] = 'Import Successfully. You need import revolution slider by file inc/awe-import/default/hillter-slider.zip';
		require_once(AWE_IMPORT_PATH . 'default/awe_import.php');
	}
	echo json_encode($mess);
	exit();
}

function awe_ajax_restore_data() {
	awe_restore::restore_all();
	die();
}

/**
 * Store imported demo to wp_options
 */
class awe_import_log {

	static private $data = array();

	static function get_log() {
		return get_option('awe_log');
	}

	static function update_log() {
		$log = self::$data;
		self::update_button();
		if (get_option('awe_log') != false) {
			return update_option('awe_log', $log);
		} else {
			add_option('awe_log', $log);
		}

	}

	static function log_taxonomy($type, $id) {
		$log = self::$data;
		$ids = array();
		if (!empty($log['taxonomy'])) {
			$current_ids = !empty($log['taxonomy'][$type]) ? $log['taxonomy'][$type] : array();
			if (count($current_ids) > 0) {
				if (in_array($id, $current_ids)) {
					return; // Nothing happen
				} else {
					$current_ids[] = $id;
				}
				$log['taxonomy'][$type] = $current_ids;
			} else {
				$log['taxonomy'][$type] = array($id); // No taxonomy before
			}
		} else {
			$log['taxonomy'][$type] = array($id); // Data empty
		}
		self::$data = $log;
	}

	static function log_media($id) {
		$log = self::$data;
		$ids = array();
		if (!empty($log['media']) && count($log['media']) > 0) {
			if (in_array($id, $log['media'])) {
				return 'exist'; // Nothing happen
			} else {
				$log['media'][] = $id;
			}
		} else {
			$log['media'] = array($id);
		}
		self::$data = $log;
	}

	static function log_content($type, $id) {
		$log = self::$data;
		$ids = array();
		if (!empty($log['content'])) {
			$current_ids = !empty($log['content'][$type]) ? $log['content'][$type] : array();
			if (count($current_ids) > 0) {
				if (in_array($id, $current_ids)) {
					return; // Nothing happen
				} else {
					$current_ids[] = $id;
				}
				$log['content'][$type] = $current_ids;
			} else {
				$log['content'][$type] = array($id); // No content before
			}
		} else {
			$log['content'][$type] = array($id); // Data empty
		}
		self::$data = $log;
	}

	static function log_widget($data_widget) {
		$log = self::$data;
		$log['widget'] = $data_widget;
		self::$data = $log;
	}

	static function log_menu($menu_id) {
		// $log = self::get_log();
		$log = self::$data;
		if (!empty($log['menu']) && count($log['menu']) > 0) {
			if (in_array($menu_id, $log['menu'])) {
				return; // Nothing happen
			} else {
				$log['menu'] = array($menu_id);
			}
		} else {
			$log['menu'] = array($menu_id);
		}
		self::$data = $log;
	}

	static function log_theme_setting($lang, $setting) {
		// $log = self::get_log();
		$log = self::$data;
		$log['theme_setting'][$lang] = $setting;
		self::$data = $log;
	}

	static function update_button() {
		update_option('awe_import_button', 'restore');
	}

}

/**
 * Class awe_restore
 */
class awe_restore {

	static function get_log() {
		return get_option('awe_log');
	}

	static function delete_log() {
		update_option('awe_log', '');
	}

	static function restore_taxonomy() {
		$log = self::get_log();
		if (!empty($log['taxonomy']) && count($log['taxonomy']) > 0) {
			foreach ($log['taxonomy'] as $k => $taxonomy) {
				if (!empty($taxonomy)) {
					foreach ($taxonomy as $delete_term) {
						if (is_wp_error($delete_term) == false) {
							wp_delete_term($delete_term['term_id'], $k);
						}
					}
				}
			}
		}
	}

	static function restore_content() {
		$log = self::get_log();
		if (isset($log['content']) && count($log['content']) > 0) {
			foreach ($log['content'] as $content) {
				if (count($content) > 0) {
					foreach ($content as $postid) {
						wp_delete_post($postid, true);
					}
				}
			}
		}
	}

	static function restore_media() {
		$log = self::get_log();
		if (!empty($log['media']) && count($log['media']) > 0) {
			foreach ($log['media'] as $media_id) {
				wp_delete_attachment($media_id, true);
			}
		}
	}

	static function restore_menu() {
		$log = self::get_log();
		if (!empty($log['menu']) && count($log['menu']) > 0) {
			foreach ($log['menu'] as $menu_id) {
				wp_delete_nav_menu($menu_id);
			}
		}
	}

	static function restore_theme_setting() {
		$log = self::get_log();
		if (!empty($log['theme_setting']) && count($log['theme_setting']) > 0) {
			foreach ($log['theme_setting'] as $k => $theme_setting) {
				update_option($k, unserialize($theme_setting));
			}
		}
	}

	static function restore_widget() {
		$log = self::get_log();
		if (!empty($log['widget'])) {
			foreach ($log['widget'] as $key => $value) {
				update_option($key, $value);
			}
		}
	}

	static function update_button() {
		update_option('awe_import_button', 'install');
	}

	static function restore_all() {
		awe_restore::restore_taxonomy();
		awe_restore::restore_content();
		awe_restore::restore_media();
		awe_restore::restore_menu();
		awe_restore::restore_theme_setting();
		awe_restore::restore_widget();
		awe_restore::delete_log();
		awe_restore::update_button();
		return self::get_log();
	}

}

/**
 * Class awe_import_revslider
 */
class awe_import_revslider {

	// import rev slider
	static function add_slide($data) {
		if (empty($data)) {
			return;
		}
		// Get data array
		if (class_exists('RevSlider')) {
			$rev = new awe_import_revsilder();
			$path = get_template_directory() . '/inc/awe-import/default/';
			$arrSliders = $rev->getArrSlidersShort();
			foreach ($data as $import_item) {
				$import_item['set'] = true;
				if (in_array($import_item['alias'], $arrSliders)) {
					$import_item['set'] = false;
				}
				if ($import_item['set'] == true) {
					$import_path = $path . $import_item['filename'];
					$rev->importSliderFromPost($updateAnim = true, $updateStatic = true, $import_path, $is_template = false, $single_slide = false);
				}
			}
		}
	}

}

/**
 * Import Menu
 */
class awe_import_menu {

	/**
	 * Backup data
	 * @var array
	 * @access public
	 */
	public $backup = array();

	/**
	 * Construct
	 * @param array $backup Backup data
	 */
	public function __construct($backup = array()) {
		$this->backup = array_merge($this->backup, (array) $backup);
	}

	/**
	 * Save menu to location
	 * @param  string $location Location
	 * @param  int $menu_id Menu id
	 * @return void
	 */
	public static function save_location($location, $menu_id) {
		$menu_locations = (get_theme_mod('nav_menu_locations') != false) ? get_theme_mod('nav_menu_locations') : array();
		$menu_locations[$location] = absint($menu_id);
		set_theme_mod('nav_menu_locations', $menu_locations);
	}

	/**
	 * Create menu
	 * @param  string $menu_name Menu name
	 * @return int    Menu id if sucess
	 */
	public static function create_menu($menu_name, $location) {
		if (wp_get_nav_menu_items($menu_name) === false) {
			$menu_id = wp_create_nav_menu($menu_name);
		} else {
			$i = 0;
			do {
				$i++;
				$name = $menu_name . ' ' . $i;
			} while (wp_get_nav_menu_items($name) !== false);

			$menu_id = wp_create_nav_menu($name);
		}
		self::save_location($location, $menu_id);
		awe_import_log::log_menu($menu_id);
		return $menu_id;
	}

	/**
	 * Create new menu item
	 * @param  int $menu_id Menu id
	 * @param  array $args Menu item data. See /wp-includes/nav-menu.php
	 * @return int|WP_Error          Menu item id if success
	 */
	public static function create_menu_item($menu_id, $args) {
		return wp_update_nav_menu_item($menu_id, 0, $args);
	}

	/**
	 * Update menu item
	 * @param  int $menu_id Menu id
	 * @param  int $item_id Menu item id
	 * @param  array $args Menu item data. See /wp-includes/nav-menu.php
	 * @return int|WP_Error          Menu item id if success
	 */
	public static function update_menu_item($menu_id, $item_id, $args) {
		return wp_update_nav_menu_item($menu_id, $item_id, $args);
	}

	/**
	 * Backup menu location data
	 * @return void
	 */
	public static function backup() {
		$this->backup['nav_menu_locations'] = get_theme_mod('nav_menu_locations');
		return $this->backup;
	}

	/**
	 * Restore menu location data
	 * @return void
	 */
	public static function restore() {
		foreach ($this->backup as $k => $v) {
			if ($k == 'nav_menu_locations') {
				set_theme_mod($k, $v);
			} else {
				update_option($v, $v);
			}
		}
	}

}

/**
 * Import Category
 */
class awe_import_category {

	/**
	 * @param array $catarr {
	 *     Array of arguments for inserting a new category.
	 *
	 * @type int $cat_ID Categoriy ID. A non-zero value updates an existing category.
	 *                                            Default 0.
	 * @type string $taxonomy Taxonomy slug. Defualt 'category'.
	 * @type string $cat_nam Category name. Default empty.
	 * @type string $category_description Category description. Default empty.
	 * @type string $category_nicename Category nice (display) name. Default empty.
	 * @type int|string $category_parent Category parent ID. Default empty.
	 * }
	 */
	static function add_category($param_array) {
		$insert_array['cat_name'] = $param_array['category_name'];
		$insert_array['taxonomy'] = !empty($param_array['taxonomy']) ? $param_array['taxonomy'] : 'category';
		if ($id = term_exists($param_array['category_name'], $insert_array['taxonomy'], $param_array['parent_id'])) {
			return $id; // Return ID if taxonomy name exist
		}
		$insert_array['category_description'] = !empty($param_array['description']) ? $param_array['description'] : '';
		$new_cat_id = wp_insert_term($insert_array['cat_name'], $insert_array['taxonomy'], array('description' => $insert_array['category_description']));
		$cat_id = $new_cat_id;
		if (!empty($param_array['term_meta']) && !empty($param_array['term_meta']['layout'])) {
			$data = get_option('awe-meta-data');
			$data[$new_cat_id['term_id']]['layout'] = $param_array['term_meta']['layout'];
			update_option('awe-meta-data', $data);
		}
		awe_import_log::log_taxonomy($insert_array['taxonomy'], $cat_id); // Insert to log
		return $cat_id;
	}

	static function remove_category() {
		// Remove category
	}

}

/**
 * Import Media
 */
class awe_import_media {

	static function add_media($attachment_id, $file, $post_id = '', $desc = null) {

		require_once(ABSPATH . 'wp-admin/includes/media.php');
		require_once(ABSPATH . 'wp-admin/includes/file.php');
		require_once(ABSPATH . 'wp-admin/includes/image.php');

		// Set variables for storage, fix file filename for query strings.
		preg_match('/[^\?]+\.(jpe?g|jpe|gif|png)\b/i', $file, $matches);
		$file_array = array();
		$file_array['name'] = wp_basename($matches[0]);

		// Download file to temp location.
		$file_array['tmp_name'] = download_url($file);

		// If error storing temporarily, return the error.
		if (is_wp_error($file_array['tmp_name'])) {
			@unlink($file_array['tmp_name']);
			echo 'is_wp_error $file_array: ' . $file;
			print_r($file_array['tmp_name']);
			return $file_array['tmp_name'];
		}

		// Do the validation and storage stuff.
		$id = media_handle_sideload($file_array, $post_id, $desc); //$id of attachement or wp_error
		// If error storing permanently, unlink.
		if (is_wp_error($id)) {
			@unlink($file_array['tmp_name']);
			echo 'is_wp_error $id: ' . $id->get_error_messages() . ' ' . $file;
			return $id;
		}

		update_post_meta($id, 'awe_media_attachment', $attachment_id);
		awe_import_log::log_media($id);
		return $id;
	}

}

/**
 * Import Content
 */
class awe_import_content {

	/**
	 * @param $file_path
	 * @return mixed|string
	 */
	static function get_content_file($file_path) {
		$file_content = file_get_contents($file_path);
		preg_match_all('/____(.*)____/U', $file_content, $matches, PREG_PATTERN_ORDER);
		if (!empty($matches) and is_array($matches)) {
			foreach ($matches[1] as $index => $match) {
				$image = wp_get_attachment_image_src(self::get_thumb_id_by_name('awe_media_1'), '');
				$file_content = str_replace($matches[0][$index], $image[0], $file_content);
			}
		}
		return $file_content;
	}

	static function get_content_file_replace_width_id($file_path, $ids) {
		$file_content = file_get_contents($file_path);
		preg_match_all('/__(.*)__/U', $file_content, $matches, PREG_PATTERN_ORDER);
		if (!empty($matches) and is_array($matches)) {
			foreach ($matches[1] as $index => $match) {

				$file_content = str_replace($matches[0][$index], $ids['__' . $match . '__'], $file_content);
			}
		}
		return $file_content;
	}

	static function get_thumb_id_by_name($name) {
		$args = array(
			'post_type' => 'attachment',
			'post_status' => 'inherit',
			'meta_key' => 'awe_media_attachment',
			'meta_value' => $name,
			'posts_per_page' => 1,
		);
		$id = 0;
		$q = new WP_Query($args);
		while ($q->have_posts()) : $q->the_post();
			$id = get_the_ID();
		endwhile;
		global $wpdb;
		$rlt = 1;
		return $id;
	}

	static function add_room_type($label,$data_room_type,$intro_id){
		global $wpdb;

		$wpdb->insert(
			$wpdb->prefix . 'rooms_unit_type',
			array(
				"type"      => sanitize_title($label),
				"label"     => $label,
				"status"    =>1,
				"data"      => $data_room_type,
				'object_id' => $intro_id
			),
			array('%s','%s','%d','%s')
		);

		return $wpdb->insert_id;
	}

	/**
	 * @param $param_array
	 * @return int|WP_Error
	 */
	static function add_post($param_array) {
		$postarr['post_status'] = 'publish';
		$postarr['post_title'] = $param_array['post_title'];
		if (!empty($param_array['content'])) {
			$postarr['post_content'] = $param_array['content'];
		} else {
			$postarr['post_content'] = self::get_content_file($param_array['file']);
		}
		// Set Post type
		$postarr['post_type'] = !empty($param_array['post_type']) ? $param_array['post_type'] : 'post';
		$taxonomy = !empty($param_array['taxonomy']) ? $param_array['taxonomy'] : 'category';
		$post_id = wp_insert_post($postarr);
		// Set Post Terms
		update_post_meta($post_id, "box_customize",0);
		if (!empty($param_array['cat_ids'])) {
			if(!is_array($taxonomy)){
			wp_set_object_terms($post_id, $param_array['cat_ids'], $taxonomy);
			}else{
				foreach($taxonomy as $tax){
				   wp_set_object_terms($post_id, $param_array['cat_ids'][$tax], $tax);
				}
			}
		}
		// Set thumbnail
		if (!empty($param_array['thumbnail_name'])) {
			$thumb_id = self::get_thumb_id_by_name($param_array['thumbnail_name']);
			set_post_thumbnail($post_id, $thumb_id);
		}
		// Set thumbnail
		if (!empty($param_array['thumbnail_id'])) {
			set_post_thumbnail($post_id, $param_array['thumbnail_id']);
		}
		// Set post format
		if (!empty($param_array['post_format'])) {
			set_post_format($post_id, $param_array['post_format']);
		}
		// Set post meta
		if (!empty($param_array['post_meta']) && !empty($param_array['post_meta']['type'])) {
			if ('slider' == $param_array['post_meta']['type']) {
				$values = !empty($param_array['post_meta']['value']) ? $param_array['post_meta']['value'] : array();
				if (!empty($values)) {
					foreach ($values as $value) {
						$img_ids[] = self::get_thumb_id_by_name($value);
					}
				}
				if (!empty($img_ids)) {
					foreach ($img_ids as $value) {
						$gallery[] = wp_get_attachment_url($value);
					}
					$images = implode(',', $img_ids);
					$new_value['shortcode'] = '[gallery ids="' . $images . '"]';
					$new_value['images'] = $gallery;
					// Update slider thumbnail
					update_post_meta($post_id, 'awe-portfolio-thumbnail-type', $param_array['post_meta']['type']);
					update_post_meta($post_id, 'awe-portfolio-thumbnail-slider', $new_value);
				}
			} elseif ('video' == $param_array['post_meta']['type']) {
				$values = !empty($param_array['post_meta']['value']) ? $param_array['post_meta']['value'] : array();
				$new_value['url'] = isset($param_array['post_meta']['value']['url']) ? $param_array['post_meta']['value']['url'] : '';
				$new_value['embed'] = isset($param_array['post_meta']['value']['embed']) ? $param_array['post_meta']['value']['embed'] : '';
				if ('' != $new_value['url'] && '' != $new_value['embed']) {
					// Update video thumbnail
					update_post_meta($post_id, 'awe-portfolio-thumbnail-type', $param_array['post_meta']['type']);
					update_post_meta($post_id, 'awe-portfolio-thumbnail-video', $new_value);
				}
			} elseif ('audio' == $param_array['post_meta']['type']) {
				$values = !empty($param_array['post_meta']['value']) ? $param_array['post_meta']['value'] : array();
				$new_value['url'] = isset($param_array['post_meta']['value']['url']) ? $param_array['post_meta']['value']['url'] : '';
				$new_value['autoplay'] = isset($param_array['post_meta']['value']['autoplay']) ? $param_array['post_meta']['value']['autoplay'] : '';
				if ('' != $new_value['url'] && '' != $new_value['autoplay']) {
					// Update video thumbnail
					update_post_meta($post_id, 'awe-portfolio-thumbnail-type', $param_array['post_meta']['type']);
					update_post_meta($post_id, 'awe-portfolio-thumbnail-audio', $new_value);
				}
			} else {

			}
		}
		if ( 'event' == $postarr['post_type'] ) {
			if ( isset( $param_array['event_meta']['date'] ) ) {
				$date = $param_array['event_meta']['date'];
				update_post_meta( $post_id, 'awe_event_metabox_date', $date );
			}
			if ( isset( $param_array['event_meta']['time'] ) ) {
				$time = $param_array['event_meta']['time'];
				update_post_meta( $post_id, 'awe_event_metabox_time', $time );
			}
			if ( isset( $param_array['event_meta']['location'] ) ) {
				$location = $param_array['event_meta']['location'];
				update_post_meta( $post_id, 'awe_event_metabox_location', $location );
			}
		}

		// Set room type intro data
		if ( 'apb_room_type' == $postarr['post_type'] ) {
			foreach ( $param_array['post_meta'] as $k => $v ) {
				update_post_meta( $post_id, $k, $v );
			}
		}

		awe_import_log::log_content( $postarr['post_type'], $post_id ); // Insert log content
		return $post_id;
	}

	/**
	 * @param $data
	 * @param $shortcode_meta
	 * @param $content
	 * @param $page_id
	 * @return mixed
	 */
	static function add_testimonial_meta($meta_value, $shortcode_meta, $content, $page_id) {
		$meta_insert = awe_save_postmeta('_awe_testimonial', $meta_value, $page_id, false);
		$meta_id = $meta_insert['message'];
		$output = str_replace($shortcode_meta, $meta_id, $content);
		return $output;
	}

	static function add_iconlist_meta($meta_value, $shortcode_meta, $content, $page_id) {
		$meta_insert = awe_save_postmeta('_awe_iconlist', $meta_value, $page_id, false);
		$meta_id = $meta_insert['message'];
		$output = str_replace($shortcode_meta, $meta_id, $content);
		return $output;
	}

	static function add_catalogue_meta($meta_value, $shortcode_meta, $content, $page_id) {
		$meta_insert = awe_save_postmeta('_awe_catalogue', $meta_value, $page_id, false);
		$meta_id = $meta_insert['message'];
		$output = str_replace($shortcode_meta, $meta_id, $content);
		return $output;
	}

	/**
	 * Add Page
	 * @param array $param_array
	 * @return int
	 */
	static function add_page($param_array) {
		$postarr['post_status'] = 'publish';
		$postarr['post_type'] = 'page'; // Insert to page
		$postarr['comment_status'] = 'closed'; // Close comment in page
		$postarr['post_title'] = $param_array['post_title'];
		// $postarr['post_name'] = $param_array['post_name'];
		if (!empty($param_array['file'])) {
			if (!empty($param_array['replace_thumbs'])) {
				$postarr['post_content'] = self::get_content_file_replace_width_id($param_array['file'], $param_array['replace_thumbs']);
			} else {
				$postarr['post_content'] = self::get_content_file($param_array['file']);
			}
		} elseif (!empty($param_array['content'])) {
			$postarr['post_content'] = $param_array['content'];
		} else {
			$postarr['post_content'] = '';
		}

		$page_id = wp_insert_post($postarr);
		if (!empty($param_array['post_meta'])) {
			if (!empty($param_array['post_meta']['awe_sidebar_position'])) {
				update_post_meta($page_id, 'awe_sidebar_position', $param_array['post_meta']['awe_sidebar_position']);
			}
			if (!empty($param_array['post_meta']['page_template'])) {
				update_post_meta($page_id, '_wp_page_template', $param_array['post_meta']['page_template']);
			}
			if ( ! empty( $param_array['post_meta']['awe_header_transparent'] ) ) {
				update_post_meta( $page_id, 'awe_header_transparent', $param_array['post_meta']['awe_header_transparent'] );
			}
		}
		// set as homepage?
		if (!empty($param_array['homepage']) && true === $param_array['homepage']) {
			update_option('page_on_front', $page_id);
			update_option('show_on_front', 'page');
		}
		//If testimonial , insert tesimonial meta data
		if (!empty($param_array['replace_testimonial'])) {
			$data = $param_array['replace_testimonial']['data'];
			$shortcode_meta = $param_array['replace_testimonial']['meta'];
			$content_post = get_post($page_id);
			$content = $content_post->post_content;
			$new_content = awe_import_content::add_testimonial_meta($data, $shortcode_meta, $content, $page_id);
			$new_arr['ID'] = $page_id;
			$new_arr['post_content'] = $new_content;
			wp_update_post($new_arr);
		}
		if (!empty($param_array['replace_iconlist'])) {
			$content_post = get_post($page_id);
			$content = $content_post->post_content;
			foreach ($param_array['replace_iconlist'] as $item) {
			$data = $item['data'];
			$shortcode_meta = $item['meta'];
			$new_content = awe_import_content::add_iconlist_meta($data, $shortcode_meta, $content, $page_id);
			$content = $new_content;
			}
			$new_arr['ID'] = $page_id;
			$new_arr['post_content'] = $new_content;
			wp_update_post($new_arr);
		}
		if (!empty($param_array['replace_catalogue'])) {
			$content_post = get_post($page_id);
			$content = $content_post->post_content;
			foreach ($param_array['replace_catalogue'] as $item) {
			$data = $item['data'];
			$shortcode_meta = $item['meta'];
			$new_content = awe_import_content::add_catalogue_meta($data, $shortcode_meta, $content, $page_id);
			$content = $new_content;
			}
			$new_arr['ID'] = $page_id;
			$new_arr['post_content'] = $new_content;
			wp_update_post($new_arr);
		}
		if (!empty($param_array['replace_gallery_cat'])) {
			$content_post = get_post($page_id);
			$content = $content_post->post_content;
			foreach ($param_array['replace_gallery_cat'] as $item) {
			$data = $item['data'];
			$shortcode_meta = $item['meta'];
			$new_content = str_replace($shortcode_meta, $data, $content);
			$content = $new_content;
			}
			$new_arr['ID'] = $page_id;
			$new_arr['post_content'] = $new_content;
			wp_update_post($new_arr);
		}
		awe_import_log::log_content('page', $page_id);
		return $page_id;
	}

}

/**
 * Import Widget
 */
class awe_import_widget {

	/**
	 * array contain sidebar id as key and value is array of widget data
	 * @var array
	 *
	 * @access protected
	 */
	protected $args;

	/**
	 * List availble widget in theme
	 * @var array
	 *
	 * @access public
	 */
	public $list_widgets = array(
		'pages',
		'calendar',
		'archives',
		'meta',
		'search',
		'text',
		'categories',
		'recent-posts',
		'recent-comments',
		'rss',
		'tag_cloud',
		'nav_menu',
		'widget-follow-us',
		'awe-event',
		'awe_recent_posts_widget',
	);

	/**
	 * Array contain option name as key and option value as value to store in db
	 * @var array
	 *
	 * @access public
	 */
	protected $backup = array();

	/**
	 * Construct
	 * @param array $args array contain sidebar id as key and value is array of widget data. Default array()
	 * @param array $list_widgets list extra widget. Default array()
	 * @param array $backup Array contain option name as key and option value as value to store in db. Default array()
	 */
	public function __construct($args = array(), $list_widgets = array(), $backup = array()) {
		$this->args = (array) $args;
		$this->list_widgets = array_merge($this->list_widgets, $list_widgets);
		$this->backup = array_merge($this->backup, $backup);
		// $this->import();
	}

	/**
	 * Import widgets in $args
	 * @return void
	 * @param Sidebar Widget Data
	 */
	public function import($args = array()) {
		$this->args = array_merge($this->args, (array) $args);
		// Backup
		$this->backup();

		// Deactive crrent widgets
		$this->deactive_current_widget();
		$wg_ids = array();
		foreach ($this->args as $sidebar_id => $widgets) {
			if (!$this->sidebar_exists($sidebar_id)) {
				$this->console_log('Sidebar ' . $sidebar_id . ' does not exist');
				continue;
			}

			// add widget to option
			foreach ($widgets as $wg) {
				$wg_id = esc_attr($wg['widget_id']);

				if (!$this->widget_exists($wg_id)) {
					$this->console_log('Widget ' . $wg_id . ' does not exists');
					continue;
				}
				// Get next widget id number
				if (!function_exists('next_widget_id_number')) {
					require_once ABSPATH . '/wp-admin/includes/widgets.php';
				}

				$id_number = next_widget_id_number($wg_id);
				if(in_array($wg_id . '-' . $id_number, $wg_ids)){
					$id_number = $id_number+1;
					$wg_id_number = $wg_id . '-' . $id_number;
				}else{
					$wg_id_number = $wg_id . '-' . $id_number;
				}

				$wg_ids[] = $wg_id_number;

				// Save widget to option
				if (!$this->save_widget($wg, $id_number)) {
					$this->console_log('Error save widget ' . $wg_id_number);
				}

				// Save widget to sidebar
				if (!$this->save_widget_sidebar($sidebar_id, $wg_id_number)) {
					$this->console_log('Error save sidebars widgets ' . $sidebar_id . '-' . $wg_id_number);
				}
			}
		}

	}

	/**
	 * Backup widgets data
	 * @return array Backup data
	 */
	public function backup() {
		$this->backup['sidebars_widgets'] = wp_get_sidebars_widgets();
		foreach ($this->list_widgets as $v) {
			$field = 'widget_' . $v;
			$this->backup[$field] = get_option($field);
		}
		awe_import_log::log_widget($this->backup);
		return $this->backup;
	}

	/**
	 * Check sidebar exists
	 * @param  string $sidebar_id Sidebar id
	 * @return bool             True if sidebar exists
	 */
	protected function sidebar_exists($sidebar_id) {
		global $wp_registered_sidebars;
		return isset($wp_registered_sidebars[$sidebar_id]);
	}

	/**
	 * Check widget exists
	 * @param  string $widget_id Widget id base
	 * @return bool            True if widget exists
	 */
	protected function widget_exists($widget_id) {
		return in_array($widget_id, $this->list_widgets);
	}

	/**
	 * Deactive all current widget
	 * @return bool
	 */
	protected function deactive_current_widget() {
		$sidebars_widgets = get_option('sidebars_widgets');

		$inactive = isset($sidebars_widgets['wp_inactive_widgets']) && is_array($sidebars_widgets['wp_inactive_widgets']) ? $sidebars_widgets['wp_inactive_widgets'] : array();

		foreach ($sidebars_widgets as $k => $v) {
			if ($k == 'wp_inactive_widgets') {
				continue;
			}
			$v = (array) $v;
			$inactive = array_merge($inactive, $v);
			$sidebars_widgets[$k] = array();
		}

		$sidebars_widgets['wp_inactive_widgets'] = $inactive;

		return update_option('sidebars_widgets', $sidebars_widgets);
	}

	/**
	 * Save widgets data to option
	 * @param  array $widget Widget data
	 * @param  int $id_number Widget id number
	 * @return bool
	 */
	protected function save_widget($widget, $id_number) {
		$widget_option = is_array(get_option('widget_' . $widget['widget_id'])) ? get_option('widget_' . $widget['widget_id']) : array();
		$widget_option[$id_number] = isset($widget['params']) ? (array) $widget['params'] : array();
		return update_option('widget_' . $widget['widget_id'], $widget_option);
	}

	/**
	 * Save sidebars widgets data to option
	 * @param  string $sidebar_id Sidebar id
	 * @param  string $widget_id_number Widget id number
	 * @return bool
	 */
	protected function save_widget_sidebar($sidebar_id, $widget_id_number) {
		$sidebars_widgets = get_option('sidebars_widgets');

		$sidebars_widgets[$sidebar_id][] = $widget_id_number;

		return update_option('sidebars_widgets', $sidebars_widgets);
	}

	protected function console_log($message) {

	}

}

/**
 * Import Plugin
 */
class awe_import_plugin {

	static function theme_setting($file) {
		$lang_option = apply_filters('awe_get_option_by_lang', '"' . THEME_OPTIONS_NAME . '"');
		$log_setting = serialize(get_option($lang_option));
		$log = awe_import_log::log_theme_setting($lang_option, $log_setting);
		$theme_setting = awe_import_content::get_content_file($file);
		$log_setting = unserialize($theme_setting);
		update_option($lang_option, $log_setting );
	}

	static function add_room_type($data) {
		if (class_exists('APB_Booking')) {
			// meta_key : apb_gallery , room_desc , _feature_image_second, awe-room-type-setting-title, awe-room-type-setting-subtitle, awe-room-type-setting-image
			$tb_room_type = 'rooms_unit_type';
			$label = $data['label'];
			$wpdb->insert(
					$wpdb->prefix . $tb_room_type, array(
				'type' => sanitize_title($label),
				'label' => $label,
				'status' => 1,
				'data' => serialize($data_room_type),
				'object_id' => wp_kses($data['object_id'], ''),
					), array('%s', '%s', '%d', '%s')
			);
			$insert_id = $wpdb->insert_id; // Return Inserted ID
		} else {
			return 'Install Awe Booking first';
		}
	}

}


// Extra function
function hillter_add_room_data( $room_id, $meta ) {
	foreach ( $meta as $k => $v ) {
		update_post_meta( $room_id, $k, $v );
	}
}
