<?php awe_coming_soon_template(); ?>
<!DOCTYPE html>
<html <?php language_attributes('html'); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <meta name="format-detection" content="telephone=no">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <?php do_action('header_favicon'); ?>
    <link rel="profile" href="http://gmpg.org/xfn/11"/>
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>"/>
    <!--[if lt IE 9]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <script src="http://css3-mediaqueries-js.googlecode.com/svn/trunk/css3-mediaqueries.js"></script>
    <![endif]-->
    <?php wp_head(); ?>
</head>

<?php
$extra_class = '';
$layout = awe_sidebar_layout_option();
if ( $layout['sidebar'] == 'right' ) {
    $extra_class .= ' sidebar-right';
}
if ( $layout['sidebar'] == 'left' ) {
    $extra_class .= ' sidebar-left';
}

$extra_class .= ' ' . awe_get_header_transparent_class();
$extra_class = trim( $extra_class );
// echo '<pre>';
// // print_r(get_metadata('post', 57));
// print_r(get_post_meta(57, 'room_type_id', true));
// echo '</pre>';
?>

<!--[if IE 7]>
<body <?php body_class( 'ie7 lt-ie8 lt-ie9 lt-ie10 ' . $extra_class ); ?>> <![endif]-->
<!--[if IE 8]>
<body <?php body_class( 'ie8 lt-ie9 lt-ie10 ' . $extra_class ); ?>> <![endif]-->
<!--[if IE 9]>
<body <?php body_class( 'ie9 lt-ie10 ' . $extra_class ); ?>> <![endif]-->
<!--[if (gt IE 9)|!(IE)]><!-->
<body <?php body_class( $extra_class ); ?>> <!--<![endif]-->

<?php
// Change header to 404 and commingsoon
$cms = awe_coming_soon_option();
if (is_404()) {
    if ($cms == 0) {
        return;
    }
}
?>

<?php awe_preload(); ?>

<!-- PAGE WRAP -->
<div id="page-wrap">
    <?php if ($cms == 0) : ?>
        <!-- HEADER -->
        <header id="header">
            <!-- HEADER TOP -->
            <div class="header_top">
                <div class="container">
                    <div class="header_left float-left">
                        <?php do_action('header_extra_information'); ?>
                        <span><i class="fa fa-envelope-o"></i>info@easternpremierhotel.com</span>
                    </div>
                    <div class="header_right float-right">
                        <?php do_action('top_navigation'); ?>
                    </div>
                </div>
            </div>
            <!-- END / HEADER TOP -->

            <!-- HEADER LOGO & MENU -->
            <?php
            /**
             * hillter_sticky_enable filter hook.
             * @var bool
             *
             * @since Hillter 1.4
             *
             * @hooked hillter_sticky_enable - 10
             */
            $sticky_enable = apply_filters( 'hillter_sticky_enable', true );
            ?>
            <div id="header_content" class="header_content <?php if ( $sticky_enable ) echo 'sticky-enable'; ?>">

                <div class="container">
                    <!-- HEADER LOGO -->
                    <?php do_action('header_logo'); ?>
                    <!-- END / HEADER LOGO -->

                    <!-- HEADER MENU -->
                    <nav class="header_menu">
                        <?php do_action('primary_navigation'); ?>
                    </nav>
                    <!-- END / HEADER MENU -->

                    <!-- MENU BAR -->
                    <div class="menu-bars"><span></span></div>
                    <!-- END / MENU BAR -->

                </div>
            </div>
            <!-- END / HEADER LOGO & MENU -->

        </header>
        <!-- END / HEADER -->

        <!--End coming soon-->
    <?php endif; ?>
