<?php
/**
 * Footer Template
 *
 * @package Hillter
 * @author Awethemes
 */

global $hillter_option;
$newsletter = isset( $hillter_option['content']['newsletter'] ) ? $hillter_option['content']['newsletter'] : '';
$newsletter_enable = $newsletter_heading = $newsletter_shortcode = $newsletter_social = '';
// Switch to 404
if ( ! is_404() ) :
	// Switch to Comming soon
	if ( awe_coming_soon_option() != 1 ) :
	// if ( ! isset( $_GET['comingsoon'] ) ) :
		?>
        <!-- FOOTER -->
        <footer id="footer" class="footer">

            <!-- FOOTER TOP -->
			<?php
			if ( $newsletter != '' ) {
				if ( $newsletter['enable'] == 1 ) {
					$newsletter_heading = $newsletter['heading'];
					$newsletter_shortcode = $newsletter['shortcode'];
					$newsletter_social = $newsletter['social'];
				?>
            <div class="footer_top">
                <div class="container">
					<div class="row">
						<!-- WIDGET MAILCHIMP -->
						<div class="col-lg-9">
							<div class="mailchimp">
								<?php if ( $newsletter_heading ) : ?>
									<h4><?php echo esc_html( $newsletter_heading ); ?></h4>
								<?php endif; ?>

								<?php if ( $newsletter_shortcode ) : ?>
									<div class="mailchimp-form">
										<?php echo do_shortcode( $newsletter_shortcode ); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
						<!-- END / WIDGET MAILCHIMP -->
						<?php if ( $newsletter_social == 1 ) : ?>
							<!-- WIDGET SOCIAL -->
							<div class="col-lg-3">
								<div class="social">
									<div class="social-content">
										<?php
										$list_social = array(
										'facebook'  => 'fa fa-facebook',
										'google'    => 'fa fa-google-plus',
										'twitter'   => 'fa fa-twitter-square',
										'github'    => 'fa fa-github-square',
										'instagram' => 'fa fa-instagram',
										'pinterest' => 'fa fa-pinterest',
										'linkedin'  => 'fa fa-linkedin-square',
										'skype'     => 'fa fa-skype',
										'tumblr'    => 'fa fa-tumblr',
										'youtube'   => 'fa fa-youtube',
										'vimeo'     => 'fa fa-vimeo-square',
										'flickr'    => 'fa fa-flickr',
										'dribbble'  => 'fa fa-dribbble',
										);
										foreach ( $list_social as $key => $value ) {
											if ( ! empty( $hillter_option['social'][$key]['url'] ) ) {
												echo ($hillter_option['social'][$key]['enable'] == 1) ? '<a target="_blank" href="' . esc_url( $hillter_option['social'][$key]['url'] ) . '"><i class="'.esc_attr( $value ).'"></i></a>' : '';
											} else {
												echo ($hillter_option['social'][$key]['enable'] == 1) ? '<i class="'.esc_attr( $value ).'"></i>' : '';
											}
										}
										?>
									</div>
								</div>
							</div>
							<!-- END / WIDGET SOCIAL -->
						<?php endif; ?>
					</div>
                </div>
            </div>
			<?php
				}
			}
			?>
            <!-- END / FOOTER TOP -->

            <?php
            $ft_app = ! empty( $hillter_option['footer']['ft_app'] ) ? $hillter_option['footer']['ft_app'] : 'w_c';
            switch ( $ft_app ) {
            	case 'widget':
            		$ft_widget_enable = true;
            		$ft_copy_enable = false;
            	break;
            	case 'copyright':
            		$ft_widget_enable = false;
            		$ft_copy_enable = true;
            	break;
            	case 'none':
            		$ft_widget_enable = $ft_copy_enable = false;
            	break;
            	default:
            		$ft_widget_enable = $ft_copy_enable = true;
            }
            ?>

            <?php if ( $ft_widget_enable ) : ?>
				<?php if ( is_active_sidebar( 'sidebar_footer' ) || is_active_sidebar( 'sidebar_footer-2' ) || is_active_sidebar( 'sidebar_footer-3' ) || is_active_sidebar( 'sidebar_footer-4' ) ) { ?>
				<?php
				// Footer col
				$footer_col = isset( $hillter_option['footer']['ft_col'] ) && in_array( $hillter_option['footer']['ft_col'], array( 0, 1, 2, 3, 4 ) ) ? absint( $hillter_option['footer']['ft_col'] ) : 0;
				$col_class = array();
				switch ( $footer_col ) {
					case 1: // xs 12
						$col_class[0] = 'col-xs-12';
					break;

					case 2: // xs 12 sm 6
						$col_class[0] = 'col-xs-12 col-sm-6';
						$col_class[1] = 'col-xs-12 col-sm-6';
					break;

					case 3: // xs 12 sm 4
						$col_class[0] = 'col-xs-12 col-sm-4';
						$col_class[1] = 'col-xs-12 col-sm-4';
						$col_class[2] = 'col-xs-12 col-sm-4';
					break;

					case 4: // xs 12 sm 3
						$col_class[0] = 'col-xs-12 col-sm-3';
						$col_class[1] = 'col-xs-12 col-sm-3';
						$col_class[2] = 'col-xs-12 col-sm-3';
						$col_class[3] = 'col-xs-12 col-sm-3';
					break;

					default:
						$col_class[0] = 'col-xs-12 col-lg-5';
						$col_class[1] = 'col-xs-4 col-lg-3';
						$col_class[2] = 'col-xs-4 col-lg-2';
						$col_class[3] = 'col-xs-4 col-lg-2';
				}
				?>
	            <!-- FOOTER CENTER -->
	            <div class="footer_center">
	                <div class="container">
	                    <div class="row">
	                    	<?php foreach ( $col_class as $k => $v ) : ?>
		                        <div class="<?php echo esc_attr( $v ); ?>">
									<?php
									if ( $k ) {
										$sb_name = 'sidebar_footer-' . absint( $k + 1 );
									} else {
										$sb_name = 'sidebar_footer';
									}
									// print $sb_name . '<br>';
									if ( is_active_sidebar( $sb_name ) ) {
										dynamic_sidebar( $sb_name );
									}
									?>
		                        </div>
		                    <?php endforeach; ?>
	                    </div>
	                </div>
	            </div>
	            <!-- END / FOOTER CENTER -->
				<?php } ?>
			<?php endif; ?>

			<?php if ( $ft_copy_enable ) : ?>
	            <!-- FOOTER BOTTOM -->
	            <div class="footer_bottom">
	                <div class="container">
						<?php $copyright = isset( $hillter_option['footer']['copyright'] ) ? $hillter_option['footer']['copyright'] : __( 'Copyright &copy; by AweThemes.Com.', 'hillter' ); ?>
						<?php if ( $copyright ) : ?>
							<p><?php printf( __( '%s', 'hillter' ), wp_kses_post( $copyright ) ); ?></p>
						<?php endif; ?>
	                </div>
	            </div>
	            <!-- END / FOOTER BOTTOM -->
	        <?php endif; ?>

        </footer>
        <!-- END / FOOTER -->
	<?php
	endif;
endif;


?>
</div>
<!-- END / PAGE WRAP -->
<?php wp_footer(); ?>
</body>
</html>
