<?php if ( is_sticky() ) : ?>
    <article <?php post_class( 'sticky' ); ?>>
<?php else : ?>
    <article <?php post_class(); ?>>
<?php endif; ?>

    <?php if ( is_singular( 'post' ) == true ) : ?>

    <?php awe_the_thumbnail(); ?>

    <div class="entry-header">
        <h1 class="entry-title"><?php the_title(); ?></h1>
        <span class="posted-on">
            <a href="<?php echo get_day_link( get_the_time( 'Y' ), get_the_time( 'm' ), get_the_time( 'd' ) ); ?>"><strong><?php echo get_the_time( 'd' ); ?></strong><?php echo hillter_get_the_time( 'M' ); ?></a>
        </span>
        <?php if ( ! is_singular( 'tribe_events' ) ) : ?>
        <p class="entry-meta">
            <?php if ( is_sticky() ) : ?>
                <span class="fa fa-thumb-tack"></span>
            <?php endif; ?>
            <span class="entry-author">
                <span class="screen-reader-text"><?php esc_html_e( 'Posted by ', 'hillter' ); ?></span>
                <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>">
                    <span class="entry-author-name"><?php the_author_meta( 'display_name' ); ?></span>
                </a>
            </span>

            <?php get_category_post(); ?>

            <span class="entry-comments-link">
                <a href="<?php echo esc_url( get_permalink() ) . '#comments'; ?>"><?php comments_number(); ?></a>
            </span>

            <?php if (get_the_tag_list())  : ?>
                <span class="entry-tags">
                 <span class="screen-reader-text"><i class="fa fa-tags"></i></span>
                    <?php
                    echo get_the_tag_list('', ' - ', '');
                    ?>
             </span>
            <?php endif; ?>
        </p>
    <?php endif; ?>
    </div>
    <?php
        endif;
    ?>
    <div class="entry-content">
        <?php
        the_content();
        // awe_link_pages();
        wp_link_pages( array(
            'before'    => '',
            'after'     => '',
            'separator' => '',
            // 'nextpagelink'  => '<i class="fa fa-arrow-right"></i>',
            // 'previouspagelink'  => '<i class="fa fa-arrow-left"></i>',
            // 'link_before'   => '<li>',
            // 'link_after'    => '</li>',
        ) );
        ?>
    </div>
</article>
