<?php
$date = get_post_meta( get_the_ID(), 'awe_event_metabox_date', true ) ? strtotime( get_post_meta( get_the_ID(), 'awe_event_metabox_date', true ) ) : '';
$time = get_post_meta( get_the_ID(), 'awe_event_metabox_time', true ) ? esc_html( get_post_meta( get_the_ID(), 'awe_event_metabox_time', true ) ) : '';
$location = get_post_meta( get_the_ID(), 'awe_event_metabox_location', true ) ? esc_html( get_post_meta( get_the_ID(), 'awe_event_metabox_location', true ) ) : '';
?>
<!-- POST ITEM -->
<?php if ( is_sticky() ) : ?>
    <article <?php post_class( 'sticky hentry' ); ?>>
<?php else : ?>
    <article <?php post_class( 'hentry' ); ?>>
<?php endif; ?>

    <div class="entry-media" style="
    padding-top: 130px;
">
        <?php if ( has_post_thumbnail() ) : ?>
            <a href="<?php the_permalink(); ?>" class="post-thumbnail"><?php the_post_thumbnail( 'full' ); ?></a>
        <?php endif; ?>

        <?php if ( $date ) : ?>
            <div class="count-date" data-end="<?php echo date( 'Y/m/d H:i:s', $date ) ?>"></div>
        <?php endif; ?>

    </div>
    
    <div class="entry-header">
        <?php if ( $date ) : ?>
            <span class="posted-on"><strong><?php echo date( 'd', $date ); ?></strong><?php echo strtoupper( date_i18n( 'M', $date ) ); ?></span>
        <?php endif; ?>

        <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>

        <p class="entry-meta">
            <?php if ( is_sticky() ) : ?>
                <span class="fa fa-thumb-tack"></span>
            <?php endif; ?>

            <?php if ( $time ) : ?>
                <span class="event-time">
                    <span class="screen-reader-text"><?php _e( 'Event time:', 'hillter' ); ?></span>
                    <span class="et-time"><b><?php echo esc_html( $time ); ?></b></span>
                </span>
            <?php endif; ?>

            <?php if ( $location ) : ?>
                <span class="event-location">
                    <span class="screen-reader-text"><?php _e( 'Event location:', 'hillter' ); ?></span>
                    <span class="el-name"><b><?php echo esc_html( $location ); ?></b></span>
                </span>
            <?php endif; ?>
        </p>
    </div>

    <div class="entry-content">
        <?php the_content( '' ); ?>
    </div>

</article>
<!-- END / POST ITEM -->