<?php if ( is_sticky() ) : ?>
    <article <?php post_class( 'sticky' ); ?>>
<?php else : ?>
    <article <?php post_class(); ?>>
<?php endif; ?>

    <?php awe_the_thumbnail(get_the_ID()); ?>

    <div class="entry-header">

        <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
        <span class="posted-on">
            <a href="<?php echo get_day_link(get_the_time('Y'), get_the_time('m'), get_the_time('d')); ?>"><strong><?php echo get_the_time('d'); ?></strong><?php echo hillter_get_the_time( 'M' ); ?>
            </a>
        </span>
        <p class="entry-meta">
            <?php if ( is_sticky() ) : ?>
                <span class="fa fa-thumb-tack"></span>
            <?php endif; ?>
            
            <span class="entry-author">
                <span class="screen-reader-text"><?php esc_html_e('Posted by ', 'hillter'); ?></span>
                <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                    <span class="entry-author-name"><?php the_author_meta('display_name'); ?></span>
                </a>
            </span>

            <?php get_category_post(); ?>

            <span class="entry-comments-link">
                <a href="<?php echo esc_url(get_permalink()) . '#comments'; ?>"><?php comments_number(); ?></a>
            </span>
            <?php if (get_the_tag_list())  : ?>
             <span class="entry-tags">
                 <span class="screen-reader-text"><i class="fa fa-tags"></i></span>
                 <?php
                     echo get_the_tag_list('', ' - ', '');
                  ?>
             </span>
            <?php endif; ?>
        </p>
    </div>

    <div class="entry-content">
        <?php the_content( '' ); ?>
    </div>
</article>
