<?php


class AWE_Tax_Meta {

    protected $layout;
    protected $style;
    protected $masonry_col;
    protected $path = 'config/tax-meta/';

    public function __construct() {
        $this->layout = array(
            'left' => 'Left',
            'right' => 'Right',
            'no' => 'None'
        );

        // $taxes = get_taxonomies(array('show_ui' => true, 'public' => true), 'names');
        $taxes = array( 'category', 'post_tag' );
        foreach ($taxes as $tax) {
            add_action($tax . '_edit_form', array($this, 'render'), 100, 2);
        }
        // add_filter('default_layout', array($this, 'default_layout'));
        add_action('edit_term', array($this, 'save_meta_data_taxonomy'), 10, 2);
        add_action('delete_term', array($this, 'delete_meta_data_taxonomy'), 10, 2);
        add_filter('get_term', array($this, 'loading_term_meta_data'), 10, 2);
        add_filter('get_terms', array($this, 'loading_terms_meta_data'), 10, 2);

        add_action('admin_enqueue_scripts', array($this, 'load_script'));
    }

    public function load_script() {
        wp_register_script('awe-js-tax-meta', trailingslashit(get_template_directory_uri()) . $this->path . 'js/script.js');
        wp_enqueue_script('awe-js-tax-meta');
        wp_register_style('awe-tax-meta', trailingslashit(get_template_directory_uri()) . $this->path . 'css/style.css');
        wp_enqueue_style('awe-tax-meta');
    }

    public function save_meta_data_taxonomy($term_id, $tt_id) {
        if (defined('DOING_AJAX') && DOING_AJAX)
            return;

        $data = (array) get_option('awe_tax_meta');

        $data[$term_id] = isset($_POST['awe_tax_meta']) ? (array) $_POST['awe_tax_meta'] : array();

        // if (!current_user_can('unfiltered_html') && isset($data[$term_id]['archive_description']))
        //     $data[$term_id]['archive_description'] = $this->formatting_kses($data[$term_id]['archive_description']);
        update_option('awe_tax_meta', $data);
    }

    public function delete_meta_data_taxonomy($term_id, $tt_id) {
        $data = (array) get_option('awe_tax_meta');

        unset($data[$term_id]);

        update_option('awe_tax_meta', (array) $data);
    }

    public function loading_term_meta_data($term, $taxonomy) {
        if (!is_object($term))
            return $term;

        $data = get_option('awe_tax_meta');
        $term_meta_data = isset($data[$term->term_id]) ? $data[$term->term_id] : array();
        $term->meta_data = wp_parse_args($term_meta_data, apply_filters('awe_meta_data_defaults', array(
            'layout' => 'default',
            'sidebar_id' => '0',
        )));

        foreach ($term->meta_data as $field => $value)
            $term->meta_data[$field] = apply_filters('awe_term_meta_data' . $field, stripslashes(wp_kses_decode_entities($value)), $term, $taxonomy);

        $term->meta_data = apply_filters('awe_term_meta_data', $term->meta_data, $term, $taxonomy);

        return $term;
    }

    public function loading_terms_meta_data(array $terms, $taxonomy) {
        foreach ($terms as $term)
            $term = $this->loading_term_meta_data($term, $taxonomy);
        return $terms;
    }

    public function render($tag, $taxonomy) {
        global $wp_registered_sidebars;
        $sidebar_list = array_merge( array( '0' => array( 'name' => __( 'As Theme Option', 'hillter' ) ) ), $wp_registered_sidebars );
        $tax = get_taxonomy($taxonomy);
        $meta_data = $tag->meta_data;

        ?>

            <h2><?php echo esc_html($tax->labels->singular_name) . ' ' . __('Layout Settings', 'hillter'); ?></h2>

            <table class="form-table">
                <tr class="form-field">
                    <th scope="row"><?php _e('Choose Layout', 'hillter'); ?></th>
                    <td>
                        <p>
                            <label for="awe-meta-layout-default-field" class="default">
                                <input type="radio" <?php checked($meta_data['layout'], "default"); ?> value="default" id="awe-meta-layout-default-field" class="awe-meta-default-layout"><?php _e('Default Layout set in theme option', 'hillter'); ?>
                            </label>
                        <p>
                        <div class="md-layout-choose">
                            <ul class="clearfix" id="awe-meta-list-layout">
                                <?php foreach ($this->layout as $k => $v): ?>
                                    <li>
                                        <a data-name="<?php print $k; ?>" <?php if ($meta_data['layout'] == $k) print 'class="active"'; ?> href="#"><img src="<?php echo trailingslashit(get_template_directory_uri()) . $this->path . '/images/' . $v . '.png'; ?>" alt=""></a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <input type="hidden" value="<?php print $meta_data['layout']; ?>" name="awe_tax_meta[layout]" id="awe-meta-layout-field" />
                        </div>
                    </td>
                </tr>
                <tr class="form-field">
                    <th><label for="awe-meta-sidebar-id"><?php _e('Sidebar choose?', 'hillter'); ?></label></th>
                    <td>
                        <select id="awe-meta-sidebar-id" name="awe_tax_meta[sidebar_id]">
                            <?php foreach ($sidebar_list as $k => $v) : ?>
                                <option value="<?php echo esc_attr($k); ?>" <?php selected($k, isset($meta_data['sidebar_id']) ? $meta_data['sidebar_id'] : '0') ?>><?php echo esc_html($v['name']); ?></option>
                            <?php endforeach; ?>
                        </select>
                    </td>
                </tr>
            </table>

        <?php
    }

    public static function get_meta($term_id, $field) {
        $awe_tax_meta = get_option('awe_tax_meta') ? (array)get_option('awe_tax_meta') : array();
        if (!isset($awe_tax_meta[$term_id])) {
            return false;
        }
        if (!isset($awe_tax_meta[$term_id][$field])) {
            return false;
        }
        return $awe_tax_meta[$term_id][$field];
    }

}

new AWE_Tax_Meta();