<?php

function awe_init_sidebar_setting() {
	new AWE_Sidebar_Setting();
}

if ( is_admin() ) {
	add_action( 'load-post.php', 'awe_init_sidebar_setting' );
	add_action( 'load-post-new.php', 'awe_init_sidebar_setting' );
}

class AWE_Sidebar_Setting {

	public function __construct() {
		add_action( 'add_meta_boxes', array( $this, 'add_meta_box' ) );
		add_action( 'save_post', array( $this, 'save' ) );
	}

	public function add_meta_box( $post_type ) {
		$post_types = apply_filters( 'hillter_sidebar_setting_post_type_support', array( 'post', 'page', 'event', 'apb_room_type' ) );
		if ( in_array( $post_type, $post_types ) ) {
			add_meta_box( 'awe-sidebar-setting', __( 'Layout Setting', 'hillter' ), array( $this, 'render' ), $post_type, 'side', 'low' );
		}
	}

	public function save( $post_id ) {
		// Check if our nonce is set.
		if ( ! isset( $_POST['awe_sidebar_setting_nonce_field'] ) ) {
			return $post_id;
		}

		$nonce = $_POST['awe_sidebar_setting_nonce_field'];

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $nonce, 'awe_sidebar_setting_nonce' ) ) {
			return $post_id;
		}

		// If this is an autosave.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
			return $post_id;
		}

		// Check the user's permissions.
		if ( 'page' == $_POST['post_type'] ) {
			if ( ! current_user_can( 'edit_page', $post_id ) ) {
				return $post_id;
			}
		} else {
			if ( ! current_user_can( 'edit_post', $post_id ) ) {
				return $post_id;
			}
		}

		// OK.
		$sb_pos = in_array( $_POST['awe_sidebar_position'], array( 'no', 'right', 'left' ) ) ? $_POST['awe_sidebar_position'] : 'default';
		update_post_meta( $post_id, 'awe_sidebar_position', $sb_pos );

		$sb = strip_tags( $_POST['awe_sidebar_select'] );
		update_post_meta( $post_id, 'awe_sidebar_select', $sb );

		$header_transparent = in_array( $_POST['awe_header_transparent'], array( 'no', 'yes' ) ) ? $_POST['awe_header_transparent'] : 'no';
		update_post_meta( $post_id, 'awe_header_transparent', $header_transparent );
	}

	public function render( $post ) {
		global $wp_registered_sidebars;

		$sidebar_list = array_merge( array( '0' => array( 'name' => __( 'As Theme Setting', 'hillter' ) ) ), $wp_registered_sidebars );

		wp_nonce_field( 'awe_sidebar_setting_nonce', 'awe_sidebar_setting_nonce_field' );

		$sb_pos = get_post_meta( $post->ID, 'awe_sidebar_position', true ) ? get_post_meta( $post->ID, 'awe_sidebar_position', true ) : 'default';
		$sb = get_post_meta( $post->ID, 'awe_sidebar_select', true ) ? get_post_meta( $post->ID, 'awe_sidebar_select', true ) : '0';
		$header_transparent = get_post_meta( $post->ID, 'awe_header_transparent', true ) ? get_post_meta( $post->ID, 'awe_header_transparent', true ) : 'no';
		?>

		<?php if ( 'apb_room_type' != $post->post_type ) : ?>
			<div id="awe-sidebar-position-wrap" class="awe-sidebar-setting-control-wrap">
				<label for="awe-sidebar-position"><strong><?php esc_html_e( 'Sidebar Position', 'hillter' ); ?></strong></label>
				<p>Setting the sidebar layout for this page.</p>
				<select class="widefat <?php echo ! get_post_meta( $post->ID, 'awe_sidebar_position', true ) ? 'unset' : ''; ?>" id="awe-sidebar-position" name="awe_sidebar_position">
					<option value="default" <?php selected( $sb_pos, 'default' ); ?>><?php esc_html_e( 'As Theme Setting', 'hillter' ); ?></option>
					<option value="no" <?php selected( $sb_pos, 'no' ); ?>><?php esc_html_e( 'No sidebar', 'hillter' ); ?></option>
					<option value="right" <?php selected( $sb_pos, 'right' ); ?>><?php esc_html_e( 'Right', 'hillter' ); ?></option>
					<option value="left" <?php selected( $sb_pos, 'left' ); ?>><?php esc_html_e( 'Left', 'hillter' ); ?></option>
				</select>
			</div>

			<div id="awe-sidebar-select-wrap" class="awe-sidebar-setting-control-wrap" <?php echo 'no' == $sb_pos ? 'style="display:none"' : ''; ?>>
				<label for="awe-sidebar-select"><strong><?php esc_html_e( 'Choose Sidebar', 'hillter' ); ?></strong></label>
				<p><?php printf( esc_html__( 'Choose any sidebar area you want. It\'s created in %s', 'hillter' ), '<b>' . esc_html__( 'Appearance > Widgets', 'hillter' ) . '</b>' ) ?></p>
				<select class="widefat" id="awe-sidebar-select" name="awe_sidebar_select">
					<?php foreach ( $sidebar_list as $k => $v ) : ?>
						<option value="<?php echo esc_attr( $k ); ?>" <?php selected( $sb, $k ); ?>><?php echo esc_html( $v['name'] ); ?></option>
					<?php endforeach; ?>
				</select>
			</div>
		<?php endif; ?>

		<div id="awe-header-transparent-setting-wrap" class="awe-sidebar-setting-control-wrap">
			<label for="awe-header-transparent-setting"><strong><?php esc_html_e( 'Header Transparent', 'hillter' ); ?></strong></label>
			<p><?php esc_html_e( 'The visibility of Header Menu', 'hillter' ) ?></p>
			<select class="widefat" id="awe-header-transparent-setting" name="awe_header_transparent">
				<option value="no" <?php selected( $header_transparent, 'no' ); ?>><?php esc_html_e( 'No transparent', 'hillter' ); ?></option>
				<option value="yes" <?php selected( $header_transparent, 'yes' ); ?>><?php esc_html_e( 'Header transparent', 'hillter' ); ?></option>
			</select>
		</div>

		<style type="text/css">
			.awe-sidebar-setting-control-wrap {
				margin-bottom: 20px;
			}
		</style>

		<script type="text/javascript">
			(function($) {
				"use strict";

				$(document).ready(function() {
					$("#awe-sidebar-position").change(function() {
						$(this).removeClass("unset");
						if ($(this).val() == 'no')
							$("#awe-sidebar-select-wrap").hide();
						else
							$("#awe-sidebar-select-wrap").show();
					});
				});
			})(jQuery);
		</script>
	<?php
	}
}
