<?php

/**
 * Project of Megadrupal.com
 * Author: duongle
 * Date: 4/15/14
 * Time: 1:20 PM
 * Update : 12/3/15
 */

/**
 * Loading scripts
 */

function awe_active_extra_font() {
	global $hillter_option;
	echo isset( $hillter_option['font']['google'] ) ? $hillter_option['font']['google'] : '' ;
}
add_action( 'wp_head','awe_active_extra_font' );

function awe_loading_script() {
	global $post;
	$url = get_template_directory_uri() . '/assets/js/';
	// wp_enqueue_script( 'jquery' );
	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
	}
	/**
	 * Loading Library JS
	 */

	wp_enqueue_script( 'jquery-ui-accordion' );
	wp_enqueue_script( 'jquery-ui-tabs' );	
	wp_enqueue_script( 'jquery-ui-datepicker' );
	// wp_enqueue_script( 'awe-jquery-ui', $url . 'lib/jquery-ui.min.js', array(), null, true );
	wp_enqueue_script( 'awe-bootstrap', $url . 'lib/bootstrap.min.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'awe-bootstrap-select', $url . 'lib/bootstrap-select.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'awe-owl-carousel', $url . '/lib/owl.carousel.js', array( 'jquery' ), '2015620', true );
	wp_enqueue_script( 'awe-countdown', $url . 'lib/jquery.countdown.min.js', array( 'jquery' ), null, true );
	// wp_enqueue_script( 'awe-smoothscroll', $url . 'lib/SmoothScroll.js', array(), null, true );
	wp_enqueue_script( 'awe-countTo', $url . 'lib/jquery.countTo.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'awe-parallax', $url . 'lib/jquery.parallax-1.1.3.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'awe-appear', $url . 'lib/jquery.appear.min.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'awe-magnific-popup', $url . 'lib/jquery.magnific-popup.min.js', array( 'jquery' ), null, true );
	wp_enqueue_script( 'awe-imgloadded', $url . 'lib/imagesloaded.min.js', array( 'jquery' ), null, true );
	/**
	 * Loading Main JS
	 */
	wp_register_script( 'awe-main-script', $url . 'scripts.js', array( 'jquery' ), null, true );
	wp_localize_script('awe-main-script','awe_main',array(
		'url' => admin_url( 'admin-ajax.php' ),
		'textDays'	=> __( 'Days', 'hillter' ),
		'textHours'	=> __( 'Hours', 'hillter' ),
		'textMinutes'	=> __( 'Minutes', 'hillter' ),
		'textSeconds'	=> __( 'Seconds', 'hillter' ),
	));
	wp_enqueue_script( 'awe-main-script' );
}
add_action( 'wp_enqueue_scripts', 'awe_loading_script', 100 );



function awe_google_font_url() {
	$font_url = '';

    /*
    Translators: If there are characters in your 'hillter' that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own 'hillter'.
     */
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'hillter' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Hind:400,300,500,600|Montserrat:400,700' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}


/**
 * Loading Style CSS
 */
function awe_loading_style() {
	global $hillter_option;

	$url = get_template_directory_uri() . '/assets/css/';
	/**
	 * Loading Main Style
	 */
	wp_enqueue_style( 'font-awesome', $url . 'lib/font-awesome.min.css', false, false );
	wp_enqueue_style( 'jquery-ui', $url . 'lib/jquery-ui.min.css', false, false );
	wp_enqueue_style( 'bootstrap', $url . 'lib/bootstrap.min.css', false, false );
	wp_enqueue_style( 'awe-colio', $url . 'lib/font-hilltericon.css"', false, false);
	wp_enqueue_style( 'bootstrap-select', $url . 'lib/bootstrap-select.min.css', false, false );
	wp_enqueue_style( 'magnific-popup', $url . 'lib/magnific-popup.css"', false, false );
	wp_enqueue_style( 'awe-main-style', $url . 'style.css', false, false );

	$custom_css = '';

	$custom_color = ! empty( $hillter_option['extra']['custom_color'] ) ? $hillter_option['extra']['custom_color'] : '';
	if ( ! empty( $custom_color ) ) {
		$custom_css .= '
			.accomd-modations-room .text,
			.gallery-cat ul li:hover a, .gallery-cat ul li.active a,
			.footer .footer_top,
			.reservation,
			.awe-no-header-transparent .header_content,
			.header_mobile,
			.awe-datepicker.ui-datepicker .ui-datepicker-header, 
			.apb-datepicker.ui-datepicker .ui-datepicker-header,
			.awe-datepicker.ui-datepicker .ui-datepicker-calendar thead th, 
			.apb-datepicker.ui-datepicker .ui-datepicker-calendar thead th,
			.awe-datepicker.ui-datepicker .ui-datepicker-calendar td a.ui-state-active, 
			.awe-datepicker.ui-datepicker .ui-datepicker-calendar td a:hover, 
			.apb-datepicker.ui-datepicker .ui-datepicker-calendar td a.ui-state-active, 
			.apb-datepicker.ui-datepicker .ui-datepicker-calendar td a:hover,
			.header_content .menu > li .sub-menu li:hover > a, 
			.header_top .sub-menu li:hover > a,
			.header_content .menu > li .sub-menu li.current-menu-item > a {
				background-color: ' . $custom_color . ';
			}
			.restaurant_item .text .price,
			.tabs-restaurant .ui-tabs-nav li:hover a, .tabs-restaurant .vc_tta-tabs-list li:hover a .vc_tta-title-text,
			.tabs-restaurant .vc_tta-tabs-list li.vc_active a .vc_tta-title-text, .tabs-restaurant .ui-tabs-nav li.ui-state-active a, 
			.news-item .text .read-more:hover,
			.awe-posts .news-item h3:hover a,
			h1 a:hover, .h1 a:hover, 
			h2 a:hover, .h2 a:hover, 
			h3 a:hover, .h3 a:hover, 
			h4 a:hover, .h4 a:hover, 
			h5 a:hover, .h5 a:hover, 
			h6 a:hover, .h6 a:hover,
			.event-restaurant_content li .text a:hover,
			.contact ul li .icon {
				color: ' . $custom_color . '
			}
			.tabs-restaurant .ui-tabs-nav li:before,
			.tabs-restaurant .vc_tta-tabs-list li:before {
				border-top-color: ' . $custom_color . ';
			}

			.header_content,
			.hentry .entry-media .count-date,
			.room_item-6 .text {
				background-color: ' . hillter_hex2rgba( $custom_color, 0.85 ) . ';
			}
			
			';

	}

	$custom_color = ! empty( $hillter_option['extra']['button_color'] ) ? $hillter_option['extra']['button_color'] : '';
	if ( ! empty( $custom_color ) ) {
		$custom_css .= '
			.awe-btn, input[type=submit], 
			button, 
			.activiti_item .text .view-more, 
			.awe-btn.awe-btn-default, 
			.awebooking .apb-btn, 
			.awebooking .apb-btn:visited,
			.awebooking-wrapper.custom-hillter .apb-btn,
			.awe-btn.awe-btn-outline:hover {
				background-color: ' . $custom_color . ';
			}
			.awe-btn:hover, .awe-btn:focus, .awe-btn.awe-btn-default:hover,
			.awebooking-wrapper.custom-hillter .apb-btn:hover {
				background-color: ' . hillter_hex2rgba( $custom_color, 0.8 ) . ';
			}
			.awe-btn.awe-btn-outline:hover {
				border-color: ' . $custom_color .'
			}


			';

	}


	$custom_color = ! empty( $hillter_option['extra']['navigation_color'] ) ? $hillter_option['extra']['navigation_color'] : '';
	if ( ! empty( $custom_color ) ) {
		$custom_css .= '
			.awe-no-header-transparent .header_content,
			.header_content .menu > li .sub-menu li.current-menu-item > a,
			.header_content .menu > li .sub-menu li:hover > a,
			.header_top .sub-menu li:hover > a {
				background-color: ' . $custom_color . ';
			}
			.header_content,
			.header_mobile,
			.header_mobile .header_menu {
				background-color: ' . hillter_hex2rgba( $custom_color, 0.85 ) . ';
			}';
	}

	$custom_color = ! empty( $hillter_option['extra']['navigation_text_color'] ) ? $hillter_option['extra']['navigation_text_color'] : '';
	if ( ! empty( $custom_color ) ) {
		$custom_css .= '
			.header_content .menu > li > a,
			.header_top .sub-menu li:hover > a,
			.header_mobile .header_menu ul li a{
				color: ' . $custom_color . ';
			}';
	}


	$custom_color = ! empty( $hillter_option['extra']['footer_color'] ) ? $hillter_option['extra']['footer_color'] : '';
	if ( ! empty( $custom_color ) ) {
		$custom_css .= '
			.footer .footer_center,
			.footer .footer_bottom {
				background-color: ' . $custom_color . ';
			}';
	}



	$custom_color = ! empty( $hillter_option['extra']['footer_text_color'] ) ? $hillter_option['extra']['footer_text_color'] : '';
	if ( ! empty( $custom_color ) ) {
		$custom_css .= '
			.footer .widget p,
			.footer .widget a,
			.footer .footer_bottom p,
			.footer .widget .widget-title {
				color: ' . $custom_color . ';
			}';
	}


	$custom_css = apply_filters( 'hillter_custom_css', $custom_css );


	if ( $custom_css ) {
		wp_add_inline_style( 'awe-main-style', $custom_css );
	}



	// wp_enqueue_style( 'awe-main', get_stylesheet_uri() );
	// Iconfont
	// wp_enqueue_style( 'awe-fa-font', get_template_directory_uri() . '/Framework/asset/icons/css/font-awesome.min.css' );

	wp_enqueue_style( 'awe-google-font', awe_google_font_url() );
}
add_action( 'wp_enqueue_scripts', 'awe_loading_style', 1005 );

// Add Style to footer
function awe_style_footer(){
	$url = get_template_directory_uri() . '/assets/css/';
	wp_enqueue_style( 'awe-carousel', $url . 'lib/owl.carousel.css', array(), false );
}
add_action('wp_enqueue_scripts','awe_style_footer');


/**
 * Loading Admin JS
 */
add_action( 'admin_enqueue_scripts', 'awe_load_admin_script' );

function awe_load_admin_script($hook) {
	global $pagenow;
	$url = get_template_directory_uri() . '/assets/css/';
	if ( in_array( $pagenow, array( 'post.php', 'post-new.php' ) ) && is_admin() ) {
		wp_register_script(
			'awe_meta_box_script', //unique handle
			get_template_directory_uri() . '/assets/js/media_metabox.js', //location
			array( 'jquery' )  //dependencies
		);
	}
	// Enqueued script with localized data.
	wp_enqueue_script( 'awe_meta_box_script' );
	wp_enqueue_script( 'jquery-ui-datepicker' );
	if ( in_array( 'AWE-Framework', $_REQUEST ) ) {
		wp_enqueue_style( 'awe-jqueryui', get_template_directory_uri() . '/Framework/asset/css/jquery-ui.css', false, false );
	}
	if ( in_array( 'AWE-Framework', $_REQUEST ) || in_array( 'AWE-Modules', $_REQUEST ) || in_array( 'AWE-Security', $_REQUEST ) || in_array( 'AWE-Update', $_REQUEST ) || in_array( 'AWE-ImportData', $_REQUEST ) ) {
		return;
	}

}



