<?php

class AWE_Room_Type_Setting {

	protected $screen = array( 'apb_room_type' );

	public function __construct() {

		// Add meta box
		add_action('add_meta_boxes', array($this, 'add_meta_box'));

		// Save meta value
		add_action('save_post', array($this, 'save'));

	}


	public function add_meta_box( $post_type ) {
		if ( in_array( $post_type, $this->screen ) ) {
			add_meta_box( 'awe-room-type-setting', __( 'Template options', 'hillter' ), array( $this, 'render' ), $post_type, 'normal', 'low' );
		}
	}


	public function save( $post_id ) {
		// Check if our nonce is set.
		if ( ! isset( $_POST['awe_room_type_setting_nonce_field'] ) )
			return $post_id;

		$nonce = $_POST['awe_room_type_setting_nonce_field'];

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $nonce, 'awe_room_type_setting_nonce' ) )
			return $post_id;

		// If this is an autosave
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
			return $post_id;

		// Check the user's permissions.
		if ( ! current_user_can( 'edit_post', $post_id ) )
			return $post_id;

		// All OK

		// Title
		$value = isset( $_POST['awe-room-type-setting-title'] ) ? esc_html( $_POST['awe-room-type-setting-title'] ) : '';
		update_post_meta( $post_id, 'awe-room-type-setting-title', $value );

		// Subtitle
		$value = isset( $_POST['awe-room-type-setting-subtitle'] ) ? esc_html( $_POST['awe-room-type-setting-subtitle'] ) : '';
		update_post_meta( $post_id, 'awe-room-type-setting-subtitle', $value );

		// Image
		$value = isset( $_POST['awe-room-type-setting-image'] ) ? esc_url( $_POST['awe-room-type-setting-image'] ) : '';
		update_post_meta( $post_id, 'awe-room-type-setting-image', $value );

	}


	public function render( $post ) {
		wp_nonce_field( 'awe_room_type_setting_nonce', 'awe_room_type_setting_nonce_field' );

		$title = get_post_meta( $post->ID, 'awe-room-type-setting-title', true ) ? esc_html( get_post_meta( $post->ID, 'awe-room-type-setting-title', true ) ) : '';
		$subtitle = get_post_meta( $post->ID, 'awe-room-type-setting-subtitle', true ) ? esc_html( get_post_meta( $post->ID, 'awe-room-type-setting-subtitle', true ) ) : '';
		$image = get_post_meta( $post->ID, 'awe-room-type-setting-image', true ) ? esc_url( get_post_meta( $post->ID, 'awe-room-type-setting-image', true ) ) : '';

		?>

			<div id="awe-room-type-setting-container" class="awe-thumbnail-meta-box-container">

				<div class="awe-room-type-setting-title">
					<label for="awe-room-type-setting-title"><?php _e( 'Title', 'hillter' ); ?></label><br>
					<input type="text" name="awe-room-type-setting-title" id="awe-room-type-setting-title" value="<?php echo esc_html( $title ); ?>">
				</div>

				<div class="awe-room-type-setting-subtitle">
					<label for="awe-room-type-setting-subtitle"><?php _e( 'Subtitle', 'hillter' ); ?></label><br>
					<input type="text" name="awe-room-type-setting-subtitle" id="awe-room-type-setting-subtitle" value="<?php echo esc_html( $subtitle ); ?>">
				</div>

				<div class="awe-room-type-setting-image">
					<label><?php _e( 'Parallax Image', 'hillter' ) ?></label>
					<div class="image-view">
						<?php if ( $image ) : ?>
							<img src="<?php echo esc_url( $image ); ?>">
						<?php else : ?>
							<img src="<?php echo esc_url( get_template_directory_uri() . '/awe-thumbnail/assets/images/no-image.jpg' ); ?>">
						<?php endif; ?>
					</div>

					<div class="control">
						<button type="button" class="button button-primary single-image-upload-btn"><?php _e( 'Choose Image', 'hillter' ); ?></button>
						<button type="button" class="button single-image-remove-btn" data-no-image="<?php echo esc_url( get_template_directory_uri() . '/awe-thumbnail/assets/images/no-image.jpg' ); ?>"><?php _e( 'Remove', 'hillter' ); ?></button>
					</div>

					<input type="hidden" name="awe-room-type-setting-image" value="<?php echo esc_url( $image ); ?>">
				</div>

			</div>

		<?php
	}

}

new AWE_Room_Type_Setting();
