<?php

class AWE_Page_Setting {

	protected $screen = array( 'page' );

	public function __construct() {

		// Add meta box
		add_action('add_meta_boxes', array($this, 'add_meta_box'));

		// Save meta value
		add_action('save_post', array($this, 'save'));

	}


	public function add_meta_box( $post_type ) {
		if ( in_array( $post_type, $this->screen ) ) {
			add_meta_box( 'awe-page-setting', __( 'Page Setting', 'hillter' ), array( $this, 'render' ), $post_type, 'normal', 'low' );
		}
	}


	public function save( $post_id ) {
		// Check if our nonce is set.
		if ( ! isset( $_POST['awe_page_setting_nonce_field'] ) )
			return $post_id;

		$nonce = $_POST['awe_page_setting_nonce_field'];

		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $nonce, 'awe_page_setting_nonce' ) )
			return $post_id;

		// If this is an autosave
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )
			return $post_id;

		// Check the user's permissions.
		if ( ! current_user_can( 'edit_post', $post_id ) )
			return $post_id;

		// All OK

		// Image
		$value = isset( $_POST['awe-page-setting-image'] ) ? esc_url( $_POST['awe-page-setting-image'] ) : '';
		update_post_meta( $post_id, 'awe-page-setting-image', $value );

	}


	public function render( $post ) {
		wp_nonce_field( 'awe_page_setting_nonce', 'awe_page_setting_nonce_field' );

		$image = get_post_meta( $post->ID, 'awe-page-setting-image', true ) ? esc_url( get_post_meta( $post->ID, 'awe-page-setting-image', true ) ) : '';

		?>

			<div id="awe-page-setting-container" class="awe-thumbnail-meta-box-container">

				<div class="awe-page-setting-image">
					<label><?php _e( 'Parallax Image', 'hillter' ) ?></label>
					<div class="image-view">
						<?php if ( $image ) : ?>
							<img src="<?php echo esc_url( $image ); ?>">
						<?php else : ?>
							<img src="<?php echo esc_url( get_template_directory_uri() . '/awe-thumbnail/assets/images/no-image.jpg' ); ?>">
						<?php endif; ?>
					</div>

					<div class="control">
						<button type="button" class="button button-primary single-image-upload-btn"><?php _e( 'Choose Image', 'hillter' ); ?></button>
						<button type="button" class="button single-image-remove-btn" data-no-image="<?php echo esc_url( get_template_directory_uri() . '/awe-thumbnail/assets/images/no-image.jpg' ); ?>"><?php _e( 'Remove', 'hillter' ); ?></button>
					</div>

					<input type="hidden" name="awe-page-setting-image" value="<?php echo esc_url( $image ); ?>">
				</div>

			</div>

		<?php
	}

}

// new AWE_Page_Setting();
