<?php

/**
 * Project of Megadrupal.com
 * Author: duongle
 * Date: 4/14/14
 * Time: 6:06 PM
 */
if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
defined( 'LANGUAGE' ) || Define("LANGUAGE", "hillter");
Define("THEME_NAME", "Hillter");
Define("THEME_OPTIONS_NAME", "Hillter");
Define("AWE_DEBUG", false);
/**
 * Initialize Theme
 */
if (!function_exists('awe_theme_setup')) :

    function awe_theme_setup() {
        //register primary menu
        register_nav_menus(
                array(
                    'top_nav_menu' => __('Top Menu', 'hillter'),
                    'main_menu' => __('Main Menu', 'hillter'),
                )
        );

        /* Adding Theme support */
        add_theme_support('woocommerce');
        add_theme_support('html5');
        add_theme_support('jquery-cdn');
        add_theme_support('automatic-feed-links');
        /* Add support thumbnail */
        add_editor_style('custom-editor-style.css');
        // Feature blog - Hard crop
        add_theme_support('post-thumbnails');
        // Product Small - Hard Crop
        add_image_size('awe-gallery-square', 350, 350, true); // Gallery square 3 column
        add_image_size('awe-gallery-rectangular', 380, 265, true); // Gallery rectangular 3 column
        // Crop Image Room
        add_image_size('awe-room-slider', 720, 430, true); // home slider 1& 2,room 4, room 5, room 2, room 1
        add_image_size('awe-room-3', 970, 400, true); // Room 3

        add_image_size('awe-post-sc', 370, 230, true); // Blog post
        // add_image_size('awe-catalogue-lg', 270, 190, true); // Catalogue large


        // Feature Portfolio Large - Hard Crop
        add_filter('image_size_names_choose', 'awe_custom_image_sizes');
        add_theme_support('title-tag');
        add_theme_support( 'html5', array( 'search-form', 'gallery', 'image' , 'comment-list', 'comment-form' ) );
        // Add Post Format
        // add_theme_support('post-formats',array('standard','aside','chat','gallery','link','image','quote','status','audio'));
        function awe_custom_image_sizes($sizes) {
            return array_merge($sizes, array(
                'awe-product-small' => __('Product Small Thumbnail', 'hillter'),
                'awe-promotion-banner' => __('Promotion Thumbnail', 'hillter'),
                'awe-portfolio-large' => __('Portfolio Large', 'hillter'),
            ));
        }
}

endif;
add_action('after_setup_theme', 'awe_theme_setup', 11);

global $options_extra;
$options_extra = array(
    'page404' => array(
        'background' => get_template_directory_uri() . "/assets/images/default/bg-404.jpg",
        'title' => __( '404 ERROR', 'hillter' ),
        'desc' => __( 'We’re sorry, but the page you were looking for doesn’t exist.', 'hillter' ),
        'text' => __( 'Home Page', 'hillter' ),
        'link' => get_home_url(),
        'form_status' => 0
    )
);

function awe_sanitize_callback($value) {
    return $value;
}

/**
 * Loading Framework
 */
require_once( get_template_directory() . '/config/config-wpml.php');
require_once( get_template_directory() . '/config/config-framework.php');
require_once( get_template_directory() . '/config/config-footer.php');

/**
 * Loading Default Option
 */

function awe_get_options() {
        global $hillter_option;
        return $hillter_option['extra'];
}

/**
 * Check is woocomerce page
 * @param $page_id
 * @return boolean
 */
if (!function_exists('is_woocommerce_page')) {

    function is_woocommerce_page($page_id = "") {
        global $wpdb, $post;
        // Page ID
        $current_page_id = get_the_ID();
        if ($page_id != "") {
            $current_page_id = $page_id;
        }
        // Check action
        $rs = false;
        $ids = array();
        // Search Cart Page
        $content_cart = '[woocommerce_cart]';
        $cart_found = $wpdb->get_results($wpdb->prepare("SELECT ID FROM " . $wpdb->posts . " WHERE post_type='page' AND post_content LIKE %s;", "%{$content_cart}%"));
        foreach ($cart_found as $cart_found_item) {
            $ids[] = $cart_found_item->ID;
        }
        // Search Checkout Page
        $content_checkout = '[woocommerce_checkout]';
        $checkout_found = $wpdb->get_results($wpdb->prepare("SELECT ID FROM " . $wpdb->posts . " WHERE post_type='page' AND post_content LIKE %s;", "%{$content_checkout}%"));
        foreach ($checkout_found as $checkout_found_item) {
            $ids[] = $checkout_found_item->ID;
        }
        // Search Myaccount Page
        $content_myaccount = '[woocommerce_my_account]';
        $myaccount_found = $wpdb->get_results($wpdb->prepare("SELECT ID FROM " . $wpdb->posts . " WHERE post_type='page' AND post_content LIKE %s;", "%{$content_myaccount}%"));
        foreach ($myaccount_found as $myaccount_found_item) {
            $ids[] = $myaccount_found_item->ID;
        }
        //Check if This Page is Woocommerce return array ID
        if (!empty($ids)) {
            $search = in_array($current_page_id, $ids);
            $rs = $search;
        }
        return $rs;
    }

}

/**
 * Check if Visual Composer used
 * @return boolean
 */
if (!function_exists('is_VC_used')) {

    function is_VC_used($page_id = "") {
        global $wpdb, $post;
        // Page ID
        $current_page_id = get_the_ID();
        if ($page_id != "") {
            $current_page_id = $page_id;
        }
        // Check action
        $output = false;
        $ids = array();
        $content_vc = '[vc_row'; // VC shortcode wrap
        $vc_found = $wpdb->get_results($wpdb->prepare("SELECT ID FROM " . $wpdb->posts . " WHERE post_type='page' AND post_content LIKE %s;", "%{$content_vc}%"));
        foreach ($vc_found as $vc_found_item) {
            $ids[] = $vc_found_item->ID;
        }
        if (!empty($ids)) {
            $search = in_array($current_page_id, $ids);
            $output = $search;
        }
        return $output; // True or False
    }

}


/**
 * Fix W3C Validate Revolution Slider
 */
add_filter('vc_revslider_shortcode','awe_slider_content');
function awe_slider_content($content){
    $text = $style_rev = "";
    $style_array = explode('<style', $content);
    if(is_array($style_array)) foreach ($style_array as $value) {
    	$value = '<style'.$value;
    	$posStart = strrpos($value, '<style');
    	$posEnd = strrpos($value, '</style>');
    	if($posStart >= 0 && $posEnd > 0)
	    {
	        $text = substr($value, $posStart, $posEnd).'</style>';
    		$content = str_replace($text, '', $content);
    		$style = preg_replace('/^\s+|\n|\r|\s+$/m', '', $text);
    		$style = str_replace('scoped', 'type="text/css"', $style);
	        if(!empty($style)) $content .='<script type="text/javascript">
	        (function($) {
    			"use strict";
    			$("head").append('."'".esc_attr($style)."'".');
    		})(jQuery);
    		</script>';
	    }
    }
	return $content;
}


add_filter( 'the_content_more_link', 'modify_read_more_link' );
function modify_read_more_link() {
return  '<div class="more-link"><a href="'.esc_url(get_permalink()).'">'.esc_html__('Read more', 'hillter').'</a></div>';
}

