<?php
add_action( 'header_logo', 'awe_get_logo' );
add_action( 'header_extra_information','awe_header_extra_information' );

// if ( ! function_exists( 'wp_site_icon' ) ) {
	add_action( 'header_favicon', 'awe_get_favicon' );
// }


/**
 * Header Logo
 */
function awe_get_logo() {
	global $hillter_option;
	if ( $hillter_option['logo']['image'] != '' ) :
		?>
        <div class="header_logo">
			<?php // echo ((is_home()) ? '<h1>232323</h1>' : "");
			?>
			<a title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"
			   href="<?php echo esc_url( home_url( '/' ) ); ?>"><img
					src="<?php echo esc_url( $hillter_option['logo']['image'] ); ?>"
					alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"></a>
        </div>

	<?php
	endif;
}

/**
 * Header Favicon
 */
function awe_get_favicon() {
	global $hillter_option;
	if ( $hillter_option['logo']['favicon'] != '' ) :
		echo '<link href="' . $hillter_option['logo']['favicon'] . '" rel="shortcut icon">';
	endif;
}

/**
 * Header Extra Information
 */
function awe_header_extra_information() {
	global $hillter_option;
	$data = isset( $hillter_option['extra'] ) ? $hillter_option['extra'] : '';
	if ( $data == '' ) {
		return;
	}
	$address = isset( $hillter_option['extra']['address'] ) ? $hillter_option['extra']['address'] : __( '225 Beach Street, Australian', 'hillter' );
	$phone = isset( $hillter_option['extra']['phone'] ) ? $hillter_option['extra']['phone'] : __( '1-548-854-8898', 'hillter' );
	if ( $address != '' ) :
	?>
		<span><i class="hillter-icon-location"></i><?php echo esc_html( $address ); ?></span>
	<?php endif; ?>

	<?php if ( $phone != '' ) : ?>
		<span><i class="hillter-icon-phone"></i><?php echo esc_html( $phone ); ?></span>
	<?php
	endif;
}



?>
