<?php
/**
 * Project of Megadrupal.com
 * Author: duongle
 * Date: 6/16/14
 * Time: 9:43 AM
 */
/* * Load more Posts* */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

function awe_load_more_posts() {
	global $loop;
	$paged = $_POST['paged'];
	$args  = array(
		'post_type'      => 'post',
		'posts_per_page' => (int) get_option( 'posts_per_page' ),
		'paged'          => $paged + 1,
	);
	$loop  = new WP_Query( $args );
	if ( $paged <= $loop->max_num_pages ) {
		require_once ( get_template_directory() . '/awe_shortcode/posts-loop.php' );
	} else {
		print ( $loop->max_num_pages );
	}
	die();
}

add_action( 'wp_ajax_load_more_posts', 'awe_load_more_posts' );
add_action( 'wp_ajax_nopriv_load_more_posts', 'awe_load_more_posts' );
/* * End load more* */

if ( ! isset( $content_width ) ) {
	$content_width = 780;
}

global $hillter_option;
$hillter_option = get_option( apply_filters( 'awe_get_option_by_lang', '"' . THEME_OPTIONS_NAME . '"' ) );


function awe_default_layout( $type ) {
	global $hillter_option, $post;
	$custom_sidebar = get_post_meta( $post->ID, 'singular-layout', true );
	if ( $custom_sidebar == $type || ( ( $custom_sidebar == 'default' || $custom_sidebar == '' ) && $hillter_option['layout'] == $type ) ) {
		return true;
	} else {
		return false;
	}
}


/**
 * Get Instance Thumbnail.
 *
 * @param $id
 *
 * @return HTML
 */

function awe_the_thumbnail( $id = '' ) {
	global $post;
	$id   = $post->ID;
	$type = get_post_meta( $id, 'awe-portfolio-thumbnail-type', true );

	if ( $type == 'audio' ) {
		// Audio Thumbnail
		echo ' <!-- audio -->';
		$audio = get_post_meta( get_the_ID(), 'awe-portfolio-thumbnail-audio', true );
		$audio = wp_parse_args( $audio, array( 'url' => '', 'autoplay' => 'false' ) );

		global $is_load_sc;
		if ( ! empty( $audio['url'] ) ) {
			?>
			<div class="entry-media">
				<div class="blog-audio">
					<?php
					if ( preg_match( '/\/sets\//i', $audio['url'] ) || preg_match( '/\/sets\//i', $audio['url'] ) ) {
						$maxheight = '450';
					} else {
						$maxheight = '166';
					}
					?>
					<script>var elwidth = jQuery('.blog-audio').width();</script>
					<iframe onload="this.width=elwidth;" height="<?php echo esc_attr( $maxheight ); ?>"
							src="https://w.soundcloud.com/player/?url=<?php echo esc_url( $audio['url'] ); ?>&amp;auto_play=<?php echo esc_attr( $audio['autoplay'] ); ?>&amp;hide_related=false&amp;show_comments=true&amp;show_user=true&amp;show_reposts=false&amp;visual=true"></iframe>
				</div>
			</div>
			<?php
		}
	} elseif ( $type == 'video' ) {

		// Video Thumbnail
		$v = get_post_meta( $id, 'awe-portfolio-thumbnail-video', true );
		$v = wp_parse_args( $v, array( 'url' => '', 'embed' => '' ) );
		if ( ! empty( $v['embed'] ) ) {
			$video = '';
			// $v1    = (array) json_decode( $v[0] );
			// $url = '';
			// ( $v1['type'] == 'youtube' ? $url = 'https://www.youtube.com/embed/' : $url = 'https://player.vimeo.com/video/' );
			$video .= '<iframe class="embed-responsive-item" src="' . esc_url( $v['embed'] ) . '"></iframe>';

			// if ( ! is_singular() ) {
				$video = sprintf( '<div class="embed-responsive embed-responsive-16by9">%s</div>', $video );
			// }

			$video = sprintf( '<div class="entry-media"><div class="entry-video">%s</div></div>', $video );

			$output = $video;
			print $output;
		}

		/*  } elseif ( $type == 'gallery' ) {

		// Gallery Thumbnail
		$g = get_post_meta( $id, 'gallery', true );
		if ( isset( $g ) && ! empty( $g ) ) :
			echo '<div class="gallery-thumbnail awe-gallery-content-blog">';
			echo '<div class="grid-size"></div>';
			foreach ( $g as $k => $item ) {
				$large = ( $k == 0 ) ? ' large' : '';
				echo '<div class="gallery-item' . $large . '">';
				echo '<figure>';
				echo '<img src="' . $item . '" alt="image">';
				echo '</figure>';
				echo '</div>';
			}
			echo '</div>';
		endif;*/

	} elseif ( $type == 'slider' ) {

		// Slider Thumbnail
		$s = get_post_meta( $id, 'awe-portfolio-thumbnail-slider', true );
		$s = wp_parse_args( $s, array( 'shortcode' => '', 'images' => array() ) );

		if ( ! empty( $s['images'] ) ) :
			$images = '<div class="entry-media"><div class="post-slider owl-single">';
			foreach ( $s['images'] as $i ) {

				$images .= '<img src="' . $i . '" alt="">';
			}
			$images .= '</div></div>';
			print $images;
		endif;

	} else {
		// Feature Thumbnail
		if ( has_post_thumbnail() ) :
			$images = '<div class="entry-media">';
			$images .= '<a href="' . get_the_permalink() . '">';
			$images .= get_the_post_thumbnail();
			$images .= '</a>';
			$images .= '</div>';
			print $images;
		endif;
	}

}

/**
 * Custom Panigation
 *
 * @package WordPress
 * @subpackage hillter
 * @since 1.0
 */
if ( ! function_exists( 'awe_paging_nav' ) ) :

	/**
	 * Display navigation to next/previous set of posts when applicable.
	 *
	 * @since Twenty Fourteen 1.0
	 *
	 * @global WP_Query $wp_query WordPress Query object.
	 * @global WP_Rewrite $wp_rewrite WordPress Rewrite object.
	 */
	function awe_paging_nav( $query = '' ) {
		global $wp_query, $wp_rewrite;
		if ( $query != '' ) {
			$wp_query = $query;
		}

		// Don't print empty markup if there's only one page.
		if ( $wp_query->max_num_pages < 2 ) {
			return;
		}
		$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		$pagenum_link = html_entity_decode( get_pagenum_link() );
		$query_args   = array();
		$url_parts    = explode( '?', $pagenum_link );
		if ( isset( $url_parts[1] ) ) {
			wp_parse_str( $url_parts[1], $query_args );
		}

		$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
		$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

		$format = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
		$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( $wp_rewrite->pagination_base . '/%#%', 'paged' ) : '?paged=%#%';

		// Set up paginated links.
		$links = array(
			'base'      => $pagenum_link,
			'format'    => $format,
			'total'     => $wp_query->max_num_pages,
			'type'      => 'list',
			'current'   => $paged,
			'mid_size'  => 1,
			'add_args'  => array_map( 'urlencode', $query_args ),
			'prev_text' => '<i class="fa fa-arrow-left"></i>',
			'next_text' => '<i class="fa fa-arrow-right"></i>',
		);
		if ( $links ) :
			?>
			<div class="page-navigation">
				<?php echo paginate_links( $links ); ?>
			</div><!-- .pagination -->
			<?php
		endif;
	}

endif;

// Get categories post
function get_category_post() {
	global $post;
	$cats   = get_the_category();
	$output = '<span class="entry-categories">';
	if ( ! empty( $cats ) ) {
		$i = 1;
		foreach ( $cats as $cat ) {
			$sep = ( $i == 1 ) ? '' : ',';
			$output .= esc_html( $sep ) . '<a href="' . get_category_link( $cat->term_id ) . '">' . $cat->name . '</a>';
			$i ++;
		}
	}
	$output .= '</span>';
	print $output;
}

/**
 *  Get sidebar layout option
 * @since Hillter 1.0
 */
function awe_sidebar_layout_option() {
	global $hillter_option;
	$output = array();
	$layout = apply_filters( 'default_layout', 'LM' );
	// Output sidebar setting
	if ( is_page_template( 'page-blog-tpl.php' ) ) {
		$sidebar = in_array( get_post_meta( get_the_ID(), 'awe_sidebar_position', true ), array( 'default', 'left', 'right', 'no' ) ) ? get_post_meta( get_the_ID(), 'awe_sidebar_position', true ) : 'default';
		if ( $sidebar == 'default' ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['on_blog_page'] ) ? $hillter_option['extra']['sidebar']['on_blog_page'] : 'right';
		}
	} elseif ( is_page() ) {
		$sidebar = in_array( get_post_meta( get_the_ID(), 'awe_sidebar_position', true ), array( 'default', 'left', 'right', 'no' ) ) ? get_post_meta( get_the_ID(), 'awe_sidebar_position', true ) : 'default';
		if ( $sidebar == 'default' ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['on_page'] ) ? $hillter_option['extra']['sidebar']['on_page'] : 'right';
		}
	} elseif ( is_single() ) {
		$sidebar = in_array( get_post_meta( get_the_ID(), 'awe_sidebar_position', true ), array( 'default', 'left', 'right', 'no' ) ) ? get_post_meta( get_the_ID(), 'awe_sidebar_position', true ) : 'default';
		if ( $sidebar == 'default' ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['on_single_page'] ) ? $hillter_option['extra']['sidebar']['on_single_page'] : 'right';
		}
	} elseif ( is_category() || is_tag() || is_tax() ) {
		$term_id = get_queried_object()->term_id;
		$sidebar = in_array( AWE_Tax_Meta::get_meta( $term_id, 'layout' ), array( 'default', 'left', 'right', 'no' ) ) ? AWE_Tax_Meta::get_meta( $term_id, 'layout' ) : 'default';
		if ( $sidebar == 'default' ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['on_page_archive'] ) ? $hillter_option['extra']['sidebar']['on_page_archive'] : 'right';
		}
	} elseif ( is_archive() ) {
		$sidebar = isset( $hillter_option['extra']['sidebar']['on_page_archive'] ) ? $hillter_option['extra']['sidebar']['on_page_archive'] : 'right';
	} elseif ( is_home() ) {
		$sidebar = isset( $hillter_option['extra']['sidebar']['on_blog_page'] ) ? $hillter_option['extra']['sidebar']['on_blog_page'] : 'right';
	} else {
		$sidebar = 'right';
	}

	$pull = $push = $grid = '';

	// Sidebar Settings
	if ( $sidebar != 'no' && $sidebar == 'right' ) {
		$grid = '';
		$push = 'col-md-8';
		$pull = 'col-md-4';
	} elseif ( $sidebar != 'no' && $sidebar == 'left' ) {
		$grid = '';
		$push = 'col-md-8 col-md-push-4';
		$pull = 'col-md-4 col-md-pull-8';
	}
	if ( $sidebar == 'no' || $sidebar == '' ) {
		$grid = 'grid_12';
		$push = 'col-md-12';
		$pull = '';
	}
	// Taxonomy Settings
	/*if ( $layout && $layout != '' ) {
		if ( $layout == 'LM' ) {
			$grid = '';
			$push = 'col-md-8 col-md-push-4';
			$pull = 'col-md-4 col-md-pull-8';
		} elseif ( $layout == 'MR' ) {
			$grid = '';
			$push = 'col-md-8';
			$pull = 'col-md-4';
		} else {
			$grid = 'grid_12';
			$push = 'col-md-12';
			$pull = '';
		}
	}*/
//	//Visual Composer Has No Sidebar
//	if ( is_VC_used() == true ) {
//		$grid = 'grid_12';
//		$push = 'col-md-12';
//		$pull = '';
//	}
	// Output
	$output['grid'] = $grid;
	$output['push'] = $push;
	$output['pull'] = $pull;
	$output['sidebar'] = $sidebar;

	return $output;
}


/**
 * Get sidebar option
 */
function awe_sidebar_option() {
	global $hillter_option;
	wp_reset_query();
	$default_sidebar = 'blog-sidebar';

	$sidebar = $default_sidebar;

	if ( is_page() ) {
		$sidebar = get_post_meta( get_the_ID(), 'awe_sidebar_select', true );
		if ( ! $sidebar ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['page'] ) ? $hillter_option['extra']['sidebar']['page'] : $default_sidebar;
		}
	} elseif ( is_single() ) {
		$sidebar = get_post_meta( get_the_ID(), 'awe_sidebar_select', true );
		if ( ! $sidebar ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['blog'] ) ? $hillter_option['extra']['sidebar']['blog'] : $default_sidebar;
		}
	} elseif ( is_category() || is_tag() ) {
		$term_id = get_queried_object()->term_id;
		$sidebar = AWE_Tax_Meta::get_meta( $term_id, 'sidebar_id' );
		if ( ! $sidebar ) {
			$sidebar = isset( $hillter_option['extra']['sidebar']['blog'] ) ? $hillter_option['extra']['sidebar']['blog'] : $default_sidebar;
		}
	}

	return $sidebar;
}


/**
 * Get Coming Soon Option
 *
 * @return boolean
 * @package Hillter
 * @author Kai
 * @since 1.0.0
 */

function awe_coming_soon_option() {
	global $hillter_option;
	if ( isset( $hillter_option['extra']['comingsoon'] ) ) {
		$output = ( $hillter_option['extra']['comingsoon']['enable'] ) ? $hillter_option['extra']['comingsoon']['enable'] : 0;
	} else {
		$output = 0;
	}
	return $output;
}

/**
 * Coming Soon Template
 */

function awe_coming_soon_template() {
	if ( awe_coming_soon_option() == 1 ) {
		get_template_part( 'inc/comming-soon/comming', 'soon' );
		exit();
	}
}


if ( ! function_exists( 'awe_preload' ) ) {
	function awe_preload() {
		global $hillter_option;
		$enable = isset( $hillter_option['extra']['enable_preload'] ) ? ( bool ) $hillter_option['extra']['enable_preload'] : false;
		if ( $enable ) {
			?>
			<!-- PRELOADER-->
			<div id="hillter-preloader">
				<span class="preloader-dot"></span>
			</div>
			<!-- END / PRELOADER-->
			<?php
		}
	}
}

/**
 * New Excerpt More
 *
 * @param $more
 *
 * @return string
 */
function new_excerpt_more( $more ) {
	return '...';
}

add_filter( 'excerpt_more', 'new_excerpt_more' );

/**
 * Comingsoon Background
 *
 * @package Hillter
 * @return string
 */
function awe_comingsoon_bg() {
	global $hillter_option;
	$url        = get_template_directory_uri() . '/assets/images/banner/bg-6.jpg';
	$background = isset( $hillter_option['extra']['comingsoon']['background'] ) ? $hillter_option['extra']['comingsoon']['background'] : '';
	if ( $background != '' ) :
		echo '<style>
		.section-comingsoon {
			background-image: url("' . esc_url( $background ) . '") !important;
		}
	</style>';
	endif;
}

add_action( 'wp_head', 'awe_comingsoon_bg' );


/**
 * Select Post Type Shortcode
 * @author Kai
 */

function awe_select_post_type_shortcode() {

	$post_types = get_post_types( array( 'public' => true ) ); // Get all post type
	$unsets = array( 'attachment','revision','nav_menu_item','page' );
	$post_types = get_taxonomies( array( 'public' => true ) );
	foreach ( $post_types as $k => $v ) {
		$taxonomies[] = get_object_taxonomies( $k, 'names' );
		switch ( $k ) {
			case 'post_tag':
				$k = 'Post Tag';
				break;
			case 'post_format':
				$k = 'Post Format';
				break;

			default:
				# code...
				break;
		}
		$post_type[ucfirst( $k)] = $v ;
	}
		unset( $post_types );
		return $post_type;
}


/**
 * Checking awebooking plugin actived.
 *
 * @return bool
 */
function awe_booking_actived() {
	$output = false;
	if ( class_exists( 'APB_Booking' ) ) {
		$output = true;
	}
	return $output;
}


/**
 * Add class to page use vc.
 *
 * @param  array $classes Array of body classes.
 * @return array
 */
function awe_vc_template_class( $classes ) {
	if ( is_VC_used() == true && ! is_search() ) :
		$classes[] = 'awe-vc-template';
	endif;
	return $classes;
}
add_filter( 'body_class', 'awe_vc_template_class' );


/**
 * Filter content.
 *
 * @param  string $content Post content.
 * @return string
 */
function awe_filter_embed_content( $content ) {
	$new_content = awe_wrap_responsive_embed( $content );
	return $new_content;
}
add_filter( 'the_content', 'awe_filter_embed_content', 999 );


/**
 * Wrap <iframe> with responsive class.
 *
 * @param  string $markup Content.
 * @param  string $w      Width.
 * @param  string $h      Height.
 * @return string
 */
function awe_wrap_responsive_embed( $markup, $w = '', $h = '' ) {
	// To make it wmode = transparent.
	$markup = str_replace( '<iframe ', '<div class="video"><span class="embed-responsive embed-responsive-16by9"><iframe ', $markup );
	$markup = str_replace( '</iframe>', '</iframe></span></div>', $markup );
	$markup = str_replace( '<embed ', '<div class="video"><span class="embed-responsive embed-responsive-16by9"><embed ', $markup );
	$markup = str_replace( '</embed>', '</embed></span></div>', $markup );

	$patterns = array();
	$replacements = array();
	if (!empty( $w ) ) {
		$patterns[] = '/width="([0-9]+)"/';
		$patterns[] = '/width:([0-9]+)/';

		$replacements[] = 'width="' . $w . '"';
		$replacements[] = 'width:' . $w;
	}

	if (!empty( $h ) ) {
		$patterns[] = '/height="([0-9]+)"/';
		$patterns[] = '/height:([0-9]+)/';

		$replacements[] = 'height="' . $h . '"';
		$replacements[] = 'height:' . $h;
	}


	$patterns[] = '/src="http:\/\/www\.youtube\.com\/embed\/[a-zA-Z0-9._-]"/';
	$replacements[] = 'src="http://www.youtube.com/embed/${1}?wmode=transparent"';

	return preg_replace( $patterns, $replacements, $markup );
}


/**
 * Add li to link page link
 *
 * @param  string $link Link text.
 * @param  int    $i    Page number.
 * @return string
 */
function awe_link_pages_link( $link, $i ) {
	global $page;
	if ( $i == $page ) {
		return '<li class="current-page"><a href="#">' . $link . '</a></li>';
	} else {
		return '<li>' . $link . '</li>';
	}
}
add_filter( 'wp_link_pages_link', 'awe_link_pages_link', 10, 2 );


/**
 * Add next/prev to link page link.
 *
 * @param  string $output Output.
 * @return string
 */
function awe_link_pages_wrap( $output ) {
	global $page, $numpages;

	if ( $page > 1 ) {
		$output = '<li class="first">' . _wp_link_page( $page - 1 ) . '<i class="fa fa-arrow-left"></i></a></li>' . $output;
	}

	if ( $page < $numpages ) {
		$output .= '<li class="last">' . _wp_link_page( $page + 1 ) . '<i class="fa fa-arrow-right"></i></a></li>';
	}

	$output = sprintf( '<ul class="page-navigation">%s</ul>', $output );
	return $output;
}
add_filter( 'wp_link_pages', 'awe_link_pages_wrap' );


/**
 * Get header transparent class.
 *
 * @return string
 */
function awe_get_header_transparent_class() {
	$default = 'awe-no-header-transparent';

	if ( is_single() || is_page() ) {
		$id = get_the_ID();
		$value = get_post_meta( $id, 'awe_header_transparent', true );
		if ( 'yes' == $value ) {
			$default = 'awe-header-transparent';
		}
	}

	return $default;
}


/**
 * Print HTML select field from option.
 *
 * @param  array $args Arguments.
 * @return void
 */
function awe_get_option_to_selected( $args = array() ) {
	if ( isset( $args['name'] ) && isset( $args['count_num'] ) ) {

		$html = '<select ';
		if ( ! empty( $args['name'] ) ) {
			$html .= 'name="' . esc_attr( $args['name'] ) . '" ';
		}
		if ( isset( $args['data'] ) ) {
			foreach ( $args['data'] as $attr => $value ) {
				$html .= $attr . '="' . esc_attr( $value ) . '" ';
			}
		}
		$start = isset( $args['start_num'] ) ? $args['start_num'] : 1;

		$html .= '>';

		if ( isset( $args['placeholder'] ) ) {
			$html .= '<option>' . esc_html( $args['placeholder'] ) . '</option>';
		}

		for ( $i = $start; $i <= $args['count_num']; $i++ ) :
			$html .= '<option ';
			if ( isset( $args['select'] ) && $args['select'] == $i ) {
				$html .= 'selected="selected"';
			}
			$html .= ' value="' . esc_attr( $i ) . '">' . $i . '</option>';
		endfor;
		$html .= '</select>';
		print $html;
	}

}



if ( ! function_exists( 'hillter_price' ) ) {
	/**
	 * Return price with currency and position in setting.
	 *
	 * @param  float $price Price.
	 * @return string       Price with currency.
	 */
	function hillter_price( $price ) {
		// If awbooking is active.
		if ( class_exists( 'AWE_function' ) ) {
			return '<span class="amount">' . AWE_function::apb_price( $price ) . '</span>';
		}

		// If woocommerce is active.
		if ( function_exists( 'wc_price' ) ) {
			return wc_price( $price );
		}

		return $price;
	}
}



if ( ! function_exists( 'hillter_get_the_time' ) ) {
	/**
	 * Return datetime with given format and translatable.
	 *
	 * @param  string $format  Datetime format. Default is in general setting.
	 * @param  int    $post_id Post ID. Default is current post.
	 * @return string          Date string.
	 *
	 * @since Hillter 1.4
	 */
	function hillter_get_the_time( $format = null, $post_id = null ) {
		if ( ! $format ) {
			$format = get_option( 'time_format' );
		}
		if ( ! $post_id ) {
			$post_id = get_the_ID();
		}

		return date_i18n( $format, strtotime( get_the_time( 'Y-m-d', $post_id ) ) );
	}
}


/**
 * Filter if sticky enable.
 *
 * @param  bool $enable Enable.
 * @return bool
 */
function hillter_sticky_enable( $enable ) {
	global $hillter_option;
	if ( isset( $hillter_option['extra']['enable_sticky'] ) ) {
		$enable = ( bool ) $hillter_option['extra']['enable_sticky'];
	}
	return $enable;
}
add_filter( 'hillter_sticky_enable', 'hillter_sticky_enable' );


/**
 * Add HTML to open element awebooking.
 *
 * @return void
 */
function hillter_awebooking_render_before() {
	echo '<div class="main-wrapper section-blog">';
	if ( ! is_singular( 'apb_room_type' ) ) {
		return;
	}

	$id = get_the_ID();
	$title = get_post_meta( $id, 'awe-room-type-setting-title', true ) ? get_post_meta( $id, 'awe-room-type-setting-title', true ) : '';
	$subtitle = get_post_meta( $id, 'awe-room-type-setting-subtitle', true ) ? get_post_meta( $id, 'awe-room-type-setting-subtitle', true ) : '';
	$image = get_post_meta( $id, 'awe-room-type-setting-image', true ) ? esc_url( get_post_meta( $id, 'awe-room-type-setting-image', true ) ) : '';

	if ( empty( $title ) && empty( $subtitle ) && empty( $image ) ) {
		return;
	}
	?>
	<!-- SUB BANNER -->
	<section class="section-sub-banner awe-parallax" <?php if ( ! empty( $image ) ) : ?>style="background-image: url(<?php echo esc_url( $image ); ?>);"<?php endif; ?>>
		<div class="awe-overlay"></div>
		<div class="sub-banner">
			<div class="container">
				<div class="text text-center">
					<?php if ( ! empty( $title ) ) : ?>
						<h2><?php echo esc_html( $title ); ?></h2>
					<?php endif; ?>

					<?php if ( ! empty( $subtitle ) ) : ?>
						<p><?php echo esc_html( $subtitle ); ?></p>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</section>
	<!-- END / SUB BANNER -->
	<?php
}
add_action( 'apb_renderBefore', 'hillter_awebooking_render_before', 1 );


/**
 * Add HTML to close element awebooking.
 *
 * @return void
 */
function hillter_awebooking_render_after() {
	echo '</div>';
}
add_action( 'apb_renderAfter', 'hillter_awebooking_render_after', 1 );


/**
 * Convert hex color ro rgba or rgb.
 *
 * @param  string  $color   Color value.
 * @param  boolean $opacity True if want output is rgba.
 * @return string
 */
function hillter_hex2rgba( $color, $opacity = false ) {

	$default = 'rgb(0,0,0)';

	// Return default if no color provided.
	if ( empty( $color ) ) {
		return $default;
	}

	// Sanitize $color if "#" is provided.
	if ( '#' == $color[0] ) {
		$color = substr( $color, 1 );
	}

	// Check if color has 6 or 3 characters and get values.
	if ( strlen( $color ) == 6 ) {
		$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
	} elseif ( strlen( $color ) == 3 ) {
		$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
	} else {
		return $default;
	}

	// Convert hexadec to rgb.
	$rgb = array_map( 'hexdec', $hex );

	// Check if opacity is set (rgba or rgb).
	if ( false !== $opacity ) {
		if ( abs( $opacity ) > 1 ) {
			$opacity = 1.0;
		}
		$output = 'rgba(' . implode( ',', $rgb ) . ',' . $opacity . ')';
	} else {
		$output = 'rgb(' . implode( ',', $rgb ) . ')';
	}

	// Return rgb(a) color string.
	return $output;
}


/**
 * Print header blog section.
 */
function hillter_blog_header() {
	global $hillter_option;

	if ( is_singular( 'post' ) || is_home() ) {
		$awe_show_header = isset( $hillter_option['content']['header_blog'] ) ? (bool) $hillter_option['content']['header_blog'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['header_image'] ) ? esc_url( $hillter_option['content']['header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			$awe_header_title = isset( $hillter_option['content']['header_title'] ) ? esc_html( $hillter_option['content']['header_title'] ) : 'OUR BLOG';
			$awe_header_subtitle = isset( $hillter_option['content']['header_subtitle'] ) ? esc_html( $hillter_option['content']['header_subtitle'] ) : 'Lorem Ipsum is simply dummy text';

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title, $awe_header_subtitle );
		}
	} elseif ( is_singular( 'event' ) || is_post_type_archive( 'event' ) || is_page_template( 'page-event-tpl.php' ) ) {
		$awe_show_header = isset( $hillter_option['content']['header_event'] ) ? (bool) $hillter_option['content']['header_event'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['event_header_image'] ) ? esc_url( $hillter_option['content']['event_header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			$awe_header_title = isset( $hillter_option['content']['event_header_title'] ) ? esc_html( $hillter_option['content']['event_header_title'] ) : '';
			$awe_header_subtitle = isset( $hillter_option['content']['event_header_subtitle'] ) ? esc_html( $hillter_option['content']['event_header_subtitle'] ) : '';

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title, $awe_header_subtitle );
		}
	} elseif ( is_category() ) {
		$awe_show_header = isset( $hillter_option['content']['header_blog'] ) ? (bool) $hillter_option['content']['header_blog'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['header_image'] ) ? esc_url( $hillter_option['content']['header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			$awe_header_title = single_cat_title( '', false );
			$awe_header_subtitle = wp_kses( category_description(), array() );

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title );
		}
	} elseif ( is_tag() ) {
		$awe_show_header = isset( $hillter_option['content']['header_blog'] ) ? (bool) $hillter_option['content']['header_blog'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['header_image'] ) ? esc_url( $hillter_option['content']['header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			$awe_header_title = single_tag_title( '', false );
			$awe_header_subtitle = wp_kses( tag_description(), array() );

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title );
		}
	} elseif ( is_tax( 'event-category' ) || is_tax( 'event-tag' ) ) {
		$awe_show_header = isset( $hillter_option['content']['header_event'] ) ? (bool) $hillter_option['content']['header_event'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['event_header_image'] ) ? esc_url( $hillter_option['content']['event_header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			$awe_header_title = single_term_title( '', false );
			$awe_header_subtitle = wp_kses( term_description(), array() );

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title, $awe_header_subtitle );
		}
	} elseif ( is_archive() ) {
		$awe_show_header = isset( $hillter_option['content']['header_blog'] ) ? (bool) $hillter_option['content']['header_blog'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['header_image'] ) ? esc_url( $hillter_option['content']['header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			if ( is_day() ) :
				$awe_header_title = sprintf( __( 'Daily Archives: %s', 'hillter' ), get_the_date() );
			elseif ( is_month() ) :
				$awe_header_title = sprintf( __( 'Monthly Archives: %s', 'hillter' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'hillter' ) ) );
			elseif ( is_year() ) :
				$awe_header_title = sprintf( __( 'Yearly Archives: %s', 'hillter' ), get_the_date( _x( 'Y', 'yearly archives date format', 'hillter' ) ) );
			else :
				$awe_header_title = __( 'Archives', 'hillter' );
			endif;

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title );
		}
	} elseif ( is_search() ) {
		$awe_show_header = isset( $hillter_option['content']['header_event'] ) ? (bool) $hillter_option['content']['header_event'] : 1;
		if ( $awe_show_header ) {
			$awe_header_image = isset( $hillter_option['content']['event_header_image'] ) ? esc_url( $hillter_option['content']['event_header_image'] ) : get_template_directory_uri() . '/assets/images/default/bg-header-blog.jpg';
			$awe_header_title = sprintf( esc_html__( 'Search results for: %s', 'hillter' ), get_search_query() );

			hillter_print_blog_header_section( $awe_header_image, $awe_header_title );
		}
	}
}
add_action( 'hillter_blog_header', 'hillter_blog_header' );


/**
 * Print header image section.
 *
 * @param  string $bg       Image background url.
 * @param  string $title    Title.
 * @param  string $subtitle Subtitle.
 */
function hillter_print_blog_header_section( $bg = '', $title = '', $subtitle = '' ) {
	?>
	<div class="section-sub-banner awe-parallax"<?php echo ! empty( $bg ) ? ' style="background-image:url(' . esc_url( $bg ) . ')"' : ''; ?>>
		<div class="awe-overlay"></div>
		<div class="sub-banner">
			<div class="text text-center">
				<?php if ( $title ) : ?>
					<h2><?php echo esc_html( $title ); ?></h2>
				<?php endif; ?>
				<?php if ( $subtitle ) : ?>
					<p><?php echo esc_html( $subtitle ); ?></p>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<?php
}

function apbtest_add_currency( $currencies ) {
$currencies['GHS'] = 'Ghana Cedi';
return $currencies;
}
add_filter( 'apb_currencies', 'apbtest_add_currency' );

function apbtest_add_currency_symbol( $symbol, $currency ) {
if ( 'GHS' == $currency ) {
$symbol = 'GH₵';
}
return $symbol;
}
add_filter( 'apb_get_currency_symbol', 'apbtest_add_currency_symbol', 10, 2 );
