<?php
/**
 * Font style setting
 *
 * @package Hillter
 */

/**
 * Add font style css.
 *
 * @param  string $css Custom CSS.
 * @return string
 */
function hillter_font_style_css( $css ) {
	global $hillter_option;

	$typo_setting = $hillter_option['typography'];

	foreach ( $typo_setting as $element => $setting ) {
		$css_content = hillter_font_style_css_content( $setting );
		if ( empty( $css_content ) ) {
			continue;
		}

		switch ( $element ) {
			case 'h1':
			case 'h2':
			case 'h3':
			case 'h4':
			case 'h5':
			case 'h6':
			case 'body':
				$css .= hillter_font_style_css_structure( $element, $css_content );
				break;
		}
	}

	return $css;
}
add_filter( 'hillter_custom_css', 'hillter_font_style_css' );


/**
 * Get css content from font setting.
 *
 * @param  array $setting Font setting.
 * @return string
 */
function hillter_font_style_css_content( $setting ) {
	$css = '';

	if ( ! empty( $setting['font'] ) ) {
		$css .= sprintf( "\tfont-family: %s !important;\n", "'" . $setting['font'] . "'" );
	}

	if ( ! empty( $setting['size'] ) ) {
		$css .= sprintf( "\tfont-size: %s !important;\n", $setting['size'] . 'px' );
	}

	if ( ! empty( $setting['weight'] ) ) {
		$css .= sprintf( "\tfont-weight: %s !important;\n", $setting['weight'] );
	}

	if ( ! empty( $setting['lineheight'] ) ) {
		$css .= sprintf( "\tline-height: %s !important;\n", $setting['lineheight'] . 'px' );
	}

	if ( ! empty( $setting['color'] ) ) {
		$css .= sprintf( "\tcolor: %s !important;\n", $setting['color'] );
	}

	return $css;
}


/**
 * Get css structure.
 *
 * @param  string $selector Selector.
 * @param  string $content  CSS Content.
 * @return string
 */
function hillter_font_style_css_structure( $selector, $content ) {
	return sprintf( "%s {\n%s}\n", $selector, $content );
}
