<?php
if (defined('ICL_SITEPRESS_VERSION') && defined('ICL_LANGUAGE_CODE')) {

    class aweConfigWpml
    {

        private $wpml_lang;
        private $default_lang;
        private $default_option;

        public function __construct()
        {
            global $sitepress;
            $this->default_lang = $sitepress->get_default_language();
            $this->language_negotiation_type = $sitepress->get_setting('language_negotiation_type');
            $this->wpml_lang = icl_get_languages('skip_missing=0&orderby=custom');
            add_action('awe_copy_default_theme_option', array($this, 'awe_copy_default_theme_option'), 10, 1);
            add_action('awe_lang_bar', array($this, 'awe_lang_bar'));
            add_action('awe_lang_bar_res', array($this, 'awe_lang_bar_res'));
            add_filter('awe_get_option_by_lang', array($this, 'awe_get_option_by_lang'), 10, 1);
            add_action('awe_search_with_wpml', array($this, 'awe_search_with_wpml'));

            do_action('awe_copy_default_theme_option', THEME_OPTIONS_NAME);

        }


        public function awe_search_with_wpml()
        {
            if ($this->language_negotiation_type == 3) {
                echo '<input type="hidden" name="lang" value="' . ICL_LANGUAGE_CODE . '">';
            }
        }

        function awe_copy_default_theme_option($option_name)
        {
            $options = get_option($option_name);

            if (is_array($this->wpml_lang) && !empty($this->wpml_lang)) {
                foreach ($this->wpml_lang as $lang) {
                    $lang_option = get_option($option_name . '_' . $lang['language_code']);
                    if ($lang_option == '') {
                        update_option($option_name . '_' . $lang['language_code'], $options);
                    }
                }
            }

        }

        function awe_lang_bar()
        {
            if (is_array($this->wpml_lang) && !empty($this->wpml_lang)) {
                $output = '<ul class="language-bar">';
                foreach ($this->wpml_lang as $lang) {
                    $output .= '<li><a href="' . esc_url($lang['url']) . '"><img src="' . esc_url($lang['country_flag_url']) . '" alt="' . esc_attr($lang['native_name']) . '"></a></li>';
                }
                $output .= '</ul>';
                print ($output);
            }
        }

        function awe_lang_bar_res()
        {
            if (is_array($this->wpml_lang) && !empty($this->wpml_lang)) {
                $output = '<ul>';
                $output .= '<li>';
                $output .= '<div class="language-bar2">';
                foreach ($this->wpml_lang as $lang) {
                    $output .= '<span><a href="' . esc_url($lang['url']) . '"><img src="' . esc_url($lang['country_flag_url']) . '" alt="' . esc_attr($lang['native_name']) . '"></a></span>';
                }
                $output .= '</div>';
                $output .= '</li>';
                $output .= '</ul>';
                print ($output);
            }
        }

        function awe_get_option_by_lang($option)
        {
            return $option_key = $option . '_' . ICL_LANGUAGE_CODE;
        }

    }

    new aweConfigWpml();

}// end if wpml is active

?>