<?php
/**
 * Created by PhpStorm.
 * User: Kai
 * Date: 7/9/2015
 * Time: 10:22 AM
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'Hillter_Room_Type_Meta_Box' ) ) {

	class Hillter_Room_Type_Meta_Box {

		/**
		 * Setup data for room type.
		 */
		public function __construct() {
			add_action( 'add_meta_boxes', array( $this, 'awe_setup_room_custom_metabox' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'room_custom_feature_image' ), 1 );
			add_action( 'save_post', array( $this, 'hillter_room_save_postmeta' ) );
		}

		public function awe_setup_room_custom_metabox( $post_type ) {
			$screens = array( 'apb_room_type' );
			// Setup Second Feature Image Meta box
			foreach ( $screens as $screen ) {
				add_meta_box(
					'hillter_room_feature_image_second',
					__( 'Feature Image Small', 'hillter' ),
					array( $this, 'hillter_room_feature_image_second' ),
					$screen,
					'side',
					'low'
				);
			}
		}

		function room_custom_feature_image( $hook ) {
			wp_enqueue_script( 'room_custom_feature_image', get_template_directory_uri() . '/assets/js/js_add_new_feature_image.js' );
		}


		/**
		 * Feature Image Small callback
		 *
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0         *
		 */
		public function hillter_room_feature_image_second() {
			global $post;
			// Add an nonce field so we can check for it later.
			wp_nonce_field( 'room_box', 'room_box_nonce' );
			// Use get_post_meta to retrieve an existing value from the database.
			$value = get_post_meta( $post->ID, '_feature_image_second', true );

			?>
			<p>
				<?php if ( $value ) {
					$add    = ' style="display:none"';
					$remove = '';
					$second = wp_get_attachment_image_src( $value, 'medium' );
					$view   = '<span class="preview-image"><img style="width:100%" alt="image-second" class="attachment-second" src="' . $second[0] . '"></span>';
				} else {
					$add    = '';
					$remove = ' style="display:none"';
					$view   = '<span class="preview-image"></span>';
				}
				print ( $view );
				echo '<a' . $remove . ' title="Remove featured image" class="remove-post-thumbnail-second" href="#" id="remove-post-thumbnail-second">Remove
                    featured image</a>';
				echo '<a' . $add . ' title="Set featured image" class="set-post-thumbnail-second" href="#" id="set-post-thumbnail-second">Set
                    featured image</a>';
				?>
				<input type="hidden" class="post-thumbnail-second-value" name="feature_image_second" value="<?php echo esc_attr( $value ); ?>">
			</p>
			<?php
		}

		public function hillter_room_save_postmeta( $post_id ) {
			/*
			 * We need to verify this came from the our screen and with proper authorization,
			 * because save_post can be triggered at other times.
			 */

			// Check if our nonce is set.
			if ( ! isset( $_POST['room_box_nonce'] ) ) {
				return $post_id;
			}

			$nonce = $_POST['room_box_nonce'];

			// Verify that the nonce is valid.
			if ( ! wp_verify_nonce( $nonce, 'room_box' ) ) {
				return $post_id;
			}

			// If this is an autosave, our form has not been submitted,
			//     so we don't want to do anything.
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return $post_id;
			}

			// Check the user's permissions.
			if ( 'page' == $_POST['post_type'] ) {

				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return $post_id;
				}
			} else {

				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return $post_id;
				}
			}

			/* OK, its safe for us to save the data now. */

			// Sanitize the user input.
			$mydata['feature_image_second'] = sanitize_text_field( $_POST['feature_image_second'] );
			// Update the meta field.
			update_post_meta( $post_id, '_feature_image_second', $mydata['feature_image_second'] );
		}

	}

	new Hillter_Room_Type_Meta_Box();
}
