<?php


/**
 * Enable CUSTOM "REPLY" COMMENT FORM so we can style it
 * @package Wordpress
 * @subpackage Hillter
 * @author Awethemes
 */

function awe_wp_comments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract( $args, EXTR_SKIP );

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}

    // Avatar Size
    $args['avatar_size'] = 80;
	?>
    <<?php echo esc_attr( $tag ) ?> <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ) ?> id="comment-<?php comment_ID() ?>">
	    <?php if ( 'div' != $args['style'] ) : ?>
	    	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	    <?php endif; ?>

	    	<?php
	    	if ( $args['avatar_size'] != 0 ) {
	    		echo '<a class="comment-avatar">';
	    			echo get_avatar( $comment, $args['avatar_size'] );
	    		echo '</a>';
	    	}
	    	?>

            <h4 class="comment-subject"><?php echo get_comment_author_link(); ?></h4>
            <?php comment_text(); ?>

            <?php if ( $comment->comment_approved == '0' ) : ?>
			    <em class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'hillter' ) ?></em>
			    <br />
			<?php endif; ?>

            <span class="comment-meta">
                <?php printf( __( '%1$s %2$s', 'hillter' ), get_comment_time(), get_comment_date() ) ?>
            </span>

            <div class="action">
                <?php if ( current_user_can( 'edit_comment', $comment->comment_ID ) ) { ?>
			    	<?php edit_comment_link( __( 'Edit', 'hillter' ), '  ', '' ); ?>
			    <?php } ?>
			    	<?php comment_reply_link( array_merge( $args, array( 'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ) ?>
            </div>

	    <?php if ( 'div' != $args['style'] ) : ?>
		    </div>
	    <?php endif; ?>

	<?php
}

		// Display trackbacks/pings callback function
function awe_list_pings($comment, $args, $depth) {

	$GLOBALS['comment'] = $comment;
	?>
	<li id="comment-<?php comment_ID(); ?>"><i class="icon icon-share-alt"></i>&nbsp;<?php comment_author_link(); ?>
<?php
}

function awe_comment_form($args = array(), $post_id = null) {

	if ( null === $post_id ) {
		$post_id = get_the_ID(); }

	$commenter = wp_get_current_commenter();
	$user = wp_get_current_user();
	$user_identity = $user->exists() ? $user->display_name : '';

	$args = wp_parse_args( $args );
	if ( ! isset( $args['format'] ) ) {
		$args['format'] = current_theme_supports( 'html5', 'comment-form' ) ? 'html5' : 'xhtml'; }

	$req = get_option( 'require_name_email' );
	$aria_req = ($req ? " aria-required='true'" : '');
	$html5 = 'html5' === $args['format'];
	$fields = array(
	'author' => '<p class="comment-form-author">' . '<label for="author">' . __( 'Name', 'hillter' ) . ($req ? ' <span class="required">*</span>' : '') . '</label> ' .
	'<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></p>',
	'email' => '<p class="comment-form-email"><label for="email">' . __( 'Email', 'hillter' ) . ($req ? ' <span class="required">*</span>' : '') . '</label> ' .
	'<input id="email" name="email" ' . ($html5 ? 'type="email"' : 'type="text"') . ' value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30" aria-describedby="email-notes"' . $aria_req . ' /></p>',
	'url' => '<p class="comment-form-url"><label for="url">' . __( 'Website', 'hillter' ) . '</label> ' .
	'<input id="url" name="url" ' . ($html5 ? 'type="url"' : 'type="text"') . ' value="' . esc_attr( $commenter['comment_author_url'] ) . '" size="30" /></p>',
	);

	$required_text = sprintf( ' ' . __( 'Required fields are marked %s', 'hillter' ), '<span class="required">*</span>' );

	/**
	 * Filter the default comment form fields.
	 *
	 * @since 3.0.0
	 *
	 * @param array $fields The default comment fields.
	 */
	$fields = apply_filters( 'comment_form_default_fields', $fields );
	$defaults = array(
	'fields' => $fields,
	'comment_field' => '<p class="comment-form-comment"><label for="comment">' . __( 'Comment', 'hillter' ) . '</label> <textarea id="comment" name="comment" cols="45" rows="8" aria-describedby="form-allowed-tags" aria-required="true"></textarea></p>',
	/** This filter is documented in wp-includes/link-template.php */
	'must_log_in' => '<p class="must-log-in">' . sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'hillter' ), wp_login_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
	/** This filter is documented in wp-includes/link-template.php */
	'logged_in_as' => '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'hillter' ), get_edit_user_link(), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink( $post_id ) ) ) ) . '</p>',
	'comment_notes_before' => '<p class="comment-notes"><span id="email-notes">' . __( 'Your email address will not be published.', 'hillter' ) . '</span>' . ($req ? $required_text : '') . '</p>',
	'comment_notes_after' => '<p class="form-allowed-tags" id="form-allowed-tags">' . sprintf( __( 'You may use these <abbr title="HyperText Markup Language">HTML</abbr> tags and attributes: %s', 'hillter' ), ' <code>' . allowed_tags() . '</code>' ) . '</p>',
	'id_form' => 'commentform',
	'id_submit' => 'submit',
	'class_submit' => 'submit',
	'name_submit' => 'submit',
	'title_reply' => __( 'Leave a Reply', 'hillter' ),
	'title_reply_to' => __( 'Leave a Reply to %s', 'hillter' ),
	'cancel_reply_link' => __( 'Cancel reply', 'hillter' ),
	'label_submit' => __( 'Post Comment', 'hillter' ),
	'format' => 'xhtml',
	);

	/**
	 * Filter the comment form default arguments.
	 *
	 * Use 'comment_form_default_fields' to filter the comment fields.
	 *
	 * @since 3.0.0
	 *
	 * @param array $defaults The default comment form arguments.
	 */
	$args = wp_parse_args( $args, apply_filters( 'comment_form_defaults', $defaults ) );

	?>
	<?php if ( comments_open( $post_id ) ) : ?>
    <?php
	/**
	 * Fires before the comment form.
	 *
	 * @since 3.0.0
	 */
	do_action( 'comment_form_before' );
	?>
    <div id="respond" class="comment-respond">
        <h3 id="reply-title"
            class="comment-reply-title"><?php comment_form_title( $args['title_reply'], $args['title_reply_to'] ); ?>
            <small><?php cancel_comment_reply_link( $args['cancel_reply_link'] ); ?></small>
        </h3>
        <?php if ( get_option( 'comment_registration' ) && ! is_user_logged_in() ) : ?>
            <?php echo wp_unslash( $args['must_log_in'] ); ?>
            <?php
			/**
			 * Fires after the HTML-formatted 'must log in after' message in the comment form.
			 *
			 * @since 3.0.0
			 */
			do_action( 'comment_form_must_log_in_after' );
			?>
        <?php else : ?>
            <form action="<?php echo site_url( '/wp-comments-post.php' ); ?>" method="post"
                  id="<?php echo esc_attr( $args['id_form'] ); ?>"
                  class="comment-form"<?php echo($html5 ? ' novalidate' : ''); ?>>
                <?php
				/**
				 * Fires at the top of the comment form, inside the form tag.
				 *
				 * @since 3.0.0
				 */
				do_action( 'comment_form_top' );
				?>
                <div class="row">
                    <?php if ( is_user_logged_in() ) : ?>
                        <?php
						/**
						 * Filter the 'logged in' message for the comment form for display.
						 *
						 * @since 3.0.0
						 *
						 * @param string $args_logged_in The logged-in-as HTML-formatted message.
						 * @param array $commenter An array containing the comment author's
						 *                               username, email, and URL.
						 * @param string $user_identity If the commenter is a registered user,
						 *                               the display name, blank otherwise.
						 */
						echo apply_filters( 'comment_form_logged_in', $args['logged_in_as'], $commenter, $user_identity );
						?>
                        <?php
						/**
						 * Fires after the is_user_logged_in() check in the comment form.
						 *
						 * @since 3.0.0
						 *
						 * @param array $commenter An array containing the comment author's
						 *                              username, email, and URL.
						 * @param string $user_identity If the commenter is a registered user,
						 *                              the display name, blank otherwise.
						 */
						do_action( 'comment_form_logged_in_after', $commenter, $user_identity );
					endif; ?>

                    <?php if ( ! is_user_logged_in() ) : ?>
                        <?php echo wp_unslash( $args['comment_notes_before'] ); ?>
                        <?php
						/**
						 * Fires before the comment fields in the comment form.
						 *
						 * @since 3.0.0
						 */
						do_action( 'comment_form_before_fields' );
						foreach ( (array) $args['fields'] as $name => $field ) {
							/**
							 * Filter a comment form field for display.
							 *
							 * The dynamic portion of the filter hook, `$name`, refers to the name
							 * of the comment form field. Such as 'author', 'email', or 'url'.
							 *
							 * @since 3.0.0
							 *
							 * @param string $field The HTML-formatted output of the comment form field.
							 */
							echo apply_filters( "comment_form_field_{$name}", $field ) . "\n";
						}
						/**
						 * Fires after the comment fields in the comment form.
						 *
						 * @since 3.0.0
						 */
						do_action( 'comment_form_after_fields' );
						?>
                    <?php endif; ?>
                    <?php
					/**
					 * Filter the content of the comment textarea field for display.
					 *
					 * @since 3.0.0
					 *
					 * @param string $args_comment_field The content of the comment textarea field.
					 */
					echo apply_filters( 'comment_form_field_comment', $args['comment_field'] );
					?>
                    <?php echo wp_unslash( $args['comment_notes_after'] ); ?>
                    <div class="col-md-4">
                        <div class="form-actions">
                            <input name="<?php echo esc_attr( $args['name_submit'] ); ?>" type="submit"
                                   id="<?php echo esc_attr( $args['id_submit'] ); ?>"
                                   class="<?php echo esc_attr( $args['class_submit'] ); ?>"
                                   value="<?php echo esc_attr( $args['label_submit'] ); ?>"/>
                            <?php comment_id_fields( $post_id ); ?>
                        </div>
                    </div>
                    <?php
					/**
					 * Fires at the bottom of the comment form, inside the closing </form> tag.
					 *
					 * @since 1.5.0
					 *
					 * @param int $post_id The post ID.
					 */
					// do_action('comment_form', $post_id);
					?>
                </div>
            </form>
        <?php endif; ?>
    </div><!-- #respond -->
    <?php
	/**
	 * Fires after the comment form.
	 *
	 * @since 3.0.0
	 */
	do_action( 'comment_form_after' );
else :
	/**
	 * Fires after the comment form if comments are closed.
	 *
	 * @since 3.0.0
	 */
	do_action( 'comment_form_comments_closed' );
endif;
}
