<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 * @var $width
 * @var $css
 * @var $offset
 * @var $content - shortcode content
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Column
 */
$output = $font_color = $el_class = $width = $offset = $bg_color = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( shortcode_atts( array(
	'font_color' => '',
	'el_class'   => '',
	'width'      => '1/1',
	'css'        => '',
	'offset'     => '',
	'bg_overlay' => '',
	'position' => 'Left'
), $atts ) );

$width    = wpb_translateColumnWidthToSpan( $width );
$width    = vc_column_offset_class_merge( $offset, $width );

$css_classes = array(
	$this->getExtraClass( $el_class ),
	'wpb_column',
	'vc_column_container',
	$width,
);

if ( $bg_overlay != '' ) {
	$css_class[] = 'awe-has-overlay';
}

if (vc_shortcode_custom_css_has_property( $css, array('border', 'background') )) {
	$css_classes[] = 'vc_col-has-fill';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( $css_classes ) ), $this->settings['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';

$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
$output .= '<div class="vc_column-inner ' . esc_attr( trim( vc_shortcode_custom_css_class( $css ) ) ) . '">';
$output .= '<div class="wpb_wrapper">';
$output .= wpb_js_remove_wpautop( $content );
$output .= '</div>';

if ( '' != $bg_overlay ) :
	$class_position = ( $position == 'Left' ) ? 'extend-left' : 'extend-right';
	$output .= '<div class="wpb_column-overlay ' . esc_attr( $class_position ) . '" style="background-color:' . $bg_overlay . '"></div>';
endif;

$output .= '</div>';
$output .= '</div>';

print $output;
