<?php
/**
 * Awe testimonial 2 shortcode
 *
 * @package Hillter
 */

/**
 * Class awe_testimonial2
 */
class Awe_Testimonial2 extends Awe_shortcode {

	/**
	 * Shortcode name.
	 *
	 * @var string
	 */
	protected $shortcode_name = 'awe_testimonial2';


	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->custom_shortcode( $this->shortcode_name, array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}


	/**
	 * Map shortcode.
	 */
	public function awe_vc_shortcode() {
		vc_map( array(
			'name' => __( 'Awe Testimonial 2', 'hillter' ),
			'base' => $this->shortcode_name,
			'category' => __( 'Awe shortcode', 'hillter' ),
			'icon' => $this->icon( 'shortcode.png' ),
			'class' => 'awe_shortcode',
			'description' => __( 'Display testimonials', 'hillter' ),
			'params' => array(
				array(
					'type' => 'param_group',
					'heading' => __( 'Testimonials', 'hillter' ),
					'param_name' => 'list',
					'value' => '',
					'params' => array(
						array(
							'type'       => 'attach_image',
							'heading'    => __( 'Image', 'hillter' ),
							'param_name' => 'image',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Subject', 'hillter' ),
							'param_name' => 'subject',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Customer name', 'hillter' ),
							'param_name' => 'customer_name',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Location', 'hillter' ),
							'param_name' => 'location',
						),
						array(
							'type'       => 'textarea',
							'heading'    => __( 'Feedback content', 'hillter' ),
							'param_name' => 'content',
						),
					),
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Style', 'hillter' ),
					'param_name' => 'style',
					'value' => array(
						__( 'Carousel', 'hillter' )                      => 'carousel',
						__( 'Grid layout no avatar', 'hillter' )         => 'grid-1',
						__( 'Grid layout with small avatar', 'hillter' ) => 'grid-2',
					),
					'group' => __( 'Display setting', 'hillter' ),
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Avatar Position', 'hillter' ),
					'param_name' => 'avatar_position',
					'value' => array(
						__( 'Avatar on the top of description', 'hillter' )     => 'top',
						__( 'Avatar align inline with description', 'hillter' ) => 'inline',
					),
					'group' => __( 'Display setting', 'hillter' ),
					'dependency' => array(
						'element' => 'style',
						'value' => array( 'carousel' ),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => __( 'Extra class name', 'hillter' ),
					'param_name' => 'el_class',
					'value' => '',
					'group' => __( 'Display setting', 'hillter' ),
					'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'hillter' ),
				),
			),
		) );
	}


	/**
	 * Render shortcode.
	 *
	 * @param  array  $atts    Shortcode attributes.
	 * @param  string $content Content.
	 * @return string
	 */
	public function awe_render_html( $atts, $content = '' ) {
		$atts = shortcode_atts( array(
			'list' => '',
			'style' => 'carousel',
			'avatar_position' => 'top',
			'el_class' => '',
		), $atts );

		$list = vc_param_group_parse_atts( $atts['list'] );

		if ( empty( $list ) ) {
			return;
		}

		ob_start();

		if ( 'carousel' == $atts['style'] ) {
			?>

			<div class="guestbook-content owl-single">

				<?php
				foreach ( $list as $item ) {
					if ( empty( $item ) ) {
						continue;
					}

					$image = isset( $item['image'] ) ? wp_get_attachment_image_src( $item['image'], apply_filters( 'hillter_testimonial_slider_image_size', 'thumbnail' ) ) : '';
					$customer_name = isset( $item['customer_name'] ) ? $item['customer_name'] : '';
					$location = isset( $item['location'] ) ? $item['location'] : '';
					$content = isset( $item['content'] ) ? $item['content'] : '';
					$meta = ! empty( $customer_name ) ? '<span><strong>' . $customer_name . '</strong> ' . $location . '</span>' : '';
					$slider_class = ( 'inline' == $atts['avatar_position'] ) ? 'guestbook-item' : 'guestbook-item_1';
					?>

					<!-- ITEM -->
					<div class="<?php echo esc_attr( $slider_class ); ?>">
						<?php if ( $image ) : ?>
							<div class="img">
								<img src="<?php echo esc_html( $image[0] ); ?>" alt="<?php printf( esc_attr__( '%s\'s avatar', 'hillter' ), esc_attr( $customer_name ) ); ?>">
								<?php echo wp_kses_post( ( 'top' == $atts['avatar_position'] ) ? $meta : '' ); ?>
							</div>
						<?php endif; ?>

						<div class="text">
							<?php if ( ! empty( $content ) ) : ?>
								<p><?php echo esc_html( $content ); ?></p>
							<?php endif; ?>

							<?php echo wp_kses_post( ( 'inline' == $atts['avatar_position'] ) ? $meta : '' ); ?>
						</div>
					</div>
					<!-- ITEM -->

					<?php
				}
				?>

			</div>

			<?php
		} else {
			?>

			<div class="guest-book_content">
				<div class="row">
					<div class="guest-book_mansory">

						<?php
						foreach ( $list as $item ) {
							$item_class = ( 'grid-2' == $atts['style'] ) ? ' guest-book_item-2' : '';
							$image = isset( $item['image'] ) ? wp_get_attachment_image_src( $item['image'], apply_filters( 'hillter_testimonial_slider_image_size', 'thumbnail' ) ) : '';
							$subject = isset( $item['subject'] ) ? $item['subject'] : '';
							$customer_name = isset( $item['customer_name'] ) ? $item['customer_name'] : '';
							$location = isset( $item['location'] ) ? $item['location'] : '';
							$content = isset( $item['content'] ) ? $item['content'] : '';
							$meta = ! empty( $customer_name ) ? '<span><strong>' . $customer_name . '</strong> ' . $location . '</span>' : '';
							?>

							<!-- ITEM -->
							<div class="item-masonry col-xs-6 col-md-4">
								<div class="guest-book_item<?php echo esc_attr( $item_class ); ?>">
									<span class="icon hillter-icon-quote-left"></span>
									<?php if ( $subject ) : ?>
										<h2><?php echo esc_html( $subject ); ?></h2>
									<?php endif; ?>

									<?php if ( $image && 'grid-2' == $atts['style'] ) : ?>
										<div class="avatar">
											<img src="<?php echo esc_html( $image[0] ); ?>" alt="<?php printf( esc_attr__( '%s\'s avatar', 'hillter' ), esc_attr( $customer_name ) ); ?>">
										</div>
									<?php endif; ?>

									<?php if ( ! empty( $content ) ) : ?>
										<p><?php echo esc_html( $content ); ?></p>
									<?php endif; ?>

									<?php if ( $customer_name ) : ?>
										<span><strong><?php echo esc_html( $customer_name ); ?></strong> - <?php echo esc_html( $location ); ?></span>
									<?php endif; ?>
								</div>
							</div>
							<!-- END / ITEM -->

							<?php
						}
						?>

					</div>
				</div>
			</div>

			<?php
		}

		$output = ob_get_clean();

		// Return output.
		return $output;
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_awe_testimonial2 extends WPBakeryShortCode {

	}
}
