<?php

class awe_testimonial extends Awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_testimonial', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		vc_map( array(
			'name' => __( 'Awe Testimonial', 'hillter' ),
			'base' => 'awe_testimonial',
			'category' => __( 'Awe shortcode', 'hillter' ),
			'icon' => $this->icon( 'shortcode.png' ),
			'class' => 'awe_shortcode',
			'admin_enqueue_css' => get_template_directory_uri() . '/awe_shortcode/assets/css/awe_style.css',
			'front_enqueue_css' => get_template_directory_uri() . '/awe_shortcode/assets/css/awe_style.css',
			'description' => __( 'Display testimonial of ccustomer', 'hillter' ),
			'params' => array(
				array(
					'type' => 'param_testimonial',
					'heading' => __( '', 'hillter' ),
					'class' => 'Awe_meta_id',
					'holder' => 'div',
					'param_name' => 'list',
					'value' => '',
					'group' => 'Testimonial',
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Display type', 'hillter' ),
					'param_name' => 'display_type_new',
					'value' => array(
						'this is showed up as carosel carousel' => 'Slider',
						'this is showed up grid layout no avatar' => 'Grid 1',
						'this is showed up grid layout come with small avatar' => 'Grid 2',
					),
					'group' => 'Display setting',
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Avatar Position', 'hillter' ),
					'param_name' => 'header_position',
					'value' => array( 'Avatar on the top of description','Avatar align inline with description' ),
					'group' => 'Display setting',
					'dependency' => array(
						'element' => 'display_type_new',
						'value' => array( 'Slider' ),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => __( 'Extra class name', 'hillter' ),
					'param_name' => 'el_class',
					'value' => '',
					'group' => 'Display setting',
					'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'hillter' ),
				),
			),
			'deprecated' => '1.10',
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array(
			'list' => '',
			'display_type_new' => 'Slider',
			'header_position' => 'Top',
			'el_class' => '',
		), $atts ) );

		global $wpdb;

		$result = $wpdb->get_var( $wpdb->prepare( "SELECT `meta_value` FROM $wpdb->postmeta WHERE meta_id = %d", absint( $list ) ) );

		parse_str( trim( $result ), $arr );


		ob_start();
		if ( count( $arr ) > 0 ) {
			if ( 'Slider' == $display_type_new ) {
				// Display type as slider.
				echo '<div class="guestbook-content owl-single">';
				foreach ( $arr as $item ) {
					$image = isset( $item['image'] ) ? wp_get_attachment_image_src( $item['image'], apply_filters( 'hillter_testimonial_slider_image_size', 'thumbnail' ) ) : '';
					$meta = '<span><strong>' . $item['customer'] . '</strong> ' . $item['position'] . '</span>';
					$slider_class = ( 'Top' == $header_position ) ? 'guestbook-item_1' : 'guestbook-item';
					?>
						<!-- ITEM -->
						<div class="<?php echo esc_attr( $slider_class ); ?>">
							<?php if ( $image ) : ?>
								<div class="img">
									<img src="<?php echo esc_html( $image[0] ); ?>" alt="<?php printf( esc_html__( '%s\'s avatar', 'hillter' ), esc_html( $item['customer'] ) ); ?>">
									<?php echo ( 'Top' == $header_position ) ? $meta : ''; ?>
								</div>
							<?php endif; ?>
							<div class="text">
									<p><?php echo esc_html( $item['content'] ); ?></p>
									<?php echo ( 'Bottom' == $header_position ) ? $meta : ''; ?>
							</div>
						</div>
						<!-- ITEM -->
					<?php
				}
				echo '</div>';
			} else {
				?>
				 <!-- GUEST BOOK MASONRY -->
					<div class="guest-book_content">

						<div class="row">
							<div class="guest-book_mansory">
								<?php foreach ( $arr as $item ) {
									$item_class = ( 'Grid 2' == $display_type_new ) ? ' guest-book_item-2' : '';
									$image = isset( $item['image'] ) ? wp_get_attachment_image_src( $item['image'], apply_filters( 'hillter_testimonial_grid_image_size', 'thumbnail' ) ) : '';
									?>
								<!-- ITEM -->
								<div class="item-masonry col-xs-6 col-md-4">
									<div class="guest-book_item<?php echo esc_attr( $item_class ); ?>">
										<span class="icon hillter-icon-quote-left"></span>
										<?php if ( $item['subject'] ) : ?>
											<h2><?php echo esc_html( $item['subject'] ); ?></h2>
										<?php endif; ?>

										<?php if ( $image && 'Grid 2' == $display_type_new ) : ?>
											<div class="avatar">
												<img src="<?php echo esc_html( $image[0] ); ?>" alt="<?php echo esc_html( $item['customer'] ).esc_html__( '\'s Avatar', 'hillter' ); ?>">
											</div>
										<?php endif; ?>

										<p><?php echo esc_html( $item['content'] ); ?></p>
										<span><strong><?php echo esc_html( $item['customer'] ); ?></strong> - <?php echo esc_html( $item['position'] ); ?></span>
									</div>
								</div>
								<!-- END / ITEM -->
								<?php } ?>
							</div>
						</div>
					</div>
					<!-- END / GUEST BOOK MASONRY -->
				<?php

			}
		} else {
			echo esc_html__( 'Not testimonial found', 'hillter' );
		}
		$output = ob_get_clean();
		// Return output.
		return $output;
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_awe_testimonial extends WPBakeryShortCode {

	}
}
