<?php

class awe_hillter_team extends awe_shortcode
{

    public function __construct()
    {
        $this->custom_shortcode('awe_hillter_team', array($this, 'awe_render_html'));
        add_action('vc_before_init', array($this, 'awe_vc_shortcode'));
    }

    public function awe_vc_shortcode()
    {
        vc_map(array(
            'name' => __('Awe Team', 'js_composer'),
            'base' => 'awe_hillter_team',
            "category" => __("Awe shortcode", 'hillter'),
            "icon" => $this->icon('shortcode.png'),
            'description' => __('Display team members', 'hillter'),
            "class" => "awe_shortcode",
            'params' => array(
                array(
                    "type" => "textfield",
                    "heading" => __("Team Member Name", 'hillter'),
                    "param_name" => "name",
                    'description'=> 'Name of the person'
                ),
                array(
                    "type" => "textfield",
                    "heading" => __("Team Member Position", 'hillter'),
                    "param_name" => "position",
                    "description" => "Position of the person."

                )
            , array(
                    "type" => "attach_image",
                    "heading" => __("Team Member Image", 'hillter'),
                    "param_name" => "images",
                )
            , array(
                    "type" => "textarea",
                    "heading" => __("Team Member Description", 'hillter'),
                    "param_name" => "description",
                    "description" => "Enter a few words that describe the person"
                )
            , array(
                    "type" => "social",
                    "heading" => __("Team Member Social Link", 'hillter'),
                    "param_name" => "social",
                    "description" => "Settings social link for the person"
                )

            )
        ));
    }

    public function awe_render_html($atts, $content = '')
    {
        global $woocommerce_loop;
        $option = awe_get_options();
        extract(shortcode_atts(array(
            'name' => '',
            'position' => '',
            'description' => '',
            'images' => '',
            'social' => ''), $atts));
        ob_start();
        $images = wp_get_attachment_image_src($images, 'medium');
        ?>
        <!-- TEAM MEMBER -->
        <div class="team_item text-center">

            <div class="img">
                <a href=""><img src="<?php echo esc_url($images[0]); ?>" alt="<?php echo esc_attr($name); ?>"></a>
            </div>

            <div class="text">
                <h2><?php echo esc_html($name); ?></h2>
                <?php if ( $position ) : ?>
                    <span><?php echo esc_html($position); ?></span>
                <?php endif; ?>
                <?php echo wpautop($description); ?>
                <?php parse_str(urldecode($social), $social_value); ?>
                <div class="team-share">
                    <?php foreach ($social_value as $k => $item) {
                        $show = ($item=="") ? ' style="display:none"' : "" ;
                        echo '<a href="' . esc_url($item) . '"'.$show.'><i class="fa fa-' . esc_attr($k) . '"></i></a>';
                    } ?>
                </div>
            </div>

        </div>
        <!-- END / TEAM MEMBER -->
        <?php
        return ob_get_clean();
    }

}

if (class_exists('WPBakeryShortCode')) {

    class WPBakeryShortCode_awe_hillter_team extends WPBakeryShortCode
    {

    }

}
