<?php

class AWE_Special_Heading extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_special_heading', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		$size_value = array(
			__( 'Default', 'hillter' )	=> 0,
		);
		for ( $i = 10; $i <= 50; $i++ ) {
			$size_value[$i . 'px'] = $i;
		}

		$pad_value = array();
		for ( $i = 0; $i <= 100; $i++ ) {
			$pad_value[$i . 'px'] = $i;
		}

		vc_map( array(
			'name'	=> __( 'Awe Special Heading', 'hillter' ),
			'base'	=> 'awe_special_heading',
			'category'	=> __( 'Awe shortcode', 'hillter' ),
			'icon'	=> $this->icon('shortcode.png'),
            'description' => __( 'Display special heading', 'hillter' ),
			'params'	=> array(
				array(
					'type'	=> 'textfield',
					'heading'	=> __( 'Heading text', 'hillter' ),
					'param_name'	=> 'heading_text',
					'holder'	=> 'div',
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Heading type', 'hillter' ),
					'param_name'	=> 'type',
					'description' => '',
					'value'	=> array(
						'H1'	=> 'h1',
						'H2'	=> 'h2',
						'H3'	=> 'h3',
						'H4'	=> 'h4',
						'H5'	=> 'h5',
						'H6'	=> 'h6',
					),
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Heading style', 'hillter' ),
					'param_name'	=> 'style',
					'value'	=> array(
						__( 'Center', 'hillter' )	=> 'center',
						__( 'Left', 'hillter' )	=> 'left',
						__( 'Right', 'hillter' )	=> 'right',
					),
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Heading size', 'hillter' ),
					'param_name'	=> 'size',
					'value'	=> $size_value,
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Subheading', 'hillter' ),
					'param_name'	=> 'subheading',
					'value'	=> array(
						__( 'None', 'hillter' )	=> 'none',
						__( 'Display subheading below', 'hillter' )	=> 'below',
						__( 'Display subheading above', 'hillter' )	=> 'above',
					),
				),
				array(
					'type'	=> 'textfield',
					'heading'	=> __( 'Subheading text', 'hillter' ),
					'param_name'	=> 'sub_text',
					'dependency'	=> array(
						'element'	=> 'subheading',
						'value'	=> array( 'below', 'above' ),
					),
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Subheading size', 'hillter' ),
					'param_name'	=> 'sub_size',
					'value'	=> $size_value,
					'dependency'	=> array(
						'element'	=> 'subheading',
						'value'	=> array( 'below', 'above' ),
					),
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Padding bottom', 'hillter' ),
					'param_name'	=> 'pad_bottom',
					'value'	=> $pad_value,
				),
				array(
					'type'	=> 'colorpicker',
					'heading'	=> __( 'Color', 'hillter' ),
					'param_name'	=> 'color',
					'group'	=> __( 'Color', 'hillter' ),
				),
			)
		) );
	}


	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array(
			'heading_text' => '',
			'type'	=> 'h1',
			'style'	=> 'center',
			'size'	=> 0,
			'subheading'	=> 'none',
			'sub_text'	=> '',
			'sub_size'	=> 0,
			'pad_bottom'	=> 0,
			'color'	=> '',
		), $atts ) );
		// text
		$heading =  esc_html($heading_text) ;
		// size
		$size = absint( $size );
		$size_atts = '';
		if ( $size ) {
			$size_atts = ' style="font-size:' . $size . 'px"';
		}

		// tag
		if ( $heading ) {
			$heading = "<{$type}{$size_atts}>{$heading}</{$type}>";
		}

		// subheading
		$subheading = in_array( $subheading, array( 'none', 'below', 'above' ) ) ? $subheading : 'none';
		if ( $subheading != 'none' ) {
			// Subheading size
			$sub_size = absint( $sub_size );
			$sub_size_atts = '';
			if ( $sub_size ) {
				$sub_size_atts = ' style="font-size:' . $sub_size . 'px"';
			}

			// subheading text
			if ( $sub_text ) {
				$sub_head = '<div class="awe-subheading ' . esc_attr( $subheading ) . '"' . $sub_size_atts . '><p>' . esc_html( $sub_text ) . '</p></div>';
			}

			// subheading posision
			if ( $subheading == 'below' ) {
				$output = $heading . $sub_head;
			} else {
				$output = $sub_head . $heading;
			}
		} else {
			$output = $heading;
		}

		// container
		if ( $output ) {
			$contain_style = '';

			// padding
			$pad_bottom = absint( $pad_bottom );
			if ( $pad_bottom ) {
				$contain_style .= 'padding-bottom:' . $pad_bottom . 'px;';
			}

			// Color
			if ( $color ) {
				$contain_style .= 'color:' . $color . ';';
			}

			$contain_atts = '';
			if ( $contain_style ) {
				$contain_atts = ' style="' . esc_attr( $contain_style ) . '"';
			}

			$output = '<div class="awe-special-heading text-' . esc_attr( $style ) . '"' . $contain_atts . '>' . $output . '</div>';
		}

		return $output;
	}

}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_AWE_Special_Heading extends WPBakeryShortCode {

	}

}
