<?php

class awe_room extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_room', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		$style = array( 1, 2, 3, 4, 5, 6, 'Home Slide 1', 'Home Slide 2' );
		vc_map( array(
			'name'        => __( 'Awe List Room', 'js_composer' ),
			'base'        => 'awe_room',
			'category'    => __( 'Awe shortcode', 'hillter' ),
			'icon'        => $this->icon( 'shortcode.png' ),
			'description' => __( 'Show list room.', 'hillter' ),
			'class'       => 'awe_shortcode',
			'params'      => array(
				array(
					'type'       => 'dropdown',
					'heading'    => __( 'List Room Style', 'hillter' ),
					'param_name' => 'style',
					'value'      => $style,
					'description' => 'Display rooms',
				),
				array(
					'type'       => 'textfield',
					'heading'    => __( 'Room Number', 'hillter' ),
					'param_name' => 'num',
					'value'      => 4,
					'description' => 'How many items should be displayed per page?',
				),
			),
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		global $woocommerce_loop;
		$option = awe_get_options();
		extract( shortcode_atts( array(
			'style' => '',
			'num'   => '',
		), $atts ) );
		// Generate Default data
		if ( $style == "" ) {
			$style = 1;
		}
		if ( $num == "" ) {
			$num = 8;
		}
		if ( class_exists( 'APB_Booking' ) ) :
			$query_args = array(
				'post_type'	=> 'apb_room_type',
				'suppress_filters'	=> false,
			);

			if ( $num ) {
				$query_args['posts_per_page'] = absint( $num );
			}

			$query_args = apply_filters( 'hillter_room_shortcode_query_args', $query_args, $atts );

			$room_type_objects = get_posts( $query_args );
			// $room_type_objects = AWE_function::get_room_type();

			ob_start();

			if ( 'Home Slide 1' == $style ) {
				// Get Style Home Slide 1.
				$s_wrap_start = '<div class="row">';
				$s_wrap_end   = '</div>';
				?>
				<div class="accomd-modations-content owl-single">
					<?php
					if ( ! empty( $room_type_objects ) ) {
						$item = '';
						$subitem = '';
						$count  = 0;
						if ( sizeof( $room_type_objects > $num ) ) {
							$new_obj = array_slice( $room_type_objects, 0, $num );
						} else {
							$new_obj = $room_type_objects;
						}

						$total = sizeof( $new_obj );

						foreach ( $new_obj as $k => $rt_obj ) {
							$count++;
							$data['rt_id']       = $rt_obj->ID;
							$data['start_price'] = get_post_meta( $rt_obj->ID, 'base_price', true );

							ob_start();
							room_item_slide_1( $data );
							$subitem .= ob_get_clean();

							if ( $total == $count ) {
								$item .= '<div class="row">' . $subitem . '</div>';
							} elseif ( $total > 4 && $count == 4 ) {
								$item .= '<div class="row">' . $subitem . '</div>';
								$subitem = '';
								$count = 0;
							} elseif ( $total == ( $k + 1 ) ) {
								$item .= '<div class="row">' . $subitem . '</div>';
							}
						}
						echo wp_kses_post( $item );
					}
					?>
				</div>

			<?php } elseif ( 'Home Slide 2' == $style ) { ?>

				<div class="accomd-modations-content_1">
					<div class="accomd-modations-slide_1">
						<?php
						if ( ! empty( $room_type_objects ) ) {
							$k = 1;
							foreach ( $room_type_objects as $rt_obj ) {
								$data['rt_id']       = $rt_obj->ID;
								$data['start_price'] = get_post_meta( $rt_obj->ID, 'base_price', true );
								$data['i']           = $k;
								if ( $k > $num ) {
									break; // Break to limit room type
								}
								room_item_slide_2( $data );
								$k++;
							}
						}
						?>
					</div>
				</div>
			<?php
			} else {
				// Get room template from 1 to 6.
				echo '<!-- ROOM -->';
				echo '<div class="room-wrap-' . $style . '">';
				echo ( 1 == $style || 5 == $style ) ? '<div class="row">' : '';
				// echo '<div class="col-lg-10 col-lg-offset-1">';
				if ( ! empty( $room_type_objects ) ) {
					$k = 1;
					foreach ( $room_type_objects as $rt_obj ) {
						$data['rt_id']       = $rt_obj->ID;
						$data['start_price'] = get_post_meta( $rt_obj->ID, 'base_price', true );
						$data['i']           = $k;
						if ( $k > $num ) {
							break; // Break to limit room type.
						}
						call_user_func( 'room_item_' . $style, $data ); // Call function room template
						$k ++;
					}
				}
				// echo '</div>'; // End col-lg
				echo ( 1 == $style || 5 == $style ) ? '</div>' : ''; // End Row.
				echo '</div>'; // End Wrap.
				echo '<!-- END / ROOM -->';
			}

			return ob_get_clean();
		endif;
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_awe_room extends WPBakeryShortCode {

	}

}
