<?php

class AWE_Reservation_Shortcode extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_reservation', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'load_assets' ) );
	}

	public function load_assets() {
		$url = get_template_directory_uri() . '/assets/css/';
		// wp_enqueue_style( 'awe-bootstrap-select', $url . 'lib/bootstrap-select.min.css', false, false );
		// wp_enqueue_script( 'awe-bootstrap-select', $url . 'lib/bootstrap-select.js', array( 'jquery' ), null, true );
		wp_enqueue_script( 'jquery-ui-datepicker' );
		wp_enqueue_script( 'awe-js-reservation-form', get_template_directory_uri() . '/awe_shortcode/assets/js/reservation-form.js', array( 'jquery-ui-datepicker' ), false, true );
		wp_localize_script( 'awe-js-reservation-form', 'ReservationForm', array(
			'textErrorDate'	=> __( 'You must choose a date', 'hillter' ),
			'textErrorTime'	=> __( 'You must choose a time', 'hillter' ),
			'textErrorPerson'	=> __( 'You must choose number of persons', 'hillter' ),
		) );
	}

	public function awe_vc_shortcode() {
		$awe_param = array();

		// title
		$awe_param[] = array(
			'type'	=> 'textfield',
			'heading'	=> __( 'Reservation Form Title', 'hillter' ),
			'param_name'	=> 'title',
			'description'	=> __( 'Title of Reservation form', 'hillter' ),
			'std'	=> __( 'Reservation', 'hillter' ),
		);

		if ( has_action( 'wpcf7_init' ) ) { // if installed contact form 7

			$awe_param[] = array(
				'type'	=> 'dropdown',
				'heading'	=> __( 'Choose form type', 'hillter' ),
				'param_name'	=> 'type',
				'description'	=> __( 'Use contact form 7 or open table form', 'hillter' ),
				'value'	=> array(
					__( 'Open table', 'hillter' )	=> 'opt',
					__( 'Contact form 7', 'hillter' )	=> 'cf7',
				),
				'std'	=> 'opt',
			);

			// get all contact form
			$forms = get_posts( 'post_type=wpcf7_contact_form&posts_per_page=-1' );
			$form_value = array();
			foreach ( $forms as $v ) {
				$form_value[$v->post_title] = $v->ID;
			}

			$awe_param[] = array(
				'type'	=> 'dropdown',
				'heading'	=> __( 'Choose contact form', 'hillter' ),
				'param_name'	=> 'cf7',
				'description'	=> __( 'Choose contact form 7', 'hillter' ),
				'value'	=> $form_value,
				'dependency'	=> array(
					'element'	=> 'type',
					'value'	=> array( 'cf7' ),
				),
			);

		} else {

			$awe_param[] = array(
				'type'	=> 'dropdown',
				'heading'	=> __( 'Choose form type', 'hillter' ),
				'param_name'	=> 'type',
				'description'	=> __( 'Use contact form 7 or open table form', 'hillter' ),
				'value'	=> array(
					__( 'Open table', 'hillter' )	=> 'opt',
				),
				'std'	=> 'opt',
			);

		}

		$awe_param[] = array(
			'type'	=> 'textfield',
			'heading'	=> __( 'Open Table Restaurant ID', 'hillter' ),
			'param_name'	=> 'opt_id',
			'description'	=> '',
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'dropdown',
			'heading'	=> __( 'Restaurant Location', 'hillter' ),
			'param_name'	=> 'opt_location',
			'description'	=> '',
			'value'	=> array(
				__( 'United States', 'hillter' )	=> 'com',
				__( 'United Kingdom', 'hillter' )	=> 'co.uk',
				__( 'Germany', 'hillter' )	=> 'de',
				__( 'Mexico', 'hillter' )	=> 'com.mx',
				__( 'Japan', 'hillter' )	=> 'jp',
				__( 'Other Country', 'hillter' )	=> 'other',
			),
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'dropdown',
			'heading'	=> __( 'Date Format', 'hillter' ),
			'param_name'	=> 'opt_date_format',
			'description'	=> '',
			'value'	=> array( 'mm/dd/yyyy', 'dd/mm/yyyy', 'yyyy/mm/dd', 'yyyy/dd/mm' ),
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'dropdown',
			'heading'	=> __( 'Time Format', 'hillter' ),
			'param_name'	=> 'opt_time_format',
			'description'	=> '',
			'value'	=> array(
				__( '12 hours', 'hillter' )	=> '12',
				__( '24 hours', 'hillter' )	=> '24',
			),
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'textfield',
			'heading'	=> __( 'Date Input Label', 'hillter' ),
			'param_name'	=> 'opt_date_label',
			'description'	=> '',
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'std'	=> _x( 'Date', 'date label reservation form', 'hillter' ),
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'textfield',
			'heading'	=> __( 'Time Input Label', 'hillter' ),
			'param_name'	=> 'opt_time_label',
			'description'	=> '',
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'std'	=> _x( 'Time', 'time label reservation form', 'hillter' ),
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'textfield',
			'heading'	=> __( 'Person Input Label', 'hillter' ),
			'param_name'	=> 'opt_person_label',
			'description'	=> '',
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'std'	=> _x( 'People', 'person label reservation form', 'hillter' ),
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);

		$awe_param[] = array(
			'type'	=> 'textfield',
			'heading'	=> __( 'Submit Button Label', 'hillter' ),
			'param_name'	=> 'opt_submit_label',
			'description'	=> '',
			'edit_field_class'	=> 'vc_col-md-6 vc_column',
			'std'	=> _x( 'Check Availiability', 'submit label reservation form', 'hillter' ),
			'dependency'	=> array(
				'element'	=> 'type',
				'value'	=> array( 'opt' ),
			),
		);


		vc_map( array(
			'name'	=> __( 'Awe Reservation', 'hillter' ),
			'base'	=> 'awe_reservation',
			'class'	=> '',
			'category'	=> __( 'Awe shortcode', 'hillter' ),
			'icon'	=> $this->icon( 'shortcode.png' ),
            'description' => __( 'Display reservation form', 'hillter' ),
			'params'	=> $awe_param,
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array(
			'title'	=> __( 'Reservation', 'hillter' ),
			'type'	=> 'opt',
			'cf7'	=> '',
			'opt_id'	=> '',
			'opt_location'	=> 'com',
			'opt_date_format'	=> 'mm/dd/yyyy',
			'opt_time_format'	=> '12',
			'opt_date_label'	=> _x( 'Date', 'date label reservation form', 'hillter' ),
			'opt_time_label'	=> _x( 'Time', 'time label reservation form', 'hillter' ),
			'opt_person_label'	=> _x( 'People', 'person label reservation form', 'hillter' ),
			'opt_submit_label'	=> _x( 'Check Availiability', 'submit label reservation form', 'hillter' ),
		), $atts ) );

		ob_start();

		// Open table
		if ( $type == 'opt' ) {

			$location = in_array( $opt_location, array( 'com', 'co.uk', 'de', 'com.mx', 'jp' ) ) ? $opt_location : 'com';
			$form_action = 'http://www.opentable.' . $location . '/restaurant-search.aspx';

			$time_format = in_array( $opt_time_format, array( 12, 24 ) ) ? $opt_time_format : 12;

			if ( $time_format == 12 ) {
				$time_list = array(
					'6:00am'	=> '6:00 am',
					'6:30am'	=> '6:30 am',
					'7:00am'	=> '7:00 am',
					'7:30am'	=> '7:30 am',
					'8:00am'	=> '8:00 am',
					'8:30am'	=> '8:30 am',
					'9:00am'	=> '9:00 am',
					'9:30am'	=> '9:30 am',
					'10:00am'	=> '10:00 am',
					'10:30am'	=> '10:30 am',
					'11:00am'	=> '11:00 am',
					'11:30am'	=> '11:30 am',
					'12:00am'	=> '12:00 am',
					'12:30am'	=> '12:30 am',
					'1:00pm'	=> '1:00 pm',
					'1:30pm'	=> '1:30 pm',
					'2:00pm'	=> '2:00 pm',
					'2:30pm'	=> '2:30 pm',
					'3:00pm'	=> '3:00 pm',
					'3:30pm'	=> '3:30 pm',
					'4:00pm'	=> '4:00 pm',
					'4:30pm'	=> '4:30 pm',
					'5:00pm'	=> '5:00 pm',
					'5:30pm'	=> '5:30 pm',
					'6:00pm'	=> '6:00 pm',
					'6:30pm'	=> '6:30 pm',
					'7:00pm'	=> '7:00 pm',
					'7:30pm'	=> '7:30 pm',
					'8:00pm'	=> '8:00 pm',
					'8:30pm'	=> '8:30 pm',
					'9:00pm'	=> '9:00 pm',
					'9:30pm'	=> '9:30 pm',
					'10:00pm'	=> '10:00 pm',
					'10:30pm'	=> '10:30 pm',
					'11:00pm'	=> '11:00 pm',
					'11:30pm'	=> '11:30 pm',
				);
			} else {
				$time_list = array(
					'6:00am'	=> '6:00',
					'6:30am'	=> '6:30',
					'7:00am'	=> '7:00',
					'7:30am'	=> '7:30',
					'8:00am'	=> '8:00',
					'8:30am'	=> '8:30',
					'9:00am'	=> '9:00',
					'9:30am'	=> '9:30',
					'10:00am'	=> '10:00',
					'10:30am'	=> '10:30',
					'11:00am'	=> '11:00',
					'11:30am'	=> '11:30',
					'12:00am'	=> '12:00',
					'12:30am'	=> '12:30',
					'1:00pm'	=> '13:00',
					'1:30pm'	=> '13:30',
					'2:00pm'	=> '14:00',
					'2:30pm'	=> '14:30',
					'3:00pm'	=> '15:00',
					'3:30pm'	=> '15:30',
					'4:00pm'	=> '16:00',
					'4:30pm'	=> '16:30',
					'5:00pm'	=> '17:00',
					'5:30pm'	=> '17:30',
					'6:00pm'	=> '18:00',
					'6:30pm'	=> '18:30',
					'7:00pm'	=> '19:00',
					'7:30pm'	=> '19:30',
					'8:00pm'	=> '20:00',
					'8:30pm'	=> '20:30',
					'9:00pm'	=> '21:00',
					'9:30pm'	=> '21:30',
					'10:00pm'	=> '22:00',
					'10:30pm'	=> '22:30',
					'11:00pm'	=> '23:00',
					'11:30pm'	=> '23:30',
				);
			}
			array_unshift( $time_list, $opt_time_label );

			?>

	            <div class="reservation">
	            	<h2><?php echo esc_html( $title ); ?></h2>

	            	<div class="reservation_form">
	                    <div class="row">

	                        <form action="<?php echo esc_url( $form_action ); ?>" method="get" target="_blank" class="awe-reservation-form">
	                        	<div class="col-sm-4">
		                            <input type="text" class="awe-calendar awe-reservation-date <?php if ( $location == 'de' ) echo 'de-date'; ?>" placeholder="<?php echo esc_attr( $opt_date_label ); ?>">
		                            <input type="hidden" name="startDate">
		                        </div>

		                        <div class="col-sm-4">
		                        	<select class="awe-select" name="ResTime">
		                            	<?php foreach ( $time_list as $k => $v ) : ?>
		                            		<option value="<?php echo esc_attr( $k ); ?>"><?php echo esc_html( $v ); ?></option>
		                            	<?php endforeach; ?>
		                            </select>
		                        </div>

		                        <div class="col-sm-4">
		                            <input type="text" name="partySize" class="awe-input" placeholder="<?php echo esc_attr( $opt_person_label ); ?>">
		                        </div>

		                        <input type="hidden" name="RestaurantID" class="RestaurantID" value="<?php echo esc_attr( $opt_id ); ?>">
								<input type="hidden" name="rid" class="rid" value="<?php echo esc_attr( $opt_id ); ?>">
								<input type="hidden" name="GeoID" class="GeoID" value="15">
								<input type="hidden" name="txtDateFormat" class="txtDateFormat" value="<?php echo ( $location == 'de' ? str_replace( '/', '.', $opt_date_format ) : $opt_date_format ); ?>">
								<input type="hidden" name="RestaurantReferralID" class="RestaurantReferralID" value="<?php echo esc_attr( $opt_id ); ?>">

		                        <div class="col-md-12 col-sm-12 text-center">
		                            <button type="submit" class="awe-btn awe-btn-13"><?php echo esc_html( $opt_submit_label ); ?></button>
		                        </div>
	                        </form>

	                    </div>
	                </div>
	            </div>

			<?php

		} else {

			?>

				<div class="reservation">
	            	<h2><?php echo esc_html( $title ); ?></h2>

	            	<div class="reservation_form">
	                    <div class="row">
	                    	<?php echo do_shortcode( '[contact-form-7 id="' . $cf7 . '"]' ); ?>
	                    </div>
	                </div>
	            </div>

			<?php

		}


		return ob_get_clean();

	}

}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_AWE_Reservation_Shortcode extends WPBakeryShortCode {

	}
}
