<?php

class awe_posts extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_posts', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		$auto_complete_value = array();
		$cats = get_categories();

		foreach ( $cats as $cat ) {
			$auto_complete_value[] = array(
				'label' => $cat->name,
				'value' => $cat->term_id,
			);
		}

		vc_map( array(
			'name'              => __( 'Awe Posts', 'hillter' ),
			'base'              => 'awe_posts',
			'category'          => __( 'Awe shortcode', 'hillter' ),
			'icon'              => $this->icon( 'shortcode.png' ),
			'class'             => 'awe_shortcode',
			'description'       => __( 'Dispaly any posts', 'hillter' ),
			'admin_enqueue_js'  => AWE_ROOT_URL . 'asset/jquery.chosen/chosen.jquery.min.js',
			'admin_enqueue_css' => AWE_ROOT_URL . 'asset/jquery.chosen/chosen.min.css',
			'params'            => array(
				array(
					'type'       => 'autocomplete',
					'heading'    => __( 'Categories', 'hillter' ),
					'param_name' => 'post_cat',
					'settings'   => array(
						'multiple'       => true,
						'sortable'       => true,
						'min_length'     => 1,
						'unique_values'  => true,
						'display_inline' => true,
						'values'         => $auto_complete_value,
					),
				),
				array(
					'type'       => 'dropdown',
					'heading'    => __( 'Choose Post List Layout', 'hillter' ),
					'param_name' => 'style',
					'value'      => array( 'List', 'Grid' ),
					'description' => 'Choose the layout of your Post List',
				),
				array(
					'type'       => 'dropdown',
					'heading'    => __( 'Post List Columns', 'hillter' ),
					'param_name' => 'column',
					'value'      => array( 3, 4, 6 ),
					'description' => 'Choose the column count of your Post List',
					'dependency' => array(
						'element' => 'style',
						'value' => 'Grid',
					),
				),
				array(
					'type'       => 'textfield',
					'heading'    => __( 'Post Number', 'hillter' ),
					'param_name' => 'num',
					'value'      => 8,
					'description' => 'How many posts do you want to display ?',
				),
			),
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {

		extract( shortcode_atts( array(
			'taxonomy'     => 'category',
			'post_cat' 		=> '',
			'style'       	=> '',
			'num'         	=> '',
			'column'      	=> '',
		), $atts ) );
		$data = array();
		$data['taxonomy'] = $taxonomy;
		$data['post_cat'] = $post_cat;
		$data['style'] = $style;
		$data['num'] = $num;
		$data['column'] = ( 'Grid' == $data['style'] ) ? $column : 0;
		ob_start();
		awe_posts_content( $data );

		if ( 'List' == $style ) {
			echo '<a class="awe-btn awe-btn-normal awe-btn-outline" href="' . esc_url( get_permalink( get_option( 'page_for_posts' ) ) ) . '" title="">' . esc_html__( 'Read more', 'hillter' ) . '</a>';
		}

		return ob_get_clean();
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_awe_posts extends WPBakeryShortCode {

	}
}
