<?php
/**
 * Awe iconlist 2 shortcode
 *
 * @package Hillter
 */

/**
 * Class AWE_Iconlist2
 */
class AWE_Iconlist2 extends awe_shortcode {

	/**
	 * Shortcode name.
	 *
	 * @var string
	 * @access protected
	 */
	protected $shortcode_name = 'awe_iconlist2';


	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->custom_shortcode( $this->shortcode_name, array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
		add_filter( 'vc_iconpicker-type-hillter', array( $this, 'vc_iconpicker_type_hillter' ) );
	}


	/**
	 * Map shortcode with VC.
	 */
	public function awe_vc_shortcode() {
		vc_map( array(
			'name' => __( 'Awe Iconlist 2', 'hillter' ),
			'base' => $this->shortcode_name,
			'category' => __( 'Awe shortcode', 'hillter' ),
			'icon' => $this->icon( 'shortcode.png' ),
			'class' => 'awe_shortcode',
			'description' => __( 'Display icon list', 'hillter' ),
			'params' => array(
				array(
					'type'       => 'param_group',
					'heading'    => __( 'Icons list', 'hillter' ),
					'param_name' => 'icons',
					'params'     => array(
						array(
							'type'        => 'dropdown',
							'heading'     => __( 'Icon library', 'hillter' ),
							'value'       => array(
								__( 'Default', 'hillter' )   => 'default',
								__( 'Hillter', 'hillter' )         => 'hillter',
							),
							'admin_label' => true,
							'param_name'  => 'type',
							'description' => __( 'Select icon library.', 'hillter' ),
							'std'		  => 'default',
						),
						array(
							'type'       => 'iconpicker',
							'heading'    => __( 'Choose icon', 'hillter' ),
							'param_name' => 'icon',
							'value'      => 'fa fa-adjust',
							'settings'   => array(
								'emptyIcon'    => '',
								'iconsPerPage' => 4000,
							),
							'dependency'   => array(
								'element'    => 'type',
								'value'      => 'default',
							),
						),
						array(
							'type'         => 'iconpicker',
							'heading'      => __( 'Choose icon', 'hillter' ),
							'param_name'   => 'hillter_icon',
							'value'        => 'hillter-icon-person',
							'settings'     => array(
								'emptyIcon'    => false,
								'iconsPerPage' => 4000,
								'type'         => 'hillter',
							),
							'dependency'   => array(
								'element'    => 'type',
								'value'      => 'hillter',
							),
							'description'  => __( 'Select icon from library.', 'hillter' ),
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Icon text', 'hillter' ),
							'param_name' => 'text',
						),
					),
				),
			),
		) );
	}


	/**
	 * Shortcode output.
	 *
	 * @param  array  $atts    Attributes.
	 * @param  string $content Content.
	 * @return string
	 */
	public function awe_render_html( $atts, $content = '' ) {
		$atts = shortcode_atts( array(
			'icons' => '',
		), $atts );

		$icons = vc_param_group_parse_atts( $atts['icons'] );

		if ( empty( $icons ) ) {
			return;
		}

		wp_enqueue_style( 'font-awesome' );

		ob_start();
		?>
		<div class="awe-icon-list">
			<ul>
				<?php foreach ( $icons as $v ) : ?>
					<li>
						<?php if ( 'hillter' == ( $v['type'] ) ) : ?>
						<i class="iconlist-icon <?php echo esc_attr( $v['hillter_icon'] ); ?>"></i>
						<?php else : ?>
						<i class="iconlist-icon <?php echo esc_attr( $v['icon'] ); ?>"></i>
						<?php endif; ?>
					
						<?php if ( ! empty( $v['text'] ) ) : ?>
							<span class="iconlist-title"><?php echo esc_html( $v['text'] ); ?></span>
						<?php endif; ?>
					</li>
				<?php endforeach; ?>
			</ul>
		</div>
		<?php
		return ob_get_clean();
	}

	public function vc_iconpicker_type_hillter( $icons ) {
		$hillter_icons = array(
			array( 'hillter hillter-icon-person' => 'person' ),
			array( 'hillter hillter-icon-quote-left' => 'quote-left' ),
			array( 'hillter hillter-icon-breakfast' => 'breakfast' ),
			array( 'hillter hillter-icon-decor' => 'decor' ),
			array( 'hillter hillter-icon-bed' => 'bed' ),
			array( 'hillter hillter-icon-telephone' => 'telephone' ),
			array( 'hillter hillter-icon-hangers' => 'hangers' ),
			array( 'hillter hillter-icon-phone' => 'phone' ),
			array( 'hillter hillter-icon-ocenview' => 'ocenview' ),
			array( 'hillter hillter-icon-calendar' => 'calendar' ),
			array( 'hillter hillter-icon-cart' => 'cart' ),
			array( 'hillter hillter-icon-wifi' => 'wifi' ),
			array( 'hillter hillter-icon-arrow' => 'arrow' ),
			array( 'hillter hillter-icon-air-conditioner' => 'air-conditioner' ),
			array( 'hillter hillter-icon-cable' => 'cable' ),
			array( 'hillter hillter-icon-luxury' => 'luxury' ),
			array( 'hillter hillter-icon-location' => 'location' ),
			array( 'hillter hillter-icon-size' => 'size' ),
			array( 'hillter hillter-icon-cloud' => 'cloud' ),
			array( 'hillter hillter-icon-view' => 'view' ),
			array( 'hillter hillter-icon-time' => 'time' ),
			array( 'hillter hillter-icon-bar' => 'bar' ),
			array( 'hillter hillter-icon-dressing-table' => 'dressing-table' ),
			array( 'hillter hillter-icon-bar-coffee' => 'bar-coffee' ),
			array( 'hillter hillter-icon-microphone' => 'microphone' ),
			array( 'hillter hillter-icon-media-play' => 'media-play' ),
			array( 'hillter hillter-icon-down-arrow' => 'down-arrow' ),
			array( 'hillter hillter-icon-cooker-hood' => 'cooker-hood' ),
			array( 'hillter hillter-icon-left-arrow' => 'left-arrow' ),
			array( 'hillter hillter-icon-right-arrow' => 'right-arrow' ),
		);

		return array_merge( $icons, $hillter_icons );
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_AWE_Iconlist2 extends WPBakeryShortCode {

	}
}
