<?php

class AWE_Iconlist extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_iconlist', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		vc_map( array(
			'name' => __( 'Awe Iconlist', 'hillter' ),
			'base' => 'awe_iconlist',
			'category' => __( 'Awe shortcode', 'hillter' ),
			'icon' => $this->icon( 'shortcode.png' ),
			'class' => 'awe_shortcode',
			'admin_enqueue_css' => array(
				get_template_directory_uri() . '/awe_shortcode/assets/css/awe_style.css',
				get_template_directory_uri() . '/Framework/asset/icons/css/hilltericon.css',
				get_template_directory_uri() . '/awe_shortcode/assets/iconlist/awe-dialog.css',
			),
			'front_enqueue_css' => get_template_directory_uri() . '/awe_shortcode/assets/css/awe_style.css',
			'description' => __( 'Display icon list', 'hillter' ),
			'params' => array(
				array(
					'type'       => 'param_iconlist',
					'heading'    => __( '', 'hillter' ),
					'class'      => 'Awe_meta_id',
					'holder'     => 'div',
					'param_name' => 'list',
					'value'      => '',
				),
			),
			'deprecated' => '1.10',
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array(
			'list' => '',
		), $atts ) );

		global $wpdb;

		$result = $wpdb->get_var( $wpdb->prepare( "SELECT `meta_value` FROM $wpdb->postmeta WHERE meta_id = %d", absint( $list ) ) );

		parse_str( trim($result), $arr );


		ob_start();
		if ( count( $arr ) > 0 ) {
			?>

				<div class="awe-icon-list">
					<ul>
						<?php foreach ( $arr as $v ) : ?>
							<li>
								<?php if ( ! empty( $v['icon'] ) ) : ?>
									<i class="iconlist-icon <?php echo esc_attr( $v['icon'] ); ?>"></i>
								<?php endif; ?>

								<?php if ( ! empty( $v['text'] ) ) : ?>
									<span class="iconlist-title"><?php echo esc_html( $v['text'] ); ?></span>
								<?php endif; ?>
							</li>
						<?php endforeach; ?>
					</ul>
				</div>

			<?php
		} else {
			echo esc_html__( 'There\'s no list item', 'hillter' );
		}
		$output = ob_get_clean();
		// Return output
		return $output;
	}

}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_AWE_Iconlist extends WPBakeryShortCode {

	}


}


