<?php
/**
 * Awe gmap shortcode
 *
 * @package Hillter
 */

/**
 * Class Awe_gmap
 */
class Awe_gmap extends Awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_gmap', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		vc_map( array(
			'name' => __( 'Awe Google map', 'hillter' ),
			'base' => 'awe_gmap',
			'content_element' => true,
			'wrapper_class' => '',
			'class' => 'awe_shortcode',
			'show_settings_on_create' => true,
			'category' => __( 'Awe shortcode', 'hillter' ),
			'admin_enqueue_js' => array(
				'http://maps.google.com/maps/api/js?libraries=places&key=AIzaSyAmVMX4ea-eLWvfu-AReW4SO_b1pO2LA2k',
				$this->get_resource( 'google/jquery.geocomplete.js', 'vendors' ),
			),
			'front_enqueue_js' => array(
				'http://maps.google.com/maps/api/js?libraries=places',
				$this->get_resource( 'google/jquery.geocomplete.js', 'vendors' ),
			),
			'icon' => $this->icon(),
			'description' => __( 'Display google map.', 'hillter' ),
			'params' => array(
				array(
					'type' => 'awe_param_gmap',
					'class' => '',
					'heading' => __( 'Search map', 'hillter' ),
					'param_name' => 'mapinfo',
					'value' => '',
				),
			),
			'deprecated' => '1.11',
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		$map = array(
			'location' => '',
			'latlong'  => '',
			'zoom'     => '',
		);

		if ( ! empty( $atts['mapinfo'] ) && 'EMPTY' != $atts['mapinfo'] ) {
			parse_str( urldecode( $atts['mapinfo'] ), $mapdata );
			$map = array_merge( $map, $mapdata );
		}

		if ( '' != $map['latlong'] ) {
			$latlong = explode( ',', $map['latlong'] );
		} else {
			$latlong = array( '', '' );
		}


		wp_enqueue_script( 'google-map-api', 'http://maps.google.com/maps/api/js?key=AIzaSyAmVMX4ea-eLWvfu-AReW4SO_b1pO2LA2k', array(), null );
		wp_enqueue_script( 'gmap', $this->get_resource( 'google/gmaps.min.js', 'vendors' ), 'google-map-api', '0.4.15', true );
		wp_enqueue_script( 'awe-js-gmap', get_template_directory_uri() . '/awe_shortcode/assets/js/gmap_script.js', array( 'jquery' ), false, true );

		return '<div class="Awe_gmap contact-map" id="Awe_gmap_' . $this->getId() . '" data-zoom="' . esc_attr( $map['zoom'] ) . '" data-lat="' . esc_attr( $latlong[0] ) . '" data-lng="' . esc_attr( $latlong[1] ) . '"></div>';
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_Awe_gmap extends WPBakeryShortCode {

	}
}
