<?php

class awe_gallery extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_gallery', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'load_assets' ) );
	}


	public function load_assets() {
		wp_enqueue_script( 'awe-js-isotope', get_template_directory_uri() . '/assets/js/lib/isotope.pkgd.min.js', array( 'jquery' ), false, true );
	}


	public function awe_vc_shortcode() {
		$size = get_intermediate_image_sizes();
		foreach ( $size as $new_size ) {
			switch ( $new_size ) {
				case 'awe-gallery-square':
					$new_size = 'Gallery Square (350x350)';
					break;
				case 'awe-gallery-rectangular':
					$new_size = 'Gallery Rectangular (380x265)';
					break;
			}
			$sizes[] = ucfirst( $new_size );
		}

		$auto_complete_value = array();
		$terms = get_terms( 'gallery_cat' );

		foreach ( $terms as $term ) {
			$auto_complete_value[] = array(
				'label' => $term->name,
				'value' => $term->term_id,
			);
		}

		vc_map( array(
			'name'              => __( 'Awe Gallery', 'hillter' ),
			'base'              => 'awe_gallery',
			'category'          => __( 'Awe shortcode', 'hillter' ),
			'icon'              => $this->icon( 'shortcode.png' ),
			'class'             => 'awe_shortcode',
			'description'       => __( 'List gallery or albums.', 'hillter' ),
			'params'            => array(
				array(
					'type'       => 'autocomplete',
					'heading'    => __( 'Gallery Categories', 'hillter' ),
					'param_name' => 'gallery_cat',
					'settings'   => array(
						'multiple'       => 1,
						'sortable'       => 1,
						'min_length'     => 1,
						'unique_values'  => true,
						'display_inline' => true,
						'values'         => $auto_complete_value,
					),
				),
				array(
					'type'        => 'dropdown',
					'heading'     => __( 'Gallery Columns', 'hillter' ),
					'param_name'  => 'column',
					'value'       => array( 1, 2, 3, 4, 5, 6 ),
					'description' => 'Choose the column count of your Gallery',
				),
				array(
					'type'        => 'dropdown',
					'heading'     => __( 'Gallery Image Size', 'hillter' ),
					'param_name'  => 'size',
					'value'       => $sizes,
					'description' => 'Choose image size for the small preview thumbnails',
				),
				array(
					'type'        => 'textfield',
					'heading'     => __( 'Gallery Number', 'hillter' ),
					'param_name'  => 'num',
					'value'       => 8,
					'description' => 'Entry the column count of your Gallery',
				),
				array(
					'type'        => 'checkbox',
					'heading'     => __( 'Gallery No Padding', 'hillter' ),
					'param_name'  => 'no_padding',
					'description' => 'Switch The gallery with mode no padding',
				),

			),
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array(
			'title'       => '',
			'gallery_cat' => '',
			// 'style'       => '',
			'size'       => 'thumbnail',
			'num'         => '',
			'column'      => '',
			'no_padding'  => '',
		), $atts ) );

		switch ( $size ) {
			case 'Gallery Square (350x350)':
				$size = 'awe-gallery-square';
				break;

			case 'Gallery Rectangular (380x265)':
				$size = 'awe-gallery-rectangular';
				break;
		}

		$size = lcfirst( $size );
		ob_start();
		$gallery = new Awe_Gallery_Shortcode();
		$gallery->awe_the_gallery( $title, $gallery_cat, $num, $column, $size,  $no_padding );

		return ob_get_clean();
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_awe_gallery extends WPBakeryShortCode {

	}
}
