<?php

class AWE_Event_Shortcode extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_event', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}


	public function awe_vc_shortcode() {
		vc_map( array(
			'name'	=> __( 'Awe Event', 'hillter' ),
			'description'	=> __( 'Display new events', 'hillter' ),
			'base'	=> 'awe_event',
			'class'	=> '',
			'category'	=> __( 'Awe shortcode', 'hillter' ),
			'icon'	=> $this->icon( 'shortcode.png' ),
			'params'	=> array(
				array(
					'type'	=> 'textfield',
					'heading'	=> __( 'Event Number', 'hillter' ),
					'param_name'	=> 'num',
					'description'	=> __( 'Number of events to show', 'hillter' ),
					'std'	=> 3,
				),
			),
		) );
	}


	public function awe_render_html( $atts, $content = '' ) {
		$atts = shortcode_atts( array( 'num' => 3 ), $atts );

		$the_query = new WP_Query( 'post_type=event&posts_per_page=' . absint( $atts['num'] ) );

		if ( ! $the_query->have_posts() ) {
			return '<p>' . __( 'No event found.', 'hillter' ) . '</p>';
		}

		ob_start();
		?>

			<ul class="event-restaurant_content">
				<?php while ( $the_query->have_posts() ) : $the_query->the_post(); ?>
					<?php
					$date = get_post_meta( get_the_ID(), 'awe_event_metabox_date', true ) ? strtotime( get_post_meta( get_the_ID(), 'awe_event_metabox_date', true ) ) : '';
					$time = get_post_meta( get_the_ID(), 'awe_event_metabox_time', true ) ? esc_html( get_post_meta( get_the_ID(), 'awe_event_metabox_time', true ) ) : '';
					?>
	                <li>
	                	<?php if ( $date ) : ?>
		                    <span class="event-date">
		                        <strong><?php echo date_i18n( 'd', $date ); ?></strong>
		                        <?php echo strtoupper( date_i18n( 'M', $date ) ); ?>
		                    </span>
		                <?php endif; ?>
	                    <div class="text">
	                        <h2><?php the_title(); ?></h2>
	                        <a href="<?php the_permalink(); ?>"><?php _e( '[ Read More ]', 'hillter' ); ?></a>
	                    </div>
	                </li>
	            <?php endwhile; wp_reset_postdata(); ?>
            </ul>

		<?php
		$output = ob_get_clean();
		return $output;
	}

}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_AWE_Event_Shortcode extends WPBakeryShortCode {

	}
}
