<?php

if ( class_exists( 'AWE_function' ) ) {


	class AWE_Check_Available_Form_Shortcode extends awe_shortcode {

		public function __construct() {
			$this->custom_shortcode( 'awe_check_available_form', array( $this, 'awe_render_html' ) );
			add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
		}

		public function awe_vc_shortcode() {
			vc_map( array(
				'name'	=> __( 'Awe Check Available Form', 'hillter' ),
				'base'	=> 'awe_check_available_form',
				'class'	=> '',
				'category'	=> __( 'Awe shortcode', 'hillter' ),
				'icon'	=> $this->icon( 'shortcode.png' ),
	            'description' => __( 'Display check available form', 'hillter' ),
				'params'	=> array(
					array(
						'type'	=> 'dropdown',
						'heading'	=> __( 'Enable Departure Date', 'hillter' ),
						'param_name'	=> 'to',
						'value'	=> array(
							__( 'Yes', 'awebooking' )	=> 'yes',
							__( 'No', 'awebooking' )	=> 'no',
						),
					),
					array(
						'type'	=> 'dropdown',
						'heading'	=> __( 'Enable Night Number', 'hillter' ),
						'param_name'	=> 'night',
						'value'	=> array(
							__( 'Yes', 'awebooking' )	=> 'yes',
							__( 'No', 'awebooking' )	=> 'no',
						),
					),
					array(
						'type'	=> 'dropdown',
						'heading'	=> __( 'Form layout', 'hillter' ),
						'param_name'	=> 'layout',
						'value'	=> array(
							__( 'Vertical', 'awebooking' )	=> 'vertical',
							__( 'Horizontal', 'awebooking' )	=> 'horizontal',
						),
					),

					array(
						'type'	=> 'dropdown',
						'heading'	=> __( 'Form style', 'hillter' ),
						'param_name'	=> 'style',
						'value'	=> array(
							__( 'Default', 'awebooking' )	=> 'default',
							__( 'Custom Hillter', 'awebooking' )	=> 'custom',
						),
					),
				),
			) );
		}

		public function awe_render_html( $atts, $content = '' ) {
			extract( shortcode_atts( array(
				'to'	=> 'yes',
				'night'	=> 'yes',
				'layout'	=> 'vertical',
				'style'	=> 'default',
			), $atts ) );

			ob_start();


			do_action( 'apb_get_day_advance' );
			?>
			<div class="awebooking-wrapper <?php echo 'horizontal' == $layout ? 'inline' : ''; ?> <?php echo "custom" == $style ? 'custom-hillter' : '';?>">

				<!-- SIDEBAR CONTENT -->
				<div class="apb-content">
					<form method="get" action="<?php echo esc_url( AWE_function::get_check_available_page() ); ?>" class="apb-single-check-avb-form">

						<div class="apb-field">
							<label><?php esc_html_e( 'Arrival Date', 'awebooking' ); ?></label>

							<div class="apb-field-group">
								<i class="apbf apbf-calendar"></i>
								<?php
								/**
								 * General input from date
								 */
								AWE_function::apb_gen_input( array(
									'type'          => 'text',
									'name'          => 'from',
									'placeholder'   => esc_attr__( 'Arrival Date', 'awebooking' ),
									'class'         => 'date-start-js apb-calendar apb-input',
								) );
								?>
							</div>
						</div>

						<?php if ( 'yes' == $night ) { ?>
							<div class="apb-field <?php echo 'horizontal' == $layout ? 'small' : ''; ?>">
								<label><?php esc_html_e( 'Nights', 'awebooking' ); ?></label>
								<div class="apb-field-group">
									<i class="apbf apbf-select"></i>
									<?php
									/**
									 * General selected total numner of night
									 */
									AWE_function::apb_get_option_to_selected( array(
										'default' => array(
											'label' => esc_attr__('Nights', 'awebooking'),
											'value' => ''
										),
										'name' => '',
										'count_num' => get_option( 'max_night' ),
										'data' => array(
											'class' => 'apb-select night-select-js',
										),
									) );
									?>
								</div>
							</div>
						<?php } ?>


						<?php
						if ( 'yes' == $to ) {
							?>
							<div class="apb-field">
								<label><?php esc_html_e( 'Departure Date', 'awebooking' ); ?></label>
								<div class="apb-field-group">
									<i class="apbf apbf-calendar"></i>
									<?php
									/**
									 * General input to date
									 */
									AWE_function::apb_gen_input( array(
										'type'          => 'text',
										'name'          => 'to',
										'placeholder'   => esc_attr__( 'Departure Date', 'awebooking' ),
										'class'         => 'date-end-js apb-calendar apb-input',
									) );
									?>
								</div>
							</div>
							<?php
						} else {
							echo '<input type="hidden" name="to" class="date-end-js">';
						}

						/*----------  Disnable/Enable div html by style.  ----------*/
						?>
						<div class="apb-field <?php echo 'horizontal' == $layout ? 'small' : ''; ?>">
							<label><?php esc_html_e( 'Adult', 'awebooking' ); ?></label>
							<div class="apb-field-group">
								<i class="apbf apbf-select"></i>
								<?php
								/**
								 * General selected number of maximum adult
								 */
								AWE_function::apb_get_option_to_selected( array(
									'default' => array(
										'label' => esc_attr__('Adult', 'awebooking'),
										'value' => ''
									),
									'name' => 'room_adult[]',
									'count_num' => get_option( 'max_adult' ),
									'data' => array(
										'class' => 'apb-select apb-adult-select',
									),
								) );
								?>
							</div>
						</div>
						<div class="apb-field <?php echo 'horizontal' == $layout ? 'small' : ''; ?>">
							<label><?php esc_html_e( 'Children', 'awebooking' ); ?></label>

							<div class="apb-field-group">
								<i class="apbf apbf-select"></i>
								<?php
								/**
								 * General selected number of maximum child
								 */
								AWE_function::apb_get_option_to_selected( array(
									'default' => array(
										'label' => esc_attr__('Children', 'awebooking'),
										'value' => ''
									),
									'name' => 'room_child[]',
									'start_num' => 0,
									'count_num' => get_option( 'max_child' ),
									'data' => array(
										'class' => 'apb-select apb-child-select',
									),
								) );
								?>
							</div>
						</div>
						<button type="submit" class="awe-btn apb-btn"><?php esc_html_e( 'MAKE RESERVATION', 'awebooking' ); ?></button>

						<input type="hidden" value="<?php echo absint( get_option( 'max_night' ) ); ?>" class="max-night-js">
						<input type="hidden" name="check_from" value="shortcode">

						<?php
						if ( defined( 'ICL_SITEPRESS_VERSION' ) ) {
							echo '<input type="hidden" name="lang" value="' . ICL_LANGUAGE_CODE . '">';
						}
						?>
					</form>
				</div>
				<!-- END / SIDEBAR CONTENT -->

			</div>
			<?php

			return ob_get_clean();

		}

	}

	if ( class_exists( 'WPBakeryShortCode' ) ) {
		class WPBakeryShortCode_AWE_Reservation_Form extends WPBakeryShortCode {

		}
	}

}
