<?php
/**
 * Awe catalogue 2 shortcode
 *
 * @package Hillter
 */

/**
 * Class AWE_Catalogue2_Shortcode
 */
class AWE_Catalogue2_Shortcode extends awe_shortcode {

	/**
	 * Shortcode name.
	 *
	 * @var string
	 */
	protected $shortcode_name = 'awe_catalogue2';


	/**
	 * Constructor.
	 */
	public function __construct() {
		$this->custom_shortcode( $this->shortcode_name, array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}


	/**
	 * Map shortcode.
	 */
	public function awe_vc_shortcode() {
		vc_map( array(
			'name'        => __( 'Awe Catalogue 2', 'hillter' ),
			'base'        => $this->shortcode_name,
			'class'       => '',
			'category'    => __( 'Awe shortcode', 'hillter' ),
			'icon'        => $this->icon( 'shortcode.png' ),
			'description' => __( 'Display food catalogue.', 'hillter' ),
			'params'      => array(
				array(
					'type'       => 'dropdown',
					'heading'    => __( 'Catalogue Style', 'hillter' ),
					'param_name' => 'style',
					'value'      => array(
						__( 'Small thumbnail', 'hillter' )     => 'small',
						__( 'Large thumbnail', 'hillter' )     => 'large',
						__( 'Tabs no thumbnail', 'hillter' )   => 'tabs',
						__( 'Tabs with thumbnail', 'hillter' ) => 'tabs-thumb',
					),
				),
				array(
					'type'       => 'param_group',
					'heading'    => __( 'Catalogues', 'hillter' ),
					'param_name' => 'list',
					'params'     => array(
						array(
							'type'       => 'attach_image',
							'heading'    => __( 'Image', 'hillter' ),
							'param_name' => 'image',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Title', 'hillter' ),
							'param_name' => 'title',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Description', 'hillter' ),
							'param_name' => 'desc',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Price', 'hillter' ),
							'param_name' => 'price',
						),
						array(
							'type'       => 'textfield',
							'heading'    => __( 'Sale price', 'hillter' ),
							'param_name' => 'sale_price',
						),
					),
				),
			),
		) );
	}


	/**
	 * Render shortcode.
	 *
	 * @param  array  $atts    Shortcode attributes.
	 * @param  string $content Content.
	 * @return string
	 */
	public function awe_render_html( $atts, $content = '' ) {
		$atts = shortcode_atts( array(
			'list'	=> '',
			'style'	=> 'small',
		), $atts );

		$list = vc_param_group_parse_atts( $atts['list'] );

		if ( empty( $list ) ) {
			return '';
		}

		switch ( $atts['style'] ) {
			case 'large':
				$item_class = 'large-thumbs';
				break;

			case 'restaurant-tabs':
				$item_class = 'small-thumbs';
				break;

			default:
				$item_class = 'small-thumbs';
		}

		ob_start();
		?>
		<div class="restaurant_content">
			<?php
			foreach ( $list as $item ) {
				$image = isset( $item['image'] ) ? wp_get_attachment_image_src( $item['image'], 'awe-gallery-rectangular' ) : '';
				?>
				<div class="restaurant_item <?php echo esc_attr( $item_class ); ?>">
					<?php if ( 'tabs' != $atts['style'] && $image ) : ?>
						<div class="img">
							<a href="#"><img src="<?php echo esc_url( $image[0] ); ?>" alt=""></a>
						</div>
					<?php endif; ?>

					<div class="text">
						<?php if ( ! empty( $item['title'] ) ) : ?>
							<h2><?php echo esc_html( $item['title'] ); ?></h2>
						<?php endif; ?>

						<?php if ( ! empty( $item['desc'] ) ) : ?>
							<p class="desc"><?php echo nl2br( esc_html( $item['desc'] ) ) ?></p>
						<?php endif; ?>

						<?php if ( ! empty( $item['price'] ) ) : ?>
							<p class="price">
								<?php if ( empty( $item['sale_price'] ) ) : ?>
									<span class="amout"><?php echo esc_html( $item['price'] ); ?></span>
								<?php else : ?>
									<ins><span class="amout"><?php echo esc_html( $item['sale_price'] ); ?></span></ins>
									<del><span class="amout"><?php echo esc_html( $item['price'] ); ?></span></del>
								<?php endif; ?>
							</p>
						<?php endif; ?>
					</div>
				</div>
				<?php
			}
			?>
		</div>
		<?php
		return ob_get_clean();
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_AWE_Catalogue2_Shortcode extends WPBakeryShortCode {

	}
}
