<?php

class AWE_Catalogue_Shortcode extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_catalogue', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		vc_map( array(
			'name'	=> __( 'Awe Catalogue', 'hillter' ),
			'base'	=> 'awe_catalogue',
			'class'	=> '',
			'category'	=> __( 'Awe shortcode', 'hillter' ),
			'icon'	=> $this->icon( 'shortcode.png' ),
			'description' => __( 'Display food catalogue.', 'hillter' ),
			'params'	=> array(
				array(
					'type' => 'param_catalogue',
					'heading' => __( '', 'hillter' ),
					'param_name' => 'list',
					'value' => '',
					'group' => 'List Item',
					'holder'	=> 'div',
					'class'	=> 'Awe_meta_id',
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Catalogue Style', 'hillter' ),
					'param_name' => 'style',
					'value' => array(
						__( 'Small thumbnail', 'hillter' )	=> 'small',
						__( 'Large thumbnail', 'hillter' )	=> 'large',
						__( 'Tabs no thumbnail', 'hillter' )	=> 'tabs',
						__( 'Tabs with thumbnail', 'hillter' )	=> 'tabs-thumb',
					),
					'group' => 'Setting',
				),
			),
			'deprecated' => '1.10',
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {

		extract(shortcode_atts( array(
			'list'	=> '',
			'style'	=> 'small'
		), $atts ));

		global $wpdb;
		$result = $wpdb->get_var( $wpdb->prepare( "SELECT `meta_value` FROM $wpdb->postmeta WHERE meta_id = %d", absint( $list ) ) );
		parse_str( trim($result), $arr );

		$wrap_class = '';
		$item_class = '';

		if ( $style == 'large' ) {
			// $wrap_class = 'restaurant-lager';
			$item_class = 'lager-thumbs';
		} elseif ( $style  == 'tabs' ) {
			$wrap_class = 'restaurant-tabs';
		} elseif ( $style  == 'tabs-thumb' ) {
			$wrap_class = 'restaurant-tabs';
			$item_class = 'small-thumbs';
		} else {
			// $wrap_class = 'restaurant-small';
			$item_class = 'small-thumbs';
		}

		ob_start();

		// echo '<div class="' . esc_attr( $wrap_class ) . '">';

		echo '<div class="restaurant_content">';

		if ( count( $arr ) > 0 ) {
			?>

                <?php
                foreach ( $arr as $item ) :
                	$image = isset( $item['image'] ) ? wp_get_attachment_image_src( $item['image'], 'awe-gallery-rectangular' ) : '';
                ?>

	                <!-- ITEM -->
	                <div class="restaurant_item <?php echo esc_attr( $item_class ); ?>">

	                	<?php if ( $style  != 'tabs' && $image ) : ?>
		                    <div class="img">
		                        <a href="#"><img src="<?php echo esc_url( $image[0] ); ?>" alt=""></a>
		                    </div>
		                <?php endif; ?>

	                    <div class="text">
	                        <h2><?php echo esc_html( $item['title'] ); ?></h2>

	                        <p class="desc"><?php echo nl2br( esc_html( $item['description'] ) ) ?></p>

	                        <p class="price">
	                        	<?php if ( ! $item['price-sale'] ) : ?>
	                            	<span class="amout"><?php echo esc_html( $item['price'] ); ?></span>
	                            <?php else : ?>
                                    <ins><span class="amout"><?php echo esc_html( $item['price-sale'] ); ?></span></ins>
                                    <del><span class="amout"><?php echo esc_html( $item['price'] ); ?></span></del>
	                            <?php endif; ?>
	                        </p>
	                    </div>

	                </div>
	                <!-- END / ITEM -->
	            <?php endforeach; ?>

			<?php
		} else {
			echo '<p>' . esc_html__( 'No item found', 'hillter' ) . '</p>';
		}

		echo '</div>';

		$output = ob_get_clean();
		return $output;

	}

}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_AWE_Catalogue_Shortcode extends WPBakeryShortCode {

	}
}
