<?php
/**
 * Awe button shortcode
 *
 * @package Hillter
 */

/**
 * Class AWE_Button_Shortcode
 */
class AWE_Button_Shortcode extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_button', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}


	public function awe_vc_shortcode() {
		vc_map( array(
			'name'	      => __( 'Awe Button', 'hillter' ),
			'base'	      => 'awe_button',
			'category'	  => __( 'Awe shortcode', 'hillter' ),
			'icon'	      => $this->icon( 'shortcode.png' ),
			'description' => __( 'Display button.', 'hillter' ),
			'params'	  => array(
				array(
					'type'        => 'textfield',
					'heading'     => __( 'Button Label', 'hillter' ),
					'param_name'  => 'button_content',
					'holder'      => 'div',
					'description' => 'This is the text that appears on your button.',
				),
				array(
					'type'        => 'vc_link',
					'heading'     => __( 'Button Link', 'hillter' ),
					'param_name'  => 'link',
					'description' => 'Where should your button link to?',
				),
				array(
					'type'        => 'dropdown',
					'heading'     => __( 'Button Style', 'hillter' ),
					'param_name'  => 'style',
					'value'       => array(
						__( 'Background color (Default)', 'hillter' ) => 'default',
						__( 'Outline', 'hillter' )                    => 'outline',
					),
					'description' => 'Set style to your button.',
				),
				array(
					'type'        => 'dropdown',
					'heading'     => __( 'Button Size', 'hillter' ),
					'param_name'  => 'size',
					'value'       => array(
						__( 'Normal (Default)', 'hillter' ) => 'normal',
						__( 'Medium', 'hillter' )           => 'medium',
						__( 'Large', 'hillter' )            => 'large',
					),
					'description' => 'Set dimension to your button.',
				),
				array(
					'type'        => 'dropdown',
					'heading'     => __( 'Button Alignment', 'hillter' ),
					'param_name'  => 'align',
					'value'       => array(
						__( 'Inline', 'hillter' ) => 'inline',
						__( 'Left', 'hillter' )   => 'left',
						__( 'Right', 'hillter' )  => 'right',
						__( 'Center', 'hillter' ) => 'center',
					),
					'description' => 'Align your button.',
				),
				array(
					'type'        => 'checkbox',
					'heading'     => __( 'Set Fullwidth Button', 'hillter' ),
					'param_name'  => 'fullwidth_btn',
					'dependency'  => array(
						'element' => 'align',
						'value'   => array( 'left', 'right', 'center' ),
					),
					'description' => 'Switch your button to fullwith mode.',
				),
				array(
					'type'        => 'colorpicker',
					'heading'     => __( 'Button Color', 'hillter' ),
					'param_name'  => 'color',
					'description' => 'Display your button with your custom color.',
				),
			),
		) );
	}


	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array(
			'link'	=> '',
			'style'	=> 'default',
			'size'	=> 'normal',
			'align'	=> 'inline',
			'fullwidth_btn'	=> '',
			'color'	=> '',
			'button_content' => '',
		), $atts ) );

		// Link.
		$link_url = '';
		$link_title = '';
		if ( $link ) {
			$link = vc_build_link( $link );

			$link_url = $link['url'];
			$link_title = $link['title'];
		}

		// Style.
		$extra = '';
		$style = in_array( $style, array( 'default', 'outline' ) ) ? $style : 'default';
		if ( 'default' === $style ) {
			$extra .= ' style="background-color:' . $color . ';border-color:' . $color . '"';
		} else {
			$extra .= ' style="color:' . $color . ';border-color:' . $color . ';"';
		}

		// Size.
		$size = in_array( $size, array( 'normal', 'medium', 'large' ) ) ? $size : 'normal';

		$button_class = 'awe-btn';
		$button_class .= ' awe-btn-' . $size;
		$button_class .= ' awe-btn-' . $style;

		if ( $fullwidth_btn ) {
			$button_class .= ' awe-btn-full';
		}

		if ( ! empty( $link[2] ) && $link_url ) {
			$extra .= ' target="_blank"';
		}

		if ( $link_url ) {
			$output = '<a class="' . esc_attr( $button_class ) . '" href="' . esc_url( $link_url ) . '" title="' . esc_attr( $link_title ) . '"' . $extra . '>' . esc_html( $button_content ) . '</a>';
		} else {
			$output = '<button class="' . esc_attr( $button_class ) . '"' . $extra . '>' . esc_html( $button_content ) . '</button>';
		}

		$output = '<div class="awe-btn-container awe-btn-' . esc_attr( $align ) . '">' . $output  . '</div>';

		return $output;
	}
}


if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_AWE_Button extends WPBakeryShortCode {

	}
}
