<?php
/**
 * Awe banner shortcode
 *
 * @package Hillter
 */

class awe_hillter_banner extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_hillter_banner', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		vc_map( array(
			'name'                    => __( 'Awe Banner', 'hillter' ),
			'base'                    => 'awe_hillter_banner',
			'content_element'         => true,
			'wrapper_class'           => '',
			'class'                   => 'awe_shortcode',
			'show_settings_on_create' => true,
			'category'                => __( 'Awe shortcode', 'hillter' ),
			'icon'                    => $this->icon( 'shortcode.png' ),
			'description'             => __( 'Display single i.', 'hillter' ),
			'params'                  => array(
				array(
					'type'       => 'textfield',
					'heading'    => __( 'Banner Title', 'hillter' ),
					'param_name' => 'title',
					'value'      => __( 'Banner Title', 'hillter' ),
				),
				array(
					'type'       => 'attach_image',
					'heading'    => __( 'Banner Background Image', 'hillter' ),
					'param_name' => 'banner_image',

				),
				array(
					'type'       => 'vc_link',
					'heading'    => __( 'Banner Button', 'hillter' ),
					'param_name' => 'banner_button',
					'value'      => __( '#', 'hillter' ),
				),
				array(
					'type'       => 'textfield',
					'heading'    => __( 'Button Text', 'hillter' ),
					'param_name' => 'banner_button_text',
					'value'      => __( 'Button', 'hillter' ),
				),
			),
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {
		$atts = shortcode_atts( array(
			'title'              => '',
			'banner_image'       => '',
			'banner_button'      => '',
			'banner_button_text' => '',
		), $atts );

		if ( empty( $atts['banner_image'] ) ) {
			return '';
		}

		$image_src = wp_get_attachment_image_src( $atts['banner_image'], 'full' );
		ob_start();
		?>
		<div class="event-item">
			<div class="img">
				<img src="<?php echo esc_url( $image_src[0] ); ?>" alt="<?php echo esc_attr( $atts['title'] ); ?>">
			</div>
			<div class="text">
				<div class="text-cn">
					<?php if ( ! empty( $atts['title'] ) ) : ?>
						<h2><?php echo esc_html( $atts['title'] ); ?></h2>
					<?php endif; ?>

					<?php
					if ( ! empty( $atts['banner_button'] ) ) {
						$link = vc_build_link( $atts['banner_button'] );

						if ( ! empty( $link['title'] ) ) {
							printf(
								'<a href="%s" title="%s" %s>%s</a>',
								! empty( $link['url'] ) ? esc_url( $link['url'] ) : '#',
								esc_attr( $link['title'] ),
								! empty( $link['target'] ) ? 'target="' . esc_attr( trim( $link['target'] ) ) . '"' : '',
								esc_html( $link['title'] )
							);
						}
					}
					?>
				</div>
			</div>
		</div>
		<?php
		return ob_get_clean();
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_awe_hillter_banner extends WPBakeryShortCode {

	}

}
