<?php

class awe_hillter_animate_number extends awe_shortcode {
	public function __construct() {
		$this->custom_shortcode( 'awe_hillter_animate_number', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}

	public function awe_vc_shortcode() {
		vc_map( array(
			"name"                    => __( "Animate Number", 'hillter' ),
			"base"                    => "awe_hillter_animate_number",
			"content_element"         => true,
			"wrapper_class"           => "",
			"class"                   => "awe_shortcode",
			"show_settings_on_create" => true,
			"category"                => __( "Awe shortcode", 'hillter' ),
			"icon"                    => $this->icon( 'shortcode.png' ),
			'description' 			  => __( 'Transform of number.', 'hillter' ),
			"params"                  => array(
				array(
					"type"       => "textfield",
					"heading"    => __( "Heading Text", 'hillter' ),
					"param_name" => "text",
					"value"      => __( "Guest Stay", 'hillter' ),
				),
				array(
					"type"       => "textfield",
					"heading"    => __( "Number", 'hillter' ),
					"param_name" => "number",
					"value"      => 768
				)
			),
		) );
	}

	public function awe_render_html( $atts, $content = '' ) {

		extract( shortcode_atts( array(
			'number' => '',
			'text'	=> '',
		), $atts ) );
		ob_start();
		?>
		<div class="statistics_item">
			<span class="count"><?php print $number; ?></span>
			<?php if ( $text ) echo '<span>' . esc_html( $text ) . '</span>'; ?>
		</div>
		<?php
		return ob_get_clean();
	}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_awe_hillter_animate_number extends WPBakeryShortCode {
	}
}
