<?php

class AWE_Button_Alert extends awe_shortcode {

	public function __construct() {
		$this->custom_shortcode( 'awe_alert', array( $this, 'awe_render_html' ) );
		add_action( 'vc_before_init', array( $this, 'awe_vc_shortcode' ) );
	}


	public function awe_vc_shortcode() {
		vc_map( array(
			'name'	=> __( 'Awe Alert', 'hillter' ),
			'base'	=> 'awe_alert',
			'category'	=> __( 'Awe shortcode', 'hillter' ),
			'icon'	=> $this->icon('shortcode.png'),
            'description' => __( 'Display alert info.', 'hillter' ),
			'params'	=> array(
				array(
					'type'	=> 'textarea',
					'heading'	=> __( 'Alert text', 'hillter' ),
					'param_name'	=> 'alert_content',
					// 'holder'	=> 'div',
				),
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Alert type', 'hillter' ),
					'param_name'	=> 'type',
					'value'	=> array(
						__( 'Success', 'hillter' )	=> 'success',
						__( 'Info', 'hillter' )	=> 'info',
						__( 'Warning', 'hillter' )		=> 'warning',
						__( 'Danger', 'hillter' )	=> 'danger',
					),
				),
			)
		) );
	}


	public function awe_render_html( $atts, $content = '' ) {
		extract( shortcode_atts( array( 'type' => 'success','alert_content' => '' ), $atts ) );
		$output = '';
		if ( $alert_content ) {
			$output = '<p class="alert alert-' . esc_attr( $type ) . '">' . esc_textarea( $alert_content ) . '</p>';
		}

		return $output;
	}

}


if ( class_exists( 'WPBakeryShortCode' ) ) {

	class WPBakeryShortCode_AWE_Alert extends WPBakeryShortCode {

	}

}
