<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly



vc_add_shortcode_param( 'param_iconlist', 'awe_iconlist_field', get_template_directory_uri() . '/awe_shortcode/assets/js/params.js' );

function awe_iconlist_field( $settings, $value ) {


	$dependency = '';
	$meta_id = absint( $value );
	$li = '';
	$hide_addnew = '';
	if ( $meta_id > 0 ) {

		global $wpdb;
		$result = $wpdb->get_var( $wpdb->prepare( "SELECT `meta_value` FROM $wpdb->postmeta WHERE meta_id = %d", absint( $meta_id ) ) );



		parse_str( trim($result), $list );


		$list_size = count( $list );
		if ( trim( $result ) != "" && is_array( $list ) && $list_size > 0 ) {
			$count = 0;
			foreach ( $list as $item ) {
				$count++;


				/*
				 * @Value
				 */
				$icon = isset( $item['icon'] ) ?  $item['icon'] : '';
				$text = isset( $item['text'] ) ? esc_html( $item['text'] ) : '';

				/*
				 * @Head title
				 */
				$head_name = ($text  == '') ? "Item {$count}" : $text;

				/*
				 * @Render html
				 */
				$li .= "<li data-id='{$count}'>
				<div class='widget'>
					<div class='widget-top'>
					<div class='widget-title-action'>
						<a class='cmd cmd-edit' title='Edit'><i class='fa fa-pencil'></i></a>
						<a class='cmd cmd-copy' title='Copy'><i class='fa fa-files-o'></i></a>
						<a class='cmd cmd-remove' title='Remove'><i class='fa fa-trash-o'></i></a>
					</div>
					<div class='widget-title ui-sortable-handle'><h4 class='cmd-edit'>{$head_name}</h4></div>
					</div>
					<div class='widget-inside'>
						<table>
							<tr>
								<td>
									<a href='#' class='awe-icon awe-icon-upload'><span class='{$icon}'></span></a>
									<input class='icon vc_input' type='hidden' name='{$count}[icon]' value='{$icon}'/>
								</td>
								<td>
									<input class='text vc_input small' name='{$count}[text]' type='text' placeholder='Item title' value='{$text}'>
								</td>
							</tr>
						</table>
					</div>
				</div>
			</li>";
			}
		} else {
			$hide_addnew = 'hide';
			$li = "<li class='empty'>" . __( 'List is empty', 'hillter' ) . "<a href='#' class='new-item'>" . __( 'Add item', 'hillter' ) . "</a></li>";
		}
	} else {
		$hide_addnew = 'hide';
		$li = "<li class='empty'>" . __( 'List is empty', 'hillter' ) . "<a href='#' class='new-item'>" . __( 'Add item', 'hillter' ) . "</a></li>";
	}
	$param_name = esc_attr( $settings["param_name"] );
	$type = esc_attr( $settings['type'] );

	return "<div class='Awe_param iconlist awe_param_field saveajax' data-meta_key='iconlist'>
				<ul>{$li}</ul>
				<a href='#' class='new-bottom new-item {$hide_addnew}'><i class='fa fa-plus'></i>Add item</a>
				<input name='{$param_name}' class='Awe_param_hidden wpb_vc_param_value wpb-textinput {$param_name}  {$type}_field' type='hidden' value='{$meta_id}' {$dependency} />
		   </div>"; // New button element
}





?>
