<?php

if ( !defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly



vc_add_shortcode_param( 'awe_param_gmap', 'awe_param_gmap_field', get_template_directory_uri() . '/awe_shortcode/assets/js/param-gmap.js' );

function awe_param_gmap_field( $settings, $value ) {
	$param_name = esc_attr( $settings["param_name"] );

	$map = array(
		'location' => '',
		'latlong' => '',
		'zoom' => ''
	);

	if ( $value != 'EMPTY' ) {
		parse_str( urldecode( $value ), $mapdata );
		$map = array_merge( $map, $mapdata );
	}



	return "<div class='Awe_param gmap'>
				<input type='text' class='Awe_search_map vc_input' name='location' placeholder='Search location...' value='" . esc_attr( $map['location'] ) . "' />
				<div class='Awe_show_map'></div>
				<input type='hidden' class='vc_input Awe_map_latlong' name='latlong' value='" . esc_attr( $map['latlong'] ) . "' />
				<input type='hidden' class='vc_input Awe_map_zoom' name='zoom' value='" . esc_attr( $map['zoom'] ) . "' />
				<input name='{$param_name}' class='Awe_param_hidden wpb_vc_param_value wpb-textinput {$param_name} {$settings['type']}_field' type='hidden' value='" . esc_attr( $value ) . "' />
			</div>";
}

?>
