<?php

if ( class_exists( 'Vc_Manager' ) ) :
	if ( in_array( 'js_composer/js_composer.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

		vc_add_shortcode_param( 'param_catalogue', 'awe_catalogue_field' );

		function awe_catalogue_field( $settings, $value ) {
			$dependency = '';
			$meta_id = absint( $value );
			$li = '';
			$hide_addnew = '';
			if ( $meta_id > 0 ) {

				global $wpdb;
				$result = $wpdb->get_var( $wpdb->prepare( "SELECT `meta_value` FROM $wpdb->postmeta WHERE meta_id = %d", absint( $meta_id ) ) );

				parse_str( trim($result), $list );


				$list_size = count( $list );
				if ( trim( $result ) != "" && is_array( $list ) && $list_size > 0 ) {
					$count = 0;
					foreach ( $list as $item ) {
						$count++;
						/*
						 * @Value
						 */
						$image = isset( $item['image'] ) ?  $item['image'] : '';
						$title = isset( $item['title'] ) ? esc_html( $item['title'] ) : '';
						$price = isset( $item['price'] ) ? esc_html( $item['price'] ) : '';
						$price_sale = isset( $item['price-sale'] ) ? ( $item['price-sale'] ) : '';
						$description = isset( $item['description'] ) ? esc_textarea( $item['description'] ) : '';


						/*
						 * @Image
						 */
						$image_arr = wp_get_attachment_image_src( $image, 'thumbnail' );
						$background = ($image == '') ? '' : "style='background:url({$image_arr[0]})'";
						$has_thumb = ($image == '') ? '' : 'has-thumb';

						/*
						 * @Head title
						 */
						$head_name = ($title  == '') ? "Catalogue {$title} {$count}" : $item['title'];

						/*
						 * @Render html
						 */
						$li .= "<li data-id='{$count}'>
						<div class='widget'>
							<div class='widget-top'>
							<div class='widget-title-action'>
								<a class='cmd cmd-edit' title='Edit'><i class='fa fa-pencil'></i></a>
								<a class='cmd cmd-copy' title='Copy'><i class='fa fa-files-o'></i></a>
								<a class='cmd cmd-remove' title='Remove'><i class='fa fa-trash-o'></i></a>
							</div>
							<div class='widget-title ui-sortable-handle'><h4 class='cmd-edit'>{$head_name}</h4></div>
							</div>
							<div class='widget-inside'>
								<table>
									<tr>
										<td>
											<a href='#' class='thumbnail awe-thumbnail {$has_thumb}' {$background}><span>Edit</span></a>
											<input class='image vc_input' type='hidden' name='{$count}[image]' value='{$image}'/>
										</td>
										<td>
											<input class='title vc_input small' name='{$count}[title]' type='text' placeholder='Title' value='{$title}'>
											<textarea class='description vc_input' name='{$count}[description]' placeholder='Description'>{$description}</textarea>
											<input class='price vc_input small' name='{$count}[price]' type='text' placeholder='Price' value='{$price}'>
											<input class='price-sale vc_input small' name='{$count}[price-sale]' type='url' placeholder='Price sale' value='{$price_sale}'>
										</td>
									</tr>
								</table>
							</div>
						</div>
					</li>";
					}
				} else {
					$hide_addnew = 'hide';
					$li = "<li class='empty'>" . __( 'List is empty', 'hillter' ) . "<a href='#' class='new-item'>" . __( 'Add item', 'hillter' ) . "</a></li>";
				}
			} else {
				$hide_addnew = 'hide';
				$li = "<li class='empty'>" . __( 'List is empty', 'hillter' ) . "<a href='#' class='new-item'>" . __( 'Add item', 'hillter' ) . "</a></li>";
			}
			$param_name = esc_attr( $settings["param_name"] );
			$type = esc_attr( $settings['type'] );

			return "<div class='Awe_param catalogue awe_param_field saveajax' data-meta_key='catalogue'>
						<ul>{$li}</ul>
						<a href='#' class='new-bottom new-item {$hide_addnew}'><i class='fa fa-plus'></i>Adding item</a>
						<input name='{$param_name}' class='Awe_param_hidden wpb_vc_param_value wpb-textinput {$param_name}  {$type}_field' type='hidden' value='{$meta_id}' {$dependency} />
				   </div>"; // New button element
		}

	}
endif;
?>
