<?php

vc_add_shortcode_param( 'param_carousel', 'awe_images_field' );

function awe_awe_images_field( $settings, $value ) {
	$dependency = '';
	$val = esc_attr( $value );
	$li = '';
	$hide_addnew = '';
	if ( $val != 'EMPTY' && $val != '' ) {
		parse_str( urldecode( $value ), $list );
		if ( is_array( $list ) && count( $list ) > 0 ) {
			$count = 0;
			foreach ( $list as $item ) {
				$count++;
				$image_arr = wp_get_attachment_image_src( $item['image'], 'thumbnail' );
				$image = $item['image'] == '' ? '' : "style='background:url({$image_arr[0]})'";
				$checked = $item['open_newtab'] == 'on' ? 'checked' : '';
				$has_thumb = $item['image'] == '' ? '' : 'has-thumb';
				$li.="<li data-id='{$count}'>
					<a href='#' class='thumbnail awe-thumbnail {$has_thumb}' {$image}><span>Edit</span></a>
					<input class='vc_input' type='hidden' name='{$count}[image]' value='{$item['image']}'/>
					<div class='right'>
						<input class='link vc_input' name='{$count}[link]' type='url' placeholder='http://example.com' value='{$item['link']}'/>
						<label class='open_newtab'><input name='{$count}[open_newtab]' type='checkbox' class='vc_input' {$checked} />" . __( 'Open in new tab', 'hillter' ) . "</label>
						<a href='#' class='remove cmd-remove'>Remove</a>
					</div>
				</li>";
			}
		}
	} else {
		$hide_addnew = 'hide';
		$li = "<li class='empty'>" . __( 'List is empty', 'hillter' ) . "<a href='#' class='new-item'>" . __( 'Add item', 'hillter' ) . "</a></li>";
	}
	$param_name = esc_attr( $settings["param_name"] );
	$type = esc_attr( $settings['type'] );
	return "<div class='awe_param_field awe_param_carousel'>
			<ul>
				{$li}
			</ul>
			<a href='#' class='new-bottom new-item {$hide_addnew}'><i class='fa fa-plus'></i>Add item</a>
			<input name='{$param_name}' class='awe_param_input_target wpb_vc_param_value wpb-textinput {$param_name}  {$type}_field' type='hidden' value='{$val}' {$dependency} />
		   </div>"; // New button element
}
