<?php
if (class_exists('Vc_Manager')) :
    if (in_array('js_composer/js_composer.php', apply_filters('active_plugins', get_option('active_plugins')))) {
        function add_custum_shortcode_param($name, $form_field_callback, $script_url = null)
        {
            return WpbakeryShortcodeParams::addField($name, $form_field_callback, $script_url);
        }

        /**
         *
         * Hillter Custom Params
         * @package Visual Composer
         * @author Kai
         * @since 1.0.0
         * @return HTML
         */

        vc_add_shortcode_param('social', 'awe_social_setting_field', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');
        function awe_social_setting_field($settings, $value)
        {
            parse_str(urldecode($value), $social_value);
            $socials = array(
                'facebook' => 'facebook',
                'google' => 'google-plus',
                'twitter' => 'twitter',
                'github' => 'github',
                'instagram' => 'instagram',
                'pinterest' => 'pinterest',
                'linkedin' => 'linkedin',
                'skype' => 'skype',
                'tumblr' => 'tumblr',
                'youtube' => 'youtube',
                'vimeo-square' => 'vimeo-square',
                'flickr' => 'flickr',
                'dribbble' => 'dribbble',
            );
            ob_start();
            ?>
            <style>
                .sc-social-icon a {
                    font-size: 12px;
                    display: inline-block;
                    border: 2px solid #898989;
                    color: #898989;
                    width: 24px;
                    height: 24px;
                    line-height: 22px;
                    margin: 0px 4px;
                    border-radius: 100%;
                    text-align: center;
                    transition: all 0.2s ease 0s;
                }
                .sc-social-icon .active {
                    border: 2px solid #2795D1;
                }
            </style>
            <div class="sc-social-icon">
                <?php foreach ($socials as $item) {
                    $current = (isset($social_value[$item])) ? $social_value[$item] : "";
                    $active = ($current!="") ? ' class="active"' : "" ;
                    echo '<a data-popup="' . esc_attr($item) . '" href="#"'.$active.'><i class="fa fa-' . esc_attr($item) . '"></i></a>';
                } ?>
            </div>
            <div class="sc-social-value">
                <?php foreach ($socials as $item) {
                    $current = (isset($social_value[$item])) ? $social_value[$item] : "";
                    echo '<p class="js-icon js-select-' . esc_attr($item) . ' hidden">';
                    echo '<label><strong>' . ucfirst($item) . '</strong></label>';
                    echo '<input type="text" class="wpb_vc_param_value wpb-textinput social-value" name="' . esc_attr($item) . '" value="'.esc_attr($current).'">';
                    echo '</p>';
                }
                ?>
            </div>
            <?php
            echo '<input name="' . esc_attr($settings['param_name']) . '" class="social-total-value wpb_vc_param_value wpb-textinput ' .
                esc_attr($settings['param_name']) . ' ' .
                esc_attr($settings['type']) . '_field" type="hidden" value="' . esc_attr($value) . '" />';
            $output = ob_get_clean(); // Get finally HTML to show
            return $output;
            ?>
        <?php
        }


        add_custum_shortcode_param('menu_drag_drop', 'awe_menu_drag_drop_field', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_menu_drag_drop_field($settings, $value)
        {
            $dependency = '';
            $li = $bvalue = '';
            $menu = new WP_Query(array('post_type' => $settings["post_type"], 'posts_per_page' => -1));
            if ($menu->have_posts()) {
                while ($menu->have_posts()) {
                    $menu->the_post();
                    $bvalue .= get_the_ID() . ',';
                }
	            wp_reset_postdata();
            }
            $sort = awe_merge_post_array($value, $bvalue);
            $value = '';
            foreach ($sort as $key) {
                if ($key != '') {
                    $li .= '<li data-id="' . $key . '">' . get_the_title($key) . '</li>';
                    $value .= $key . ',';
                }

            }

            $html = '<div class="menu-sort">';
            if ($li == '') {
                $html .= '<p>' . __('Please add post!', 'hillter') . '</p>';
            } else {
                $html .= '<ul class="awe-sortable">';
                $html .= $li;
                $html .= '</ul>';
            }
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-sortable-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $value . '" ' . $dependency . '>';
            $html .= '</div>';
            return $html;
        }

        // chose social icon and link
        add_custum_shortcode_param('social_upload', 'awe_vc_social', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');
        function awe_vc_social($settings, $value)
        {
            $dependency = '';
            $val = $value;
            $html = '<div class="awe_add_social">';

            parse_str(urldecode($value), $social);
            if (is_array($social)) {
                $i = 1;
                foreach ($social as $key => $value) {
                    $html .= '<div class="social-item" data-item="' . $i . '">';
                    $html .= '<input class="awe-input" name="' . $i . '[link]" value="' . $value['link'] . '" type="text" >';
                    $html .= '<span class="awe-change-icon"><i class="mdicon ' . $value['icon'] . '"></i>';
                    $html .= '<input class="awe-input" name="' . $i . '[icon]" value="' . $value['icon'] . '" type="hidden" >';
                    $html .= '</span>';
                    $html .= '<a href="#" class="awe-del-social">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<div class="awe-add"><button class="awe-button-add" type="button">' . __('Add social', 'hillter') . ' </button></div>';
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-social-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $val . '" ' . $dependency . '>';
            return $html;
        }

        add_custum_shortcode_param('awe_icon', 'awe_vc_icon', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_vc_icon($settings, $value)
        {
            if ($value == "") {
                $val = "fa fa-plus";
            } else {
                $val = $value;
            }
            return '<div class="my_param_block">'
            . '<span class="awe-change-icon"><i class="mdicon ' . $val . '"></i>'
            . '<input name="' . esc_attr($settings['param_name']) . '" class="awe-input wpb_vc_param_value wpb-textinput ' .
            esc_attr($settings['param_name']) . ' ' .
            esc_attr($settings['type']) . '_field" type="hidden" value="' . esc_attr($value) . '" />' .
            '</div>';
        }


        /*
         * Dev: Ha
         * Custom type shortcode
         */

        /*
         * Shortcode type load product
         */
        add_custum_shortcode_param('awe_load_product', 'awe_vc_load_product', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_vc_load_product($settings, $value)
        {
            $dependency = '';
            $val = $value;
            parse_str(urldecode($value), $data);
            $p = get_posts(array('post_type' => 'product', 'numberposts' => "9999"));

            ob_start();
            ?>
            <style>
                .select-product:hover {
                    color: blue;
                }

                .list-product {
                    border: 1px solid #ddd;
                    padding-left: 10px;
                }

                .tag-product {
                    padding-bottom: 5px;
                }

                .del-tag a {
                    color: white;
                    font-weight: bold;
                    text-decoration: none;
                }

                .awe-tag-product {
                    background: none repeat scroll 0 0 #00aef0;
                    border-radius: 5px;
                    color: white;
                    display: inline-block;
                    padding: 4px;
                    margin-right: 1px;
                    margin-top: 1px;
                }

                .check {
                    color: #dedede;
                    cursor: not-allowed;
                }

                .select-product {
                    cursor: pointer;
                }
            </style>
            <div class="edit_form_line">
                <div class="tag-product" style="max-height: 50px; overflow: auto; ">
                    <?php
                    if (is_array($data)) {
                        $i = 1;
                        $j = 1;
                        foreach ($data as $key => $value) {
                            $ids[] = $value['post_id'];
                            $product = get_post($value['post_id']);
                            ?>
                            <div class="awe-tag-product" data-item="<?php echo intval($i++); ?>">
                                <span><?php echo esc_html($product->post_title); ?> </span>
                                <input class="awe-input" type="hidden"
                                       value="<?php echo esc_attr($value['post_id']); ?>"
                                       name="<?php echo sprintf('%s', $j++ . '[post_id]'); ?>">
                                <span class="del-tag" data-id="<?php echo esc_attr($value['post_id']); ?>"><a
                                        href="#"><i class="fa fa-trash"></i></a></span>
                            </div>
                        <?php
                        }
                    }
                    ?>
                </div>
                <div class="list-product" style="max-height: 100px; overflow: auto; ">
                    <ul>
                        <?php foreach ($p as $item) {

                            echo '<li class="';
                            if (isset($ids)) {
                                if (in_array($item->ID, $ids)) {
                                    echo "check p-item" . absint($item->ID);
                                }
                            }
                            echo "select-product  p-item" . absint($item->ID);
                            echo '" data-id="' . absint($item->ID) . '">ID: ' . absint($item->ID) . " - " . esc_html($item->post_title) . '</li>';
                        } ?>
                    </ul>
                </div>
            </div>
            <input name="<?php echo esc_attr($settings['param_name']) ?>"
                   class="awe-type-value wpb_vc_param_value wpb-textinput <?php echo esc_attr($settings['param_name']) . "_" . esc_attr($settings['type']) ?>_field"
                   type="hidden" value="<?php echo esc_attr($val) . $dependency; ?>">
            <?php
            return ob_get_clean();
        }

        /*
         * end shortcode type load product
         */

        // field param
        add_custum_shortcode_param('awe_tab_slide', 'awe_vc_tab_slide', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_vc_tab_slide($settings, $value)
        {
            $dependency = '';
            $val = $value;
            parse_str(urldecode($value), $social);

            $html = '<div class="awe_add_tab_slide">';

            if (is_array($social)) {
                $i = 1;
                foreach ($social as $key => $value) {
                    $image = wp_get_attachment_image_src($value['image']);

                    $html .= '<div class="awe-call-item" data-item="' . $i . '">';
                    $html .= '<div class="vc_col-sm-12 vc_column wpb_el_type_attach_image vc_shortcode-param">
                                            <div class="wpb_element_label">Image</div>
                                            <div class="edit_form_line"><input type="hidden" value="' . $value['image'] . '"  name="' . $i . '[image]" class="awe-input wpb_vc_param_value gallery_widget_attached_images_ids image attach_image">
                                            <div class="gallery_widget_attached_images">
                                            <ul class="gallery_widget_attached_images_list ui-sortable">
                                           <li class="added">
                                               <div style="width: 75px; height: 75px; overflow: hidden;text-align: center;" class="inner">
                                                        <img src="' . esc_url($image[0]) . '" rel="126">
                                                           </div>
                                                           <a class="icon-remove" href="#"></a>
                                                   </li>
                                            </ul>
                                            </div>
                                            <div class="gallery_widget_site_images"></div>
                                            <a title="Add image" use-single="true" href="#" class="gallery_widget_add_images">Add image</a></div>
                                            </div>';
                    $html .= ' <div  class="vc_col-sm-12 vc_column wpb_el_type_textfield vc_shortcode-param">
                                                <div class="wpb_element_label">First text</div>
                                                <div class="edit_form_line"><input type="text" value="' . esc_attr($value['first']) . '" class="wpb_vc_param_value awe-input wpb-textinput"  name="' . $i . '[first]"></div>
                                             </div>';
                    $html .= '<div  class="vc_col-sm-12 vc_column wpb_el_type_textfield vc_shortcode-param">
                                                <div class="wpb_element_label">Last text</div>
                                                <div class="edit_form_line"><input type="text" value="' . esc_attr($value['last']) . '" class="wpb_vc_param_value awe-input wpb-textinput"  name="' . $i . '[last]"></div>
                                             </div>';

                    $html .= '<a href="#" class="awe-del-social">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<input type="button"  class="awe_add_tab button button-primary button-large" name="add" value="Add New">';
            $html .= '<input name="' . esc_attr($settings["param_name"]) . '" class="awe-social-value wpb_vc_param_value wpb-textinput ' . esc_attr($settings['param_name']) . ' ' . esc_attr($settings['type']) . '_field" type="hidden" value="' . esc_attr($val) . '" ' . $dependency . '>';
            return $html;

        }

        // field param
        add_custum_shortcode_param('add_text_field', 'awe_text_field', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');
        function awe_text_field($settings, $value)
        {
            $dependency = '';
            $val = $value;
            $html = '<div class="awe_add_field">';

            parse_str(urldecode($value), $field);
            if (is_array($field)) {
                $i = 1;
                foreach ($field as $key => $value) {
                    $html .= '<div class="field-item" data-item="' . $i . '">';
                    $html .= '<div class="wpb_element_label">' . __( 'Ingredient', 'hillter' ) . ' ' . $i . '</div>';
                    $html .= '<input class="awe-input awe-ingredient-save awe-ingredient" name="' . $i . '[ingredient]" value="' . $value['ingredient'] . '" type="text" >';
                    $html .= '<input class="awe-input awe-ingredient-save awe-detail" name="' . $i . '[detail]" value="' . $value['detail'] . '" type="text" >';
                    $html .= '<a href="#" class="awe-del-field">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<div class="add-field"><button class="awe-field-add" type="button">' . __('Add more', 'hillter') . ' </button></div>';
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-field-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $val . '" ' . $dependency . '>';
            return $html;
        }

        // location param

        add_custum_shortcode_param('add_location', 'awe_add_location', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_add_location($settings, $value)
        {
            $dependency = '';
            $val = $value;
            $html = '<div class="awe_add_location">';

            parse_str(urldecode($value), $locations);
            if (is_array($locations)) {
                $i = 1;
                foreach ($locations as $key => $value) {
                    $html .= '<div class="location-item" data-item="' . $i . '">';
                    $html .= '<div class="wpb_element_label">' . __("Location", 'hillter') . ' ' . $i . '</div>';
                    $html .= '<input class="awe-input awe-location-save awe-title" name="' . $i . '[title]" value="' . $value['title'] . '" type="text" >';
                    $html .= '<input class="awe-input awe-location-save awe-des" name="' . $i . '[des]" value="' . $value['des'] . '" type="text" >';
                    $html .= '<a href="#" class="awe-del-location">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<div class="add-location"><button class="awe-location-add" type="button">' . __('Add more', 'hillter') . ' </button></div>';
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-location-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $val . '" ' . $dependency . '>';
            return $html;
        }

        // Offer param

        add_custum_shortcode_param('add_offer', 'awe_add_offer', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_add_offer($settings, $value)
        {
            $dependency = '';
            $val = $value;
            $html = '<div class="awe_add_offer">';

            parse_str(urldecode($value), $offer);
            if (is_array($offer)) {
                $i = 1;
                foreach ($offer as $key => $value) {
                    $html .= '<div class="offer-item" data-item="' . $i . '">';
                    $html .= '<div class="wpb_element_label">' . __("Offer", 'hillter') . ' ' . $i . '</div>';
                    $html .= '<input class="awe-input awe-offer-save awe-offer" name="' . $i . '[offer]" value="' . $value['offer'] . '" type="text" >';
                    $html .= '<a href="#" class="awe-del-offer">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<div class="add-offer"><button class="awe-offer-add" type="button">' . __('Add more', 'hillter') . ' </button></div>';
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-offer-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $val . '" ' . $dependency . '>';
            return $html;
        }

        // Support Call param

        add_custum_shortcode_param('add_support_call', 'awe_add_support_call', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_add_support_call($settings, $value)
        {
            $dependency = '';
            $val = $value;
            $html = '<div class="awe_add_support_call">';

            parse_str(urldecode($value), $support);
            if (is_array($support)) {
                $i = 1;
                foreach ($support as $key => $value) {
                    $html .= '<div class="support-call-item" data-item="' . $i . '">';
                    $html .= '<div class="wpb_element_label">' . __("Support Call", 'hillter') . ' ' . $i . '</div>';
                    $html .= '<input class="awe-input awe-support-call-save awe-title" name="' . $i . '[title]" value="' . $value['title'] . '" type="text" >';
                    $html .= '<input class="awe-input awe-support-call-save awe-des" name="' . $i . '[des]" value="' . $value['des'] . '" type="text" >';
                    $html .= '<a href="#" class="awe-del-support-call">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<div class="add-support-call"><button class="awe-support-call-add" type="button">' . __('Add more', 'hillter') . ' </button></div>';
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-support-call-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $val . '" ' . $dependency . '>';
            return $html;
        }

        // one field param

        add_custum_shortcode_param('add_tips_field', 'awe_tips_field', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_tips_field($settings, $value)
        {
            $dependency = '';
            $val = $value;
            $html = '<div class="awe_add_step">';

            parse_str(urldecode($value), $steps);
            if (is_array($steps)) {
                $i = 1;
                foreach ($steps as $key => $value) {
                    $html .= '<div class="step-item" data-item="' . $i . '">';
                    $html .= '<div class="wpb_element_label">' . __( 'Step', 'hillter' ) . ' ' . $i . '</div>';
                    $html .= '<input class="awe-input awe-step-save" name="' . $i . '[step]" value="' . $value['step'] . '" type="text" >';
                    $html .= '<a href="#" class="awe-del-step">delete</a>';
                    $html .= '</div>';
                    $i++;
                }
            }
            $html .= '</div>';
            $html .= '<div class="add-step"><button class="awe-step-add" type="button">' . __('Add more', 'hillter') . ' </button></div>';
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-step-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $val . '" ' . $dependency . '>';
            return $html;
        }

        add_custum_shortcode_param('awe_sort_cat', 'awe_sort_cat', get_template_directory_uri() . '/awe_shortcode/assets/js/vc_js.js');

        function awe_sort_cat($settings, $value)
        {
            global $bvalue;
            $dependency = '';
            $li = '';
            $sort = awe_merge_array($value, $bvalue, $settings['cat_type']);
            $value = '';
            foreach ($sort as $key) {
                if ($key != '') {
                    $value .= $key . ',';
                    $cat = get_term($key, $settings['cat_type']);
                    if (is_object($cat)) {
                        $li .= '<li data-id="' . $key . '">' . esc_attr($cat->name) . '</li>';
                    }
                }
            }

            $html = '<div class="menu-sort">';
            if ($li == '') {
                $html .= '<p>' . __('Please add Product Category!', 'hillter') . '</p>';
            } else {
                $html .= '<ul class="awe-sortable">';
                $html .= $li;
                $html .= '</ul>';
            }
            $html .= '<input name="' . $settings['param_name'] . '" class="awe-sortable-value wpb_vc_param_value wpb-textinput ' . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="' . $value . '" ' . $dependency . '>';
            $html .= '</div>';
            return $html;
        }


        function awe_merge_array($str_1, $str_2, $type)
        {
            $array_1 = explode(',', $str_1);
            $array_2 = explode(',', $str_2);
            $array = array();
            foreach ($array_1 as $value) {
                if ($value != '') {
                    $terms = get_term($value, $type);
                    if (is_object($terms)) {
                        if ($terms->count >= 1) {
                            array_push($array, $terms->term_id);
                        }
                    }
                }
            }
            if (count($array) <= count($array_2)) {
                foreach ($array_2 as $value) {
                    if (!in_array($value, $array)) {
                        array_unshift($array, $value);
                    }
                }
            }
            return $array;
        }

        function awe_merge_post_array($str_1, $str_2)
        {
            $array_1 = explode(',', $str_1);
            $array = array();
            foreach ($array_1 as $key) {
                if ($key != '') {
                    if (get_post_status($key) == 'publish') {
                        array_push($array, $key);
                    }
                }
            }
            $array_2 = explode(',', $str_2);
            if (count($array) <= count($array_2)) {
                foreach ($array_2 as $value) {
                    if (!in_array($value, $array)) {
                        array_unshift($array, $value);
                    }
                }
            }
            return $array;
        }


    }
endif;