<?php
/**
 * Custom Config Visual Composer
 */

if (class_exists('Vc_Manager')){

	// Custom Template Shortcode Directory.
	$dir = get_template_directory() . '/awe_shortcode/template';
	vc_set_shortcodes_templates_dir( $dir );

	vc_disable_frontend();

	// Custom class element.
	function awe_custom_css_classes( $class_string, $tag ) {
		if ( $tag == 'vc_column_inner' ) {
			$class_string = preg_replace( '/vc_col-sm-(\d{1,2})/', 'vc_col-xs-$1', $class_string );
		}
		return $class_string;
	}
	add_filter( 'vc_shortcodes_css_class', 'awe_custom_css_classes', 10, 2 );

	class awe_buider {
		public function __construct() {
			$this->path['shortcode'] = '/shortcode';
			$this->path['params'] = '/params';
			$this->path['template'] = '/template';
			add_filter('awe_load_builder_shortcode', array($this, 'awe_load_builder_shortcode'));
			add_filter('awe_load_param_file', array($this, 'awe_load_param_file'));
			add_filter('awe_load_template_file', array($this, 'awe_load_template_file'));
			$this->load_shortcode_file();
			$this->load_class();
			$this->load_params_file();
			//$this->load_template_file();
			// add_action('add_meta_boxes', array($this, 'add_meta_box'));
			add_action('save_post', array($this, 'save_meta'));
		}

		public function awe_load_builder_shortcode($path) {
			$path = array(get_template_directory() . '/awe_shortcode/shortcode/');
			return $path;
		}

		public function awe_load_param_file($path) {
			$path = array(get_template_directory() . '/awe_shortcode/params/');
			return $path;
		}

		public function awe_load_template_file($path) {
			$path = array(get_template_directory() . '/awe_shortcode/template/');
			return $path;
		}

		public function load_params_file() {
			$elements = apply_filters('awe_load_param_file', $this->path['params']);
			foreach ($elements as $key ) {
				foreach (glob($key.'*.php') as $file) {
					require_once($file);
				}
			}
		}

		public function load_template_file() {
			$elements = apply_filters('awe_load_template_file', $this->path['template']);
			foreach ($elements as $key ) {
				foreach (glob($key.'*.php') as $file) {
					require_once($file);
				}
			}
		}

		public function load_shortcode_file() {

			include_once( get_template_directory() . '/awe_shortcode/abstract-shortcode.php');
			$elements = apply_filters('awe_load_builder_shortcode', $this->path['shortcode']);
			foreach ($elements as $key ) {
				foreach (glob($key.'*.php') as $file) {
					require_once($file);
				}
			}
		}

		public function load_class() {
			foreach(get_declared_classes() as $class) {
				if(is_subclass_of($class, 'awe_shortcode')) {
					new $class;
				}
			}
		}

		public function add_meta_box() {
			add_meta_box('awe_menu', __('Setting Menu For This Page', 'hillter'), array($this, 'menu_meta_box'), 'page', 'side', 'high');
		}

		public function menu_meta_box($post) {
			wp_nonce_field( 'awe_menu_page', 'awe_menu_page_nonce' );
			$menu = get_post_meta($post->ID, '_awe_menu', true);
			?>
			<div class="awe-setting-menu">
				<label><?php _e("Choose menu nav", 'hillter')?></label>
				<select name="_awe_menu[nav]">
					<option value=""><?php _e("Default", 'hillter'); ?></option>
					<?php
					if(!empty($menu_nav) && !empty($menu["style"]))
					{
						foreach($menu_nav as $item)
						{
							if(is_object($item))
							{
								?><option value="<?php echo esc_attr($item->slug);?>" <?php selected($menu["nav"], $item->slug) ?>><?php echo esc_attr($item->name); ?></option><?php
							}
						}
					}
					?>
				</select>
			</div>
			<?php
		}

		public function save_meta($post_id) {
			if ( ! isset( $_POST['awe_menu_page_nonce'] ) ) {
				return;
			}
			if ( ! wp_verify_nonce( $_POST['awe_menu_page_nonce'], 'awe_menu_page' ) ) {
				return;
			}
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}
			if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {

				if ( ! current_user_can( 'edit_page', $post_id ) ) {
					return;
				}

			} else {

				if ( ! current_user_can( 'edit_post', $post_id ) ) {
					return;
				}
			}
			if(isset($_POST['_awe_menu']))
			{
				$value = stripslashes_deep($_POST['_awe_menu']);
				update_post_meta($post_id, '_awe_menu', $value);
			}
		}

	}

	new awe_buider();


	if ( class_exists( 'WPBMap' ) ) {

		// Add subtitle to tab shortcode
		add_action( 'init', 'awe_add_tab_param' );
		function awe_add_tab_param() {
			$awe_sc = WPBMap::getShortCode( 'vc_tab' );
			$awe_param = $awe_sc['params'];

			foreach ( $awe_param as $k => $v ) {
				if ( $v['param_name'] == 'title' ) {
					$awe_param[$k]['weight'] = 3;
				} elseif ( $v['param_name'] == 'tab_id' ) {
					$awe_param[$k]['weight'] = 1;
				}
			}

			$awe_sc['params'] = $awe_param;

			unset( $awe_sc['base'] );

			vc_map_update( 'vc_tab', $awe_sc );


			$attributes = array(
				'type' => 'textfield',
				'heading' => "Subtitle",
				'param_name' => 'subtitle',
				'weight'	=> 2,
			);
			vc_add_param( 'vc_tab', $attributes );
		}


		add_action( 'init', 'awe_add_tab_param_4_6' );
		function awe_add_tab_param_4_6() {
			// Change param weight
			$awe_sc = WPBMap::getShortCode( 'vc_tta_section' );
			$awe_param = $awe_sc['params'];

			if ( ! $awe_param ) return;

			foreach ( $awe_param as $k => $v ) {
				if ( $v['param_name'] == 'title' ) {
					$awe_param[$k]['weight'] = 3;
				}
			}

			$awe_sc['params'] = $awe_param;

			unset( $awe_sc['base'] );

			vc_map_update( 'vc_tta_section', $awe_sc );

			// add new param
			$attributes = array(
				'type' => 'textfield',
				'heading' => "Subtitle",
				'param_name' => 'subtitle',
				'weight'	=> 2,
			);
			vc_add_param( 'vc_tta_section', $attributes );
		}


		// Tab title output
		function awe_tab_title_output( $atts, $content, $obj, $sectionClass, $shortcode ) {
			$isPageEditabe = vc_is_page_editable();

			// $sectionClass = $this->sectionClass;
			// $sectionClass = $args['section_class'];

			$html = array();
			$html[] = '<div class="vc_tta-tabs-container">';
			$html[] = '<ul class="vc_tta-tabs-list">';
			if ( ! $isPageEditabe ) {
				$strict_bounds = ( 'vc_tta_tabs' === $shortcode );
				$active_section = $obj->getActiveSection( $atts, $strict_bounds );

				foreach ( WPBakeryShortCode_VC_Tta_Section::$section_info as $nth => $section ) {
					$classes = array( 'vc_tta-tab' );
					if ( ( $nth + 1 ) === $active_section ) {
						$classes[] = $obj->activeClass;
					}

					$title = '<span class="vc_tta-title-text">' . $section['title'] . '</span>';
					if ( $section['subtitle'] ) {
						$title .= '<span class="subtitle">' . $section['subtitle'] . '</span>';
					}

					if ( 'true' === $section['add_icon'] ) {
						$icon_html = $obj->constructIcon( $section );
						if ( 'left' === $section['i_position'] ) {
							$title = $icon_html . $title;
						} else {
							$title = $title . $icon_html;
						}
					}
					$a_html = '<a href="#' . $section['tab_id'] . '" data-vc-tabs data-vc-container=".vc_tta">' . $title . '</a>';
					$html[] = '<li class="' . implode( ' ', $classes ) . '" data-vc-tab>' . $a_html . '</li>';
				}
			}

			$html[] = '</ul>';
			$html[] = '</div>';

			return implode( '', $html );
		}


		function awe_icon_param_scripts() {
			// wp_enqueue_style( 'awe-hillter-font', get_template_directory_uri() . '/assets/css/lib/font-hilltericon.css' );
			// wp_enqueue_style( 'awe-dialog', get_template_directory_uri() . '/awe_shortcode/assets/iconlist/awe-dialog.css', false, false );
			wp_enqueue_script( "jquery-list", AWE_JS_URL . "lib/list.min.js", array(), '0' );
			wp_enqueue_script( 'awe-icon-js', get_template_directory_uri() . '/awe_shortcode/assets/iconlist/Awe.js', array(), null, true );
			wp_enqueue_script( 'awe_dialog-js', get_template_directory_uri() . '/awe_shortcode/assets/iconlist/Awe_dialog.js', array(), null, true );

			wp_localize_script( 'jquery', 'Awe', array(
				'themeurl'	=> get_template_directory_uri(),
			) );
		}


		function awe_icon_param() {
			// enqueue font css
			add_action( 'admin_enqueue_scripts', 'awe_icon_param_scripts' );

			// Change param
			$awe_sc = WPBMap::getShortCode( 'vc_icon' );
			$awe_param = $awe_sc['params'];

			// Add to dropdown
			$awe_param[0]['value'][__( 'Hillter icon', 'hillter' )] = 'hillter';

			// Add icon picker field
			$field = array(
				array(
					'type'	=> 'iconpicker',
					'heading'	=> __( 'Icon', 'hillter' ),
					'param_name'	=> 'icon_hillter',
					'settings'	=> array(
						'emptyIcon'	=> false,
						'type'	=> 'hillter',
						'iconsPerPage'	=> 4000,
					),
					'dependency'	=> array(
						'element'	=> 'type',
						'value'	=> 'hillter',
					)
				)
			);
			array_splice( $awe_param, 6, 0, $field );

			$awe_sc['params'] = $awe_param;

			unset( $awe_sc['base'] );

			vc_map_update( 'vc_icon', $awe_sc );
		}
		add_action( 'init', 'awe_icon_param' );


		function vc_iconpicker_type_hillter( $icons ) {
			$hillter_icons = array(
				array( 'hillter-icon-person' => __( 'Person', 'hillter' ) ),
				array( 'hillter-icon-quote-left' => __( 'Quote left', 'hillter' ) ),
				array( 'hillter-icon-breakfast' => __( 'Breakfast', 'hillter' ) ),
				array( 'hillter-icon-decor' => __( 'Decor', 'hillter' ) ),
				array( 'hillter-icon-bed' => __( 'Bed', 'hillter' ) ),
				array( 'hillter-icon-telephone' => __( 'Telephone', 'hillter' ) ),
				array( 'hillter-icon-hangers' => __( 'Hangers', 'hillter' ) ),
				array( 'hillter-icon-phone' => __( 'Phone', 'hillter' ) ),
				array( 'hillter-icon-ocenview' => __( 'Ocenview', 'hillter' ) ),
				array( 'hillter-icon-calendar' => __( 'Calendar', 'hillter' ) ),
				array( 'hillter-icon-cart' => __( 'Cart', 'hillter' ) ),
				array( 'hillter-icon-wifi' => __( 'Wifi', 'hillter' ) ),
				array( 'hillter-icon-arrow' => __( 'Arrow', 'hillter' ) ),
				array( 'hillter-icon-air-conditioner' => __( 'Air conditioner', 'hillter' ) ),
				array( 'hillter-icon-cable' => __( 'Cable', 'hillter' ) ),
				array( 'hillter-icon-luxury' => __( 'Luxury', 'hillter' ) ),
				array( 'hillter-icon-location' => __( 'Location', 'hillter' ) ),
				array( 'hillter-icon-size' => __( 'Size', 'hillter' ) ),
				array( 'hillter-icon-cloud' => __( 'Cloud', 'hillter' ) ),
				array( 'hillter-icon-view' => __( 'View', 'hillter' ) ),
				array( 'hillter-icon-time' => __( 'Time', 'hillter' ) ),
				array( 'hillter-icon-bar' => __( 'Bar', 'hillter' ) ),
				array( 'hillter-icon-microphone' => __( 'Microphone', 'hillter' ) ),
				array( 'hillter-icon-media-play' => __( 'Media play', 'hillter' ) ),
				array( 'hillter-icon-down-arrow' => __( 'Arrow down', 'hillter' ) ),
				array( 'hillter-icon-cooker-hood' => __( 'Cooker hood', 'hillter' ) ),
				array( 'hillter-icon-left-arrow' => __( 'Arrow left', 'hillter' ) ),
				array( 'hillter-icon-right-arrow' => __( 'Arrow right', 'hillter' ) ),
			);

			return array_merge( $icons, $hillter_icons );
		}
		add_filter( 'vc_iconpicker-type-hillter', 'vc_iconpicker_type_hillter' );


		// Add font size to text block
		add_action( 'init', 'awe_add_textblock_param' );
		function awe_add_textblock_param() {

			$awe_sc = WPBMap::getShortCode( 'vc_column_text' );
			$awe_param = $awe_sc['params'];

			$size_value = array(
				__( 'Default', 'hillter' )	=> 0,
			);
			for ( $i = 10; $i <= 50; $i++ ) {
				$size_value[$i . 'px'] = $i;
			}

			$field = array(
				array(
					'type'	=> 'dropdown',
					'heading'	=> __( 'Text size', 'hillter' ),
					'param_name'	=> 'size',
					'value'	=> $size_value,
				),
			);
			array_splice( $awe_param, 1, 0, $field );


			$awe_sc['params'] = $awe_param;

			unset( $awe_sc['base'] );

			vc_map_update( 'vc_column_text', $awe_sc );

		}


		// Add some option to param: Hillter style, Transparent
		add_action( 'init', 'awe_add_tab_param_option' );
		function awe_add_tab_param_option() {
			// Change param weight
			$awe_sc = WPBMap::getShortCode( 'vc_tta_tabs' );
			$awe_param = $awe_sc['params'];

			if ( ! $awe_param ) return;

			// var_dump( $awe_param );

			$awe_param[1][ 'value' ][ __( 'Hillter', 'hillter' ) ] = 'hillter';
			$awe_param[3][ 'value' ][ __( 'Transparent', 'hillter' ) ] = 'transparent';

			// var_dump( $awe_param );
			$awe_sc['params'] = $awe_param;

			unset( $awe_sc['base'] );

			vc_map_update( 'vc_tta_tabs', $awe_sc );

		}

	}

}

add_action( 'init', function() {
	// echo '<pre>'; print_r( WPBMap::getShortcode( 'vc_progress_bar' )['params'] ); echo '</pre>';
	// echo '<pre>'; print_r( WPBMap::getShortcode( 'vc_icon' )['params'] ); echo '</pre>';
} );
