<?php

/**
 * Created by PhpStorm.
 * User: Kai
 * Date: 7/9/2015
 * Time: 4:00 PM
 */

if ( ! class_exists( 'Awe_Posts_Template' ) ) {

	class Awe_Posts_Template {
		protected $cat;
		protected $style;
		protected $num;
		protected $load;

		public function __construct() {
			add_action( 'wp_ajax_gallery_load_more', array( $this, 'awe_gallery_loadmore_ajax' ) );
			add_action( 'wp_ajax_nopriv_gallery_load_more', array( $this, 'awe_gallery_loadmore_ajax' ) );
		}

		/**
		 * Get The List Item Filer by Term
		 *
		 * @param $term
		 */
		public function awe_single_gallery_filter( $term ) {
			// If there was an error, continue to the next term.
			$term_link = get_term_link( $term );
			if ( is_wp_error( $term_link ) ) {
				continue;
			}
			echo '<li><a href="' . $term_link . '" data-filter=".' . $term->slug . '">' . $term->name . '</a></li>';
		}

		/**
		 * Show the top filter of taxonomy
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_top_gallery_filter() {
			$cats = $this->cat;
			?>
			<!--FILTER -->
			<div class="gallery-cat text-center">
				<ul class="list-inline">
					<li class="active"><a href="#" data-filter="*"><?php echo esc_html__( 'All', 'hillter' ); ?></a></li>
					<?php
					if ( sizeof( $cats ) == 1 && $cats[0] == "all" ) {
						$terms = get_terms( array( 'gallery_cat' ), array( 'hide_empty' => false ) );
						foreach ( $terms as $item ) :
							print $this->awe_single_gallery_filter( $item );
						endforeach;
					} else {

						foreach ( $cats as $item ) :
							$terms = get_term_by( 'term_taxonomy_id', $item, 'gallery_cat' );
							print $this->awe_single_gallery_filter( $terms );
						endforeach;
					}
					?>
				</ul>
			</div>
			<!--END / FILTER -->
		<?php
		}

		/**
		 * Check if post using gallery shortcode or youtube embed
		 *
		 * @return Array
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_check_gallery_content() {

			global $shortcode_tags;
			$output = array();

			// Check video
			// Make a copy of global shortcode tags - we'll temporarily overwrite it.
			$theme_shortcode_tags = $shortcode_tags;

			// The shortcodes we're interested in.
			$shortcode_tags = array(
				'video' => $theme_shortcode_tags['video'],
				'embed' => $theme_shortcode_tags['embed']
			);
			// Get the absurd shortcode regexp.
			$video_regex = '#' . get_shortcode_regex() . '#i';

			// Restore global shortcode tags.
			$shortcode_tags = $theme_shortcode_tags;

			$pattern_array = array( $video_regex );

			// Get the patterns from the embed object.
			if ( ! function_exists( '_wp_oembed_get_object' ) ) {
				include ABSPATH . WPINC . '/class-oembed.php';
			}
			$oembed        = _wp_oembed_get_object();
			$pattern_array = array_merge( $pattern_array, array_keys( $oembed->providers ) );

			// Or all the patterns together.
			$pattern = '#(' . array_reduce( $pattern_array, function ( $carry, $item ) {
					if ( strpos( $item, '#' ) === 0 ) {
						// Assuming '#...#i' regexps.
						$item = substr( $item, 1, - 2 );
					} else {
						// Assuming glob patterns.
						$item = str_replace( '*', '(.+)', $item );
					}

					return $carry ? $carry . ')|(' . $item : $item;
				} ) . ')#is';

			// Simplistic parse of content line by line.
			$lines = explode( "\n", get_the_content() );
			foreach ( $lines as $line ) {
				$line = trim( $line );
				if ( preg_match( $pattern, $line, $matches ) ) {
					$output['name'] = "video";
					$output['data'] = $matches[0];
					break;
				}
			}

			// Check Gallery

			$content = get_the_content();
			// Check if using gallery content
			$pattern = get_shortcode_regex();
			preg_match( '/' . $pattern . '/s', $content, $matches ); // Extract shortcode gallery content
			if ( $matches && $matches[2] == "gallery" ) :
				$id_str = shortcode_parse_atts( $matches[0] );
				preg_match( '/\ids=.(.*).\]/', $id_str[1], $m ); // Get gallery IDs string
				$output['name'] = "gallery";
				$output['data'] = $m[1];
			endif;

			return $output; // Return array Video / Gallery

		}

		/**
		 * Generate Ouput HTML Popup from Gallery Shortcode
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_get_popup_content_from_shortcode() {
			ob_start();
			$input     = $this->awe_check_gallery_content();
			$thumb_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
			if ( isset( $input['name'] ) && $input['name'] == "gallery" ) {
				$g_content = "";
				$content   = get_the_content();
				// Check if using gallery content
				$pattern = get_shortcode_regex();
				preg_match( '/' . $pattern . '/s', $content, $matches ); // Extract shortcode gallery content
				if ( $matches && $matches[2] == "gallery" ) :
					$id_str = shortcode_parse_atts( $matches[0] );
					preg_match( '/\ids=.(.*).\]/', $id_str[1], $m ); // Get gallery IDs string
					$ids = explode( ',', $m[1] ); // Convert id string to array

					if ( ! empty( $ids ) ) {
						foreach ( $ids as $item ) {
							$img = wp_get_attachment_image_src( $item, 'full' );
							$g_content .= '<a href="' . $img[0] . '" title="' . awe_get_image_caption( $item ) . '"></a>';
						}
					}

				endif;
				echo '<a href = "' . $thumb_url[0] . '" class="gallery-popup mfp-image" title = "' . get_the_title() . '" >
                            ' . get_the_post_thumbnail() . '
                        </a>' . $g_content . '<h6 class="text">' . get_the_title() . '</h6>';

			} elseif ( isset( $input['name'] ) && $input['name'] == "video" ) {
				echo '<a href = "' . $input['data'] . '" class="gallery-popup mfp-iframe" title = "' . get_the_title() . '" >
                            ' . get_the_post_thumbnail() . '
                        </a><h6 class="text">' . get_the_title() . '</h6>';
			} else {
				echo '<a href = "' . $thumb_url[0] . '" class="gallery-popup mfp-image" title = "' . get_the_title() . '" >
                            ' . get_the_post_thumbnail() . '
                        </a><h6 class="text">' . get_the_title() . '</h6>';
			}

			return ob_get_clean();
		}

		/**
		 * Show the single gallery
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_get_single_gallery( $s, $k ) {
			if ( $s == 2 ) {
				$larger = ( $k % 6 == 0 ) ? " larger" : "";
			} else {
				$larger = "";
			}
			$gallery_item_content = $this->awe_get_popup_content_from_shortcode();
			$terms                = get_the_terms( get_the_ID(), 'gallery_cat' );
			$tag                  = "";
			foreach ( $terms as $term ) :
				$tag .= ' ' . $term->slug;
			endforeach;

			if ( $s != 3 ):
				// Item Style 1 & 2
				echo '<div class="item-isotope ' . $tag . $larger . '">
                    <div class="gallery_item">
                        ' . $gallery_item_content . '
                    </div>
                </div>';
			else :
				// Item Style 1 & 3
				echo '<div class="item-isotope ' . $tag . '">
                    <div class="activiti_item">
                                    <div class="img">
                                        <a href="' . get_the_permalink() . '">' . get_the_post_thumbnail() . '</a>
                                    </div>
                                    <div class="text">
                                        <h2><a href="' . get_the_permalink() . '">' . get_the_title() . '</a></h2>
                                        <p>' . get_the_excerpt() . '</p>
                                        <a href="' . get_the_permalink() . '" class="view-more">' . __( 'View More', 'hillter' ) . '<i class="fa fa-chevron-right"></i></a>
                                    </div>
                                </div>
                </div>';
			endif;
		}

		public function awe_gallery_loadmore( $data = "" ) {

			?>
			<div class="our-gallery text-center js-loadmore">
				<a class="more awe-btn awe-btn-6" href="#" data-cats="<?php echo esc_attr( $data['cats'] ); ?>"
				   data-style="<?php echo esc_attr( $data['style'] ); ?>"
				   data-page="<?php echo esc_attr( $data['page'] ); ?>"
				   data-max="<?php echo esc_attr( $data['max'] ); ?>"
				   data-num="<?php echo esc_attr( $data['num'] ); ?>"><?php esc_html_e( 'View More', 'hillter' ); ?></a>
			</div>
		<?php
		}


		public function awe_get_only_list( $cat = 1, $style = 1, $page = 1, $num = 12 ) {
			$num   = isset( $this->num ) ? $this->num : $num;
			$style = isset( $this->style ) ? $this->style : $style;
			$cats  = isset( $this->cat ) ? $this->cat : $cat;
			$page  = isset( $page ) ? $page : 1;
			$args  = array();

			$args['post_type'] = 'gallery';
			if ( ! empty( $cats ) ) :
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'gallery_cat',
						'field'    => 'term_id',
						'terms'    => $cats,
					),
				);
			endif;
			$args['posts_per_page'] = $num;
			$args['paged']          = $page;
			$q                      = new WP_Query( $args );
			$max                    = 0;
			if ( $q->have_posts() ) :
				$max = $q->max_num_pages;
				$k   = 0;
				while ( $q->have_posts() ) : $q->the_post();
					$this->awe_get_single_gallery( $style, $k );
					$k ++;
				endwhile;
				wp_reset_postdata();
			endif;
			if ( isset( $this->num ) ) :
				$load['page']  = $page;
				$load['max']   = $max;
				$cats          = implode( ',', $cats );
				$load['cats']  = $cats;
				$load['style'] = $style;
				$load['num']   = $num;
				$this->load    = $load;
			endif;
			?>

		<?php
		}

		/**
		 * Show the list gallery
		 *
		 * @param $cat ,$style
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_get_list_gallery(
			$class_column, $class_padding
		) {
			?>
			<!-- GALLERY CONTENT -->
			<div class="gallery-content">
				<div class="row">
					<div
						class="gallery-isotope <?php echo esc_attr( $class_column ) . ' ' . esc_attr( $class_padding ); ?>">
						<!-- ITEM SIZE -->
						<div class="item-size"></div>
						<!-- END / ITEM SIZE -->
						<?php print $this->awe_get_only_list(); ?>
					</div>
				</div>
				<?php
				$load = $this->load;
				print $this->awe_gallery_loadmore( $load ); // Load in the first time without ajax ?>
			</div>
			<!-- GALLERY CONTENT -->
		<?php
		}


		public function awe_gallery_loadmore_ajax() {
			$cats  = $_GET['cats'];
			$cats  = explode( ',', $cats );
			$page  = intval( $_GET['page'] );
			$num   = intval( $_GET['num'] );
			$style = intval( $_GET['style'] );
			ob_start();
			print $this->awe_get_only_list( $cats, $style, $page, $num );
			$output['content'] = ob_get_clean();
			echo json_encode( $output );
			wp_die();
		}

		/**
		 * Show the list gallery include fillter
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_the_gallery(
			$title = "", $cat = "", $style = "", $num = 12, $column = 4, $no_padding = false
		) {
			$cat           = explode( ',', $cat );
			$this->cat     = $cat;
			$this->style   = $style;
			$this->num     = $num;
			$class_column  = "col-" . $column;
			$class_padding = ( $no_padding == true ) ? "pd-0" : "";
			echo '<div class="gallery">';
			echo '<h2 class="heading text-center">' . $title . '</h2>';
			$this->awe_top_gallery_filter(); // Get top fillter
			print $this->awe_get_list_gallery( $class_column, $class_padding ); // Get content list gallery
			echo '</div > ';

		}

	}

	new Awe_Posts_Template;
}
