<?php
/**
 * Awe Posts Shortcode
 */


if ( ! class_exists( 'Awe_Grid_content' ) ) {

	class Awe_Grid_content {
		protected $cat;
		protected $style;
		protected $num;
		protected $load;
		protected $taxonomy;
		protected $column;

		/**
		 * Get The List Item Filer by Term
		 *
		 * @param $term
		 */
		public function awe_single_content_filter( $term ) {
			// If there was an error, continue to the next term.
			$term_link = get_term_link( $term );
			if ( is_wp_error( $term_link ) ) {
				return;
			}
			echo '<li><a href="' . $term_link . '" data-filter=".' . $term->slug . '">' . $term->name . '</a></li>';
		}

		/**
		 * Show the top filter of taxonomy
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_top_content_filter() {
			$tax = $this->taxonomy; // Get current taxonomy settings
			$cats = $this->cat; // If cats empty show all category
			?>
			<!--FILTER -->
			<div class="gallery-cat tax_filter text-center">
				<ul class="list-inline">
					<li class="active"><a href="#" data-filter="*"><?php echo esc_html__( 'All', 'hillter' ); ?></a></li>
					<?php
					foreach ( $cats as $item ) {
						if ( 'all' == $item ) {
							continue;
						}
						$terms = get_term_by( 'id', $item, $tax );
						print $this->awe_single_content_filter( $terms );
					}
					?>
				</ul>
			</div>
			<!--END / FILTER -->
		<?php
		}


		/**
		 * Show the single content
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_get_single_content( $tax, $k ,$class_column ) {
			$terms                = get_the_terms( get_the_ID(), $tax );
			$tag                  = '';
			
			if ( ! empty( $terms ) ) {
				foreach ( $terms as $term ) {
					$tag .= ' ' . $term->slug;
				}
			}

			echo '<div class="item-isotope col-xs-12 col-sm-6 ' . $class_column . ' ' . $tag . '">
								<div class="activiti_item">
									<div class="img">
										<a href="'.get_permalink().'">'.get_the_post_thumbnail( get_the_ID(), 'awe-room-slider' ).'</a>
									</div>
									<div class="text">
										<h3><a href="'.get_permalink().'">'.get_the_title().'</a></h3>
										<p>'.get_the_excerpt().'</p>
										<a href="'.get_permalink().'" class="view-more">'.esc_html__( 'View More', 'hillter' ).'<i class="fa fa-chevron-right"></i></a>
									</div>
								</div>
							</div>';
		}

		public function awe_content_loadmore( $data = '' ) {
			?>
			<div class="text-center js-loadmore-content">
				<a class="more awe-btn awe-btn-6" href="#"
					data-tax="<?php echo esc_attr( $data['tax'] ); ?>"
					data-cats="<?php echo esc_attr( $data['cats'] ); ?>"
					data-style="<?php echo esc_attr( $data['style'] ); ?>"
					data-page="<?php echo esc_attr( $data['page'] ); ?>"
					data-max="<?php echo esc_attr( $data['max'] ); ?>"
					data-num="<?php echo esc_attr( $data['num'] ); ?>"
					data-col="<?php echo esc_attr( $data['col'] ); ?>">
					<?php esc_html_e( 'View More', 'hillter' ); ?></a>
			</div>
		<?php
		}


		public function awe_get_only_list( $tax = 'category',  $cat = 1, $style = 1, $page = 1, $num = 12, $col = 0 ) {
			$tax   = isset( $this->taxonomy ) ? $this->taxonomy : $tax;
			$cats  = isset( $this->cat ) ? $this->cat : $cat;
			$num   = isset( $this->num ) ? $this->num : $num;
			$style = isset( $this->style ) ? $this->style : $style;

			$page  = isset( $page ) ? $page : 1;
			$col_num  = isset( $this->col ) ? $this->col : $col;
			if ( isset( $this->column ) ) {
				$col_class = $this->column;
			} else {
				switch ( $col ) {
					case '1':
						$col_class = 'col-md-12';
						break;
					case '2':
						$col_class = 'col-md-6';
						break;
					case '3':
						$col_class = 'col-md-4';
						break;
					case '4':
						$col_class = 'col-md-3';
						break;
					case '5':
						$col_class = 'col-md-15';
						break;
					case '6':
						$col_class = 'col-md-2';
						break;
				}
			}

			// Setup Query.
			$args  = array();
			if ( '' != $cats[0] && 'all' != $cats[0] ) {
					$args['tax_query'] = array(
						array(
							'taxonomy' => $tax,
							'field'    => 'term_id',
							'terms'    => $cats,
						),
					); // Add custom taxonomy to query.
			}
			$args['posts_per_page'] = $num;
			$args['paged']          = $page;
			$q                      = new WP_Query( $args );
			$max                    = 0;

			if ( $q->have_posts() ) :
				$max = $q->max_num_pages;
				$k   = 0;
				while ( $q->have_posts() ) : $q->the_post();
					$this->awe_get_single_content( $tax, $k,$col_class );
					$k ++;
				endwhile;
				wp_reset_postdata();
			endif;

			if ( isset( $this->num ) ) :
				$load['tax'] = 	$tax;
				$load['page']  = $page;
				$load['max']   = $max;
				$cats          = implode( ',', $cats );
				$load['cats']  = $cats;
				$load['style'] = $style;
				$load['num']   = $num;
				$load['col']   = $col_num;
				// $load['size'] = $size;
				$this->load    = $load;
			endif;
		}

		/**
		 * Show the list content`
		 *
		 * @param $cat ,$style
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_get_list_content( $class_column) {
			$this->column = $class_column;
			?>
			<!-- content content -->
			<div class="gallery-content <?php //echo esc_attr( $class_padding ); ?>">
				<div class="row">
					<div class="gallery-isotope">
						<!-- ITEM SIZE -->
						<div class="item-size col-xs-12 col-sm-6 <?php echo esc_attr( $class_column ); ?>"></div>
						<!-- END / ITEM SIZE -->
						<?php print $this->awe_get_only_list(); ?>
					</div>
				</div>
				<?php
				$load = $this->load;
				if ( $this->load['max'] > 1 ) {
					print $this->awe_content_loadmore( $load );
				}
				?>
			</div>
			<!-- content content -->
		<?php
		}


		/**
		 * Show the list content include fillter
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_display_grid_content( $data) {
			$cat           = explode( ',', $data['post_cat'] );
			$this->cat     = $cat;
			$this->taxonomy = $data['taxonomy'];
			$this->num     = isset( $data['num'] ) ? $data['num'] : 0;
			$this->col = isset( $data['column'] ) ? $data['column'] : 0;
			if( $data['style']!='Grid'){
			$class_column = '';
			}else{
			switch ( $data['column'] ) {
				case '1':
					$class_column  = 'col-md-12';
					break;
				case '2':
					$class_column  = 'col-md-6';
					break;
				case '3':
					$class_column  = 'col-md-4';
					break;
				case '4':
					$class_column  = 'col-md-3';
					break;
				case '5':
					$class_column  = 'col-md-15';
					break;
				case '6':
					$class_column  = 'col-md-2';
					break;
			}
			}
			echo '<div class="gallery">';
			$this->awe_top_content_filter(); // Get top fillter
			print $this->awe_get_list_content( $class_column ); // Get content list content
			echo '</div > ';
		}

	}
}


function awe_posts_content_grid( $data) {
	$content = new Awe_Grid_content;
	$content->awe_display_grid_content( $data );
}

function awe_posts_content_list( $data) {
	?>
	<div class="awe-posts">
		<?php
		$args = array();
		$args['posts_per_page'] = $data['num'];
		if( 'all' != $data['post_cat'] ) {
			$args['tax_query'] = array(
				array(
					'taxonomy' => $data['taxonomy'],
					'field'    => 'term_id',
					'terms'    => $data['post_cat'],
				),
			); // Add custom taxonomy to query.
		}
		$q = new WP_Query( $args );
		if ( $q->have_posts() ) :
			while ( $q->have_posts() ) : $q->the_post();
				?>
				<!-- ITEM -->
				<div class="news-item">
					<div class="img">
						<a href="<?php the_permalink(); ?>"><?php echo get_the_post_thumbnail( get_the_ID(), 'awe-post-sc' ); ?></a>
					</div>
					<div class="text">
						<span class="date"><?php the_time( get_option( 'date_format' ) ); ?></span>
						<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
						<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e( '[ Read More ]', 'hillter' ); ?></a>
					</div>
				</div>
				<!-- END / ITEM -->
			<?php endwhile;
		endif;
		?>
	</div>
	<?php
}

function awe_posts_content( $data ) {
	if ( 'Grid' == $data['style'] ) {
		awe_posts_content_grid( $data );
	} else {
		awe_posts_content_list( $data );
	}
}


function awe_content_loadmore_ajax() {
	$content = new Awe_Grid_content;
	$tax = 		$_GET['taxonomy'];
	$cats  = $_GET['cats'];
	$cats  = explode( ',', $cats );
	$page  = intval( $_GET['page'] );
	$num   = intval( $_GET['num'] );
	$col = intval( $_GET['col'] );
	// $size = $_GET['size'];
	$style = intval( $_GET['style'] );
	ob_start();
	print $content->awe_get_only_list( $tax, $cats, $style, $page, $num , $col );
	$output['content'] = ob_get_clean();
	echo json_encode( $output );
	wp_die();
}
add_action( 'wp_ajax_content_load_more', 'awe_content_loadmore_ajax' );
add_action( 'wp_ajax_nopriv_content_load_more', 'awe_content_loadmore_ajax' );
