<?php

/**
 * Created by PhpStorm.
 * User: Kai
 * Date: 7/9/2015
 * Time: 4:00 PM
 */

if ( ! class_exists( 'Awe_Gallery_Shortcode' ) ) {

	class Awe_Gallery_Shortcode {
		protected $cat;
		protected $num;
		protected $load;
		protected $size;
		protected $column;

		public function __construct() {
			add_action( 'wp_ajax_gallery_load_more', array( $this, 'awe_gallery_loadmore_ajax' ) );
			add_action( 'wp_ajax_nopriv_gallery_load_more', array( $this, 'awe_gallery_loadmore_ajax' ) );
		}

		/**
		 * Get The List Item Filter by Term
		 *
		 * @param $term
		 */
		public function awe_single_gallery_filter( $term ) {
			// If there was an error, continue to the next term.
			$term_link = get_term_link( $term );
			if ( is_wp_error( $term_link ) ) {
				return;
			}
			echo '<li><a href="' . $term_link . '" data-filter=".' . $term->slug . '">' . $term->name . '</a></li>';
		}

		/**
		 * Show the top filter of taxonomy
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_top_gallery_filter() {
			$cats = $this->cat;
			?>
			<!--FILTER -->
			<div class="gallery-cat text-center">
				<ul class="list-inline">
					<li class="active"><a href="#" data-filter="*"><?php echo esc_html__( 'All', 'hillter' ); ?></a></li>
					<?php
					if ( sizeof( $cats ) == 1 && $cats[0] == 'all' ) {
						$terms = get_terms( array( 'gallery_cat' ), array( 'hide_empty' => false ) );
						foreach ( $terms as $item ) :
							print $this->awe_single_gallery_filter( $item );
						endforeach;
					} else {

						foreach ( $cats as $item ) :
							$terms = get_term_by( 'term_taxonomy_id', $item, 'gallery_cat' );
							print $this->awe_single_gallery_filter( $terms );
						endforeach;
					}
					?>
				</ul>
			</div>
			<!--END / FILTER -->
		<?php
		}

		/**
		 * Check if post using gallery shortcode or youtube embed
		 *
		 * @return Array
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_check_gallery_content() {

			global $shortcode_tags;
			$output = array();

			// Check video
			// Make a copy of global shortcode tags - we'll temporarily overwrite it.
			$theme_shortcode_tags = $shortcode_tags;

			// The shortcodes we're interested in.
			$shortcode_tags = array(
				'video' => $theme_shortcode_tags['video'],
				'embed' => $theme_shortcode_tags['embed'],
			);
			// Get the absurd shortcode regexp.
			$video_regex = '#' . get_shortcode_regex() . '#i';

			// Restore global shortcode tags.
			$shortcode_tags = $theme_shortcode_tags;

			$pattern_array = array( $video_regex );

			// Get the patterns from the embed object.
			if ( ! function_exists( '_wp_oembed_get_object' ) ) {
				include ABSPATH . WPINC . '/class-oembed.php';
			}
			$oembed        = _wp_oembed_get_object();
			$pattern_array = array_merge( $pattern_array, array_keys( $oembed->providers ) );

			// Or all the patterns together.
			$pattern = '#(' . array_reduce( $pattern_array, array( $this, 'reduce_value' ) ) . ')#is';

			// Simplistic parse of content line by line.
			$lines = explode( "\n", get_the_content() );
			foreach ( $lines as $line ) {
				$line = trim( $line );
				if ( preg_match( $pattern, $line, $matches ) ) {
					$output['name'] = 'video';
					$output['data'] = $matches[0];
					break;
				}
			}

			// Check Gallery

			$content = get_the_content();
			// Check if using gallery content
			$pattern = get_shortcode_regex();
			preg_match( '/' . $pattern . '/s', $content, $matches ); // Extract shortcode gallery content
			if ( $matches && $matches[2] == 'gallery' ) :
				$id_str = shortcode_parse_atts( $matches[0] );
				preg_match( '/\ids=.(.*).\]/', $id_str[1], $m ); // Get gallery IDs string
				$output['name'] = 'gallery';
				$output['data'] = $m[1];
			endif;

			return $output; // Return array Video / Gallery

		}

		public function reduce_value( $carry, $item ) {
			if ( strpos( $item, '#' ) === 0 ) {
				// Assuming '#...#i' regexps.
				$item = substr( $item, 1, - 2 );
			} else {
				// Assuming glob patterns.
				$item = str_replace( '*', '(.+)', $item );
			}

			return $carry ? $carry . ')|(' . $item : $item;
		}

		/**
		 * Generate Ouput HTML Popup from Gallery Shortcode
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_get_popup_content_from_shortcode($size) {
			ob_start();
			$input     = $this->awe_check_gallery_content();
			$thumb_url = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), 'full' );
			if ( isset( $input['name'] ) && $input['name'] == 'gallery' ) {
				$g_content = '';
				$content   = get_the_content();
				// Check if using gallery content
				$pattern = get_shortcode_regex();
				preg_match( '/' . $pattern . '/s', $content, $matches ); // Extract shortcode gallery content
				if ( $matches && $matches[2] == 'gallery' ) :
					$id_str = shortcode_parse_atts( $matches[0] );
					preg_match( '/\ids=.(.*).\]/', $id_str[1], $m ); // Get gallery IDs string
					$ids = explode( ',', $m[1] ); // Convert id string to array

					if ( ! empty( $ids ) ) {
						foreach ( $ids as $item ) {
							$img = wp_get_attachment_image_src( $item, 'full' );
							$g_content .= '<a href="' . $img[0] . '" title="' . get_the_title() . '"></a>';
						}
					}
					$photos = 1;
					if ( count( $ids ) > 0 ) {
						$photos = count( $ids ) + 1;
					}
				endif;
				echo '<a href = "' . $thumb_url[0] . '" class="gallery-popup mfp-image" title = "' . get_the_title() . '" >
							' . get_the_post_thumbnail( get_the_ID(), $size ) . '
						</a>' . $g_content . '<h6 class="text">' . get_the_title() . '<span class="num_photos">Total '.$photos.' photos</span></h6>';

			} elseif ( isset( $input['name'] ) && $input['name'] == 'video' ) {
				echo '<a href = "' . $input['data'] . '" class="gallery-popup mfp-iframe" title = "' . get_the_title() . '" >
							' . get_the_post_thumbnail() . '
						</a><h6 class="text">' . get_the_title() . '</h6>';
			} else {
				echo '<a href = "' . $thumb_url[0] . '" class="gallery-popup mfp-image" title = "' . get_the_title() . '" >
							' . get_the_post_thumbnail() . '
						</a><h6 class="text">' . get_the_title() . '</h6>';
			}
			return ob_get_clean();
		}

		/**
		 * Show the single gallery
		 *t
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */

		public function awe_get_single_gallery(  $k , $size, $column) {
			$gallery_item_content = $this->awe_get_popup_content_from_shortcode( $size );
			$terms                = get_the_terms( get_the_ID(), 'gallery_cat' );
			$tag                  = '';
			
			if ( ! empty( $terms ) ) {
				foreach ( $terms as $term ) {
					$tag .= ' ' . $term->slug;
				}
			}
			
			echo '<div class="item-isotope col-xs-6 col-sm-4' . $tag  . ' '.$column . '">
				<div class="gallery_item">
					' . $gallery_item_content . '
				</div>
			</div>';
		}

		public function awe_gallery_loadmore( $data = '' ) {
			$display_none = (isset($data['max'])&&$data['max']==1) ? ' style=display:none' : '';
			?>
			<div class="our-gallery text-center js-loadmore"<?php echo esc_attr($display_none);?>>
				<a class="more awe-btn awe-btn-6" href="#" data-cats="<?php echo esc_attr( $data['cats'] ); ?>"
					data-page="<?php echo esc_attr( $data['page'] ); ?>"
					data-max="<?php echo esc_attr( $data['max'] ); ?>"
					data-num="<?php echo esc_attr( $data['num'] ); ?>"
					data-size="<?php echo esc_attr( $data['size'] ); ?>"
					data-column="<?php echo esc_attr( $data['column'] ); ?>"
				><?php esc_html_e( 'View More', 'hillter' ); ?></a>
			</div>
			<?php
		}


		public function awe_get_only_list( $cat = 1, $page = 1, $num = 12 , $size='thumbnail', $column = 4) {
			$num   = isset( $this->num ) ? $this->num : $num;
			$cats  = isset( $this->cat ) ? $this->cat : $cat;
			$size  = isset( $this->size ) ? $this->size : $size;
			$column  = isset( $this->column ) ? $this->column : $column;
			$page  = isset( $page ) ? $page : 1;
			$args  = array();
			$args['post_type'] = 'gallery';

			if ( ! empty( $cats ) ) :
				$args['tax_query'] = array(
					array(
						'taxonomy' => 'gallery_cat',
						'field'    => 'term_id',
						'terms'    => $cats,
					),
				);
			endif;

			$args['posts_per_page'] = $num;
			$args['paged']          = $page;
			$q                      = new WP_Query( $args );
			$max                    = 0;

			if ( $q->have_posts() ) :
				$max = $q->max_num_pages;
				$k   = 0;
				while ( $q->have_posts() ) : $q->the_post();
					$this->awe_get_single_gallery( $k, $size, $column );
					$k ++;
				endwhile;
				wp_reset_postdata();
			endif;

			if ( isset( $this->num ) ) :
				$load['page']  = $page;
				$load['max']   = $max;
				$cats          = implode( ',', $cats );
				$load['cats']  = $cats;
				$load['num']   = $num;
				$load['size'] = $size;
				$load['column'] = $column;
				$this->load    = $load;
			endif;
		}

		/**
		 * Show the list gallery
		 *
		 * @param $cat
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_get_list_gallery(
			$class_column, $class_padding, $size
		) {
			?>
			<!-- GALLERY CONTENT -->
			<div class="gallery-content <?php echo esc_attr( $class_padding ); ?>">
				<div class="row">
					<div class="gallery-isotope">
						<!-- ITEM SIZE -->
						<div class="item-size col-xs-6 col-sm-4 <?php echo esc_attr( $this->column ); ?>"></div>
						<!-- END / ITEM SIZE -->
						<?php print $this->awe_get_only_list(); ?>
					</div>
				</div>
				<?php
				$load = $this->load;
				print $this->awe_gallery_loadmore( $load ); // Load in the first time without ajax ?>
			</div>
			<!-- GALLERY CONTENT -->
			<?php
		}


		public function awe_gallery_loadmore_ajax() {
			$cats  = $_GET['cats'];
			$cats  = explode( ',', $cats );
			$page  = intval( $_GET['page'] );
			$num   = intval( $_GET['num'] );
			$size = $_GET['size'];
			$column = $_GET['column'];
			ob_start();
			print $this->awe_get_only_list( $cats, $page, $num , $size, $column );
			$output['content'] = ob_get_clean();
			echo json_encode( $output );
			wp_die();
		}

		/**
		 * Show the list gallery include fillter
		 *
		 * @return HTML
		 * @package Hillter
		 * @author Kai
		 * @since 1.0.0
		 */
		public function awe_the_gallery( $title = '', $cat = '', $num = 12, $column = 4, $size, $no_padding = false ) {
			$cat           = explode( ',', $cat );
			$this->cat     = $cat;
			$this->num     = $num;
			$this->size 	= $size;
			switch ( $column ) {
				case '1':
					$class_column  = 'col-md-12';
					break;
				case '2':
					$class_column  = 'col-md-6';
					break;
				case '3':
					$class_column  = 'col-md-4';
					break;
				case '4':
					$class_column  = 'col-md-3';
					break;
				case '5':
					$class_column  = 'col-md-15';
					break;
				case '6':
					$class_column  = 'col-md-2';
					break;
			}
			$this->column = $class_column;
			$class_padding = ( $no_padding == true ) ? 'no-padding' : '';
			echo '<div class="gallery">';
			// echo '<h2 class="heading text-center">' . $title . '</h2>';
			$this->awe_top_gallery_filter(); // Get top fillter
			print $this->awe_get_list_gallery( $class_column, $class_padding, $size ); // Get content list gallery
			echo '</div > ';
		}
	}

	new Awe_Gallery_Shortcode;
}
